/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.xyzviewer;

import io.fair_acc.chartfx.XYChart;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Material;
import javax.inject.Inject;
import us.hebi.gui.lib.aa;
import us.hebi.gui.lib.aab;
import us.hebi.gui.lib.aos;
import us.hebi.gui.lib.aro;
import us.hebi.gui.lib.ase;
import us.hebi.gui.lib.asm;
import us.hebi.gui.lib.asq;
import us.hebi.gui.lib.awg;
import us.hebi.gui.lib.azi;
import us.hebi.gui.lib.azw;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.baq;
import us.hebi.gui.lib.bar;
import us.hebi.gui.lib.bat;
import us.hebi.gui.lib.bci;
import us.hebi.gui.views.logviewer.hebilog.HebiLogContent;
import us.hebi.gui.views.logviewer.hebilog.HebiLogFeedback;
import us.hebi.gui.views.logviewer.hebilog.XyzLogData;
import us.hebi.gui.views.logviewer.state.ChartList;

public class XyzViewerPresenter
extends azi {
    @FXML
    AnchorPane rootPane;
    @FXML
    Pane settingsPane2d;
    @FXML
    Pane settingsPane3d;
    @FXML
    AnchorPane pane3d;
    @FXML
    AnchorPane chartPane;
    @Inject
    aro properties;
    @Inject
    HebiLogContent logContent;
    aab hrdf;
    ase robotModelFbk;
    ase robotModelCmd;
    asm fbkLine;
    asm cmdLine;
    DoubleProperty selectedTime = new SimpleDoubleProperty(0.0);
    azw timer = azw.a(d2 -> this.selectedTime.set(this.selectedTime.get() + d2));
    final asq world = new asq();
    final aos menu;
    final aos chartMenu;

    public XyzViewerPresenter() {
        this.menu = this.world.a.a(false);
        this.chartMenu = new aos().a(false);
    }

    @Override
    public void initializeFx() {
        bar.e((Parent)this.rootPane);
        baq.c((Parent)this.rootPane);
        bat.f((Parent)this.rootPane);
        Platform.runLater(() -> this.menu.getScene().getWindow().setOnCloseRequest(windowEvent -> System.exit(0)));
        this.setupCharts2d();
        this.setupWorld3d();
        this.settingsPane3d.getChildren().setAll((Object[])new Node[]{this.menu});
        azx.c(this.menu);
        this.settingsPane3d.requestFocus();
        this.settingsPane2d.getChildren().setAll((Object[])new Node[]{this.chartMenu});
        azx.c(this.chartMenu);
        this.selectedTime.addListener(observable -> this.updateTime());
        BooleanProperty booleanProperty = this.chartMenu.a("Play", false);
        booleanProperty.addListener((observableValue, bl2, bl3) -> this.timer.f((boolean)bl3));
        Platform.runLater(() -> {
            KeyCombination.Modifier modifier = KeyCombination.SHORTCUT_DOWN;
            KeyCodeCombination keyCodeCombination = new KeyCodeCombination(KeyCode.SPACE, new KeyCombination.Modifier[]{modifier});
            this.rootPane.getScene().addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new bci((KeyCombination)keyCodeCombination, booleanProperty));
        });
    }

    private void updateTime() {
        double d2 = this.selectedTime.get();
        if (!Double.isFinite(d2)) {
            return;
        }
        if (!this.logContent.hasValidFeedback()) {
            return;
        }
        HebiLogFeedback hebiLogFeedback = this.logContent.getFeedback();
        int n2 = hebiLogFeedback.getIndexAt(d2);
        this.cmdLine.v(n2);
        this.fbkLine.v(n2);
        for (int i2 = 0; i2 < hebiLogFeedback.getNumJoints(); ++i2) {
            this.robotModelFbk.b(i2, hebiLogFeedback.position[i2].a(n2));
            this.robotModelCmd.b(i2, hebiLogFeedback.positionCmd[i2].a(n2));
        }
    }

    private void setupCharts2d() {
        ChartList chartList = new ChartList().setTime(this.logContent.getFeedback().time).addXyzErrorChart(() -> "", "XYZ Error", "mm", 0.0, 50.0, this.logContent.getXyzData().xyzPositionCmd, this.logContent.getXyzData().xyzPosition).addXyzCommandChart(() -> "", "XYZ Position", "mm", -50.0, 50.0, this.logContent.getXyzData().xyzPositionCmd, this.logContent.getXyzData().xyzPosition).addErrorChart(() -> "", "Position Error", "rad", -0.1, 0.1, this.logContent.getFeedback().positionCmd, this.logContent.getFeedback().position).addCommandChart(() -> "", "Position", "rad", 1.5707963267948966, 1.5707963267948966, this.logContent.getFeedback().positionCmd, this.logContent.getFeedback().position);
        for (int i2 = 0; i2 < this.logContent.getNumJoints(); ++i2) {
            chartList.getVisibilityState().deviceNameProperty(i2).set((Object)this.logContent.getDeviceName(i2));
        }
        XYChart xYChart = (XYChart)chartList.getCharts().get(0).getChart();
        chartList.getIndicatorTime().bindBidirectional((Property)this.selectedTime);
        xYChart.getGridRenderer().getVerticalMajorGrid().visibleProperty().bind((ObservableValue)this.properties.o);
        xYChart.getGridRenderer().getHorizontalMajorGrid().visibleProperty().bind((ObservableValue)this.properties.o);
        azx.c(xYChart);
        BooleanProperty booleanProperty = this.chartMenu.a("Cartesian", false);
        BooleanProperty booleanProperty2 = this.chartMenu.a("Error", false);
        InvalidationListener invalidationListener = observable -> {
            int n2 = booleanProperty.get() ? (booleanProperty2.get() ? 0 : 1) : (booleanProperty2.get() ? 2 : 3);
            this.chartPane.getChildren().setAll((Object[])new Node[]{chartList.getCharts().get(n2).getChart()});
        };
        booleanProperty.addListener(invalidationListener);
        booleanProperty2.addListener(invalidationListener);
        invalidationListener.invalidated(null);
    }

    private void setupWorld3d() {
        this.pane3d.getChildren().setAll((Object[])new Node[]{this.world});
        this.robotModelFbk = new ase(this.logContent.getXmlContent());
        this.robotModelFbk.A.bind((ObservableValue)this.world.e.visibleProperty());
        this.robotModelFbk.B.bind((ObservableValue)this.menu.a("CoM Axes", false));
        String string = "Models";
        this.robotModelFbk.C.bind((ObservableValue)this.menu.a("Models", true));
        this.robotModelCmd = new ase(this.logContent.getXmlContent());
        this.robotModelCmd.A.set(false);
        this.robotModelCmd.B.set(false);
        this.robotModelCmd.C.bind((ObservableValue)this.robotModelFbk.C);
        this.robotModelCmd.c.visibleProperty().bind((ObservableValue)this.menu.a("Command Overlay", false));
        aa.a((Node)this.robotModelCmd.c, (Material)ase.c);
        XyzLogData xyzLogData = this.logContent.getXyzData();
        this.fbkLine = new asm(xyzLogData.xyzPosition, awg.f);
        this.cmdLine = new asm(xyzLogData.xyzPositionCmd, awg.e);
        string = "Fbk Line";
        this.fbkLine.visibleProperty().bind((ObservableValue)this.menu.a("Fbk Line", true));
        string = "Cmd Line";
        this.cmdLine.visibleProperty().bind((ObservableValue)this.menu.a("Cmd Line", true));
        BooleanProperty booleanProperty = this.menu.a("Draw All", true);
        this.fbkLine.L.bind((ObservableValue)booleanProperty);
        this.cmdLine.L.bind((ObservableValue)booleanProperty);
        asq asq2 = this.world;
        asq2.d.getChildren().setAll((Object[])new Node[]{this.robotModelFbk.c, this.robotModelCmd.c, this.fbkLine, this.cmdLine});
    }
}

