/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.rima;

import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.dataset.DataSet;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Orientation;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Slider;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Box;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Rotate;
import javax.inject.Inject;
import us.hebi.gui.lib.aa;
import us.hebi.gui.lib.amx;
import us.hebi.gui.lib.anw;
import us.hebi.gui.lib.aoz;
import us.hebi.gui.lib.apa;
import us.hebi.gui.lib.apw;
import us.hebi.gui.lib.apx;
import us.hebi.gui.lib.aqa;
import us.hebi.gui.lib.aqh;
import us.hebi.gui.lib.aqi;
import us.hebi.gui.lib.aro;
import us.hebi.gui.lib.asj;
import us.hebi.gui.lib.asp;
import us.hebi.gui.lib.ast;
import us.hebi.gui.lib.asv;
import us.hebi.gui.lib.avk;
import us.hebi.gui.lib.awh;
import us.hebi.gui.lib.awk;
import us.hebi.gui.lib.axp;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.bbo;

public class RimaPresenter {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private Pane root;
    @FXML
    private Pane pane3d;
    @FXML
    private Pane pane2d;
    @FXML
    private Pane panePaut;
    @FXML
    private Pane paneControls;
    @FXML
    private Pane paneChart;
    @FXML
    private ImageView pautView;
    @FXML
    private CheckBox selectionEnabled;
    @FXML
    private CheckBox selectionFlipped;
    @FXML
    private Slider colorSliderMin;
    @FXML
    private Slider colorSliderMax;
    @FXML
    private Slider smartMinSlider;
    @FXML
    private Button saveGridImgButton;
    @FXML
    private Button saveRawImgButton;
    apx mappedSurface = null;
    apw gridData = new apw();
    apa mappedPoint = new apa();
    final Property<aqa> surfaceMap = new SimpleObjectProperty();
    final asj surface3d = new asj();
    final asj probeMesh = new asj();
    final Box probeModel = new bbo();
    final ast probe3d;
    final asv world;
    static final double PROBE_SIZE_M = 0.053;
    awk chartTrace;
    XYChart chart;
    @Inject
    aro properties;
    @Inject
    aoz MAPS;
    @Inject
    aqi tfmImageAnalysis;
    @Inject
    avk fileChooser;

    public RimaPresenter() {
        this.probe3d = new ast(new Node[]{this.probeMesh.d, this.probeModel, asp.a(10.0)});
        this.world = new asv(new Node[]{this.surface3d.d, this.probe3d}).a();
        this.chartTrace = awk.a("depth", 1000, new String[0]);
        this.chart = new XYChart();
        this.chart.getPlugins().add((Object)awh.a());
        this.chart.setLegendVisible(false);
        this.chartTrace.addStyleClasses(new String[]{axp.c.F()});
        this.chart.getRenderers().setAll((Object[])new Renderer[]{awh.a()});
        this.chart.getDatasets().add((Object)this.chartTrace);
        Axis axis = this.chart.getFirstAxis(Orientation.HORIZONTAL);
        axis.setUnit("mm");
        axis.setName("x");
        axis.setTickUnit(10.0);
        axis.setAutoRanging(false);
        axis.setAutoGrowRanging(false);
        Axis axis2 = this.chart.getFirstAxis(Orientation.VERTICAL);
        axis2.setUnit("mm");
        axis2.setName("z");
        axis2.setTickUnit(5.0);
        axis2.setAutoRanging(false);
        axis2.setAutoGrowRanging(false);
        axis.set(0.0, anw.a.g(0.053));
        axis2.set(0.0, 20.0);
    }

    @FXML
    void initialize() throws IOException {
        azx.b(this::initializeOnFxThread);
    }

    private void initializeOnFxThread() {
        azx.a(bl2 -> {
            if (!bl2) {
                apw apw2 = this.gridData;
                if (!apw2.aE()) {
                    Arrays.fill(apw2.ax, 0, apw2.j(), 0);
                    Arrays.fill(apw2.d, 0, apw2.j(), false);
                    apw2.aH = false;
                    apw2.aI = false;
                    apw2.a.bt();
                    apw2.a.a();
                }
                this.gridData.a(this.mappedSurface);
            }
        }, (ObservableBooleanValue)this.selectionEnabled.selectedProperty());
        azx.a(d2 -> {
            double d3 = d2;
            apw apw2 = this.gridData;
            this.gridData.a.dS = d3;
            apw2.aI = true;
            this.gridData.aZ();
            this.gridData.a(this.mappedSurface);
        }, (ObservableDoubleValue)this.colorSliderMin.valueProperty());
        azx.a(d2 -> {
            double d3 = d2;
            apw apw2 = this.gridData;
            this.gridData.a.F = d3;
            apw2.aI = true;
            this.gridData.aZ();
            this.gridData.a(this.mappedSurface);
        }, (ObservableDoubleValue)this.colorSliderMax.valueProperty());
        azx.a(d2 -> {
            apw apw2 = this.gridData;
            apw2.cJ = d2 < 0.0 ? 0.0 : (d2 > 100.0 ? 1.0 : d2 / 100.0);
            apw2.aI = true;
            this.gridData.aZ();
            this.gridData.a(this.mappedSurface);
        }, (ObservableDoubleValue)this.smartMinSlider.valueProperty());
        this.probeMesh.d.diffuseMapProperty().bind((ObservableValue)this.pautView.imageProperty());
        this.probeMesh.e.diffuseMapProperty().bind((ObservableValue)this.pautView.imageProperty());
        this.tfmImageAnalysis.f(this::updatePlots);
        this.paneChart.getChildren().add((Object)this.chart);
        azx.c(this.chart);
        this.world.a(this.pane3d);
        Optional.ofNullable(RimaPresenter.class.getResource("assets/aluminum-dark.jpg")).map(URL::toExternalForm).map(Image::new).ifPresent(this.surface3d::a);
        this.MAPS.c(this.probe3d::b);
        this.MAPS.d(apa2 -> {
            this.mappedPoint.a((apa)apa2);
            if (this.mappedSurface != null) {
                this.mappedSurface.a((apa)apa2, 0.053);
            }
        });
        this.MAPS.b(aqa2 -> {
            this.surfaceMap.setValue(aqa2);
            this.surface3d.a((Mesh)aqa2.a());
            Point3D point3D = aa.a((Mesh)aqa2.a());
            azx.a((Node)this.world.e, point3D);
            this.mappedSurface = apx.a(aqa2, 800.0, 400.0);
            this.surface3d.d.diffuseMapProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.selectionFlipped.selectedProperty()).then(this.mappedSurface.b).otherwise(this.mappedSurface.a));
            this.surface3d.e.diffuseMapProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.selectionFlipped.selectedProperty()).then(this.mappedSurface.a).otherwise(this.mappedSurface.b));
            this.pane2d.getChildren().setAll((Object[])new Node[]{this.mappedSurface.a});
            apw apw2 = this.gridData;
            this.gridData.cI = 0.001;
            apw2.resize();
            aqa aqa3 = aqa2;
            apw2 = this.gridData;
            this.gridData.b = aqa3;
            apw2.resize();
            this.mappedSurface.m(0.01);
        });
        CompletableFuture.runAsync(() -> amx.b(1L, TimeUnit.SECONDS)).thenRun(this.MAPS::a);
    }

    public void updatePlots(aqh aqh2) {
        TriangleMesh triangleMesh;
        if (aqh2.a != null) {
            triangleMesh = aqh2.a;
            Point3D point3D = aa.a((Mesh)triangleMesh);
            this.probeMesh.d.setTranslateX(-point3D.getX());
            this.probeMesh.d.setRotationAxis(Rotate.Z_AXIS);
            this.probeMesh.d.setRotate(-90.0);
            this.probeMesh.a((Mesh)triangleMesh);
        }
        if (aqh2.aJ) {
            aqh aqh3 = aqh2;
            triangleMesh = (aqh3.aJ ? aqh3.c : aqh3.b).a;
            this.pautView.setImage((Image)triangleMesh);
        }
        this.chartTrace.bM();
        if (aqh2.P() > 0) {
            aqh2.a(this.chartTrace::f);
            this.chartTrace.bL();
            if (this.mappedPoint.isInContact() && this.selectionEnabled.isSelected()) {
                aqh2.a(this::addProbeMeasurement);
                this.gridData.aZ();
                this.gridData.a(this.mappedSurface);
            }
        }
        this.chart.getDatasets().setAll((Object[])new DataSet[]{this.chartTrace});
    }

    private void addProbeMeasurement(double d2, double d3) {
        double d4 = d2 / 1000.0 - 0.0265;
        if (this.selectionFlipped.isSelected()) {
            d4 = -d4;
        }
        double d5 = d4 * this.mappedPoint.cw + (double)this.mappedPoint.o;
        double d6 = d4 * this.mappedPoint.cx + (double)this.mappedPoint.p;
        double d7 = d3;
        double d8 = d6;
        double d9 = d5;
        apw apw2 = this.gridData;
        if (!apw2.aE()) {
            int n2;
            int n3 = (int)(apw2.b.m(d9) * (double)apw2.ad);
            int n4 = (int)(apw2.b.n(d8) * (double)apw2.ac);
            if (n4 < 0 || n3 < 0 || n4 >= apw2.ac || n3 >= apw2.ad) {
                return;
            }
            int n5 = n3;
            int n6 = n4;
            apw apw3 = apw2;
            int n7 = n2 = n6 * apw3.ad + n5;
            int n8 = apw2.ax[n7];
            apw2.ax[n7] = n8 + 1;
            int n9 = n8 % 32;
            int n10 = n2;
            apw2.A[(n10 << 5) + n9] = d7;
            apw2.d[n2] = true;
            apw2.aH = true;
        }
    }
}

