/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps.utils;

import io.fair_acc.chartfx.marker.DefaultMarker;
import io.fair_acc.chartfx.renderer.spi.AbstractRendererXY;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.dataset.DataSet;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import us.hebi.gui.lib.anl;
import us.hebi.gui.lib.bjm;
import us.hebi.gui.lib.bjo;
import us.hebi.gui.lib.bjy;
import us.hebi.gui.lib.bka;
import us.hebi.gui.lib.caq;
import us.hebi.gui.views.maps.utils.MapsFeedbackDataSet;

public class MapsFeedbackRenderer
extends AbstractRendererXY<MapsFeedbackRenderer> {
    caq ascan;
    anl xToDisplay;
    anl yToDisplay;
    double ascanLineWidth = 2.0;
    double gateLineWidth = 2.0;
    double gateLineSideLength = 4.0;
    double refPosWidth = 4.0;

    @Override
    protected void render(GraphicsContext graphicsContext, DataSet dataSet, DataSetNode dataSetNode) {
        if (!(dataSet instanceof MapsFeedbackDataSet)) {
            return;
        }
        MapsFeedbackDataSet mapsFeedbackDataSet = (MapsFeedbackDataSet)dataSet;
        this.xToDisplay = d2 -> this.xAxis.getDisplayPosition(mapsFeedbackDataSet.xTransform.apply(d2));
        this.yToDisplay = d2 -> this.yAxis.getDisplayPosition(mapsFeedbackDataSet.yTransform.apply(d2));
        this.ascan = mapsFeedbackDataSet.utData.a;
        bjo bjo2 = mapsFeedbackDataSet.message.a.b;
        bka bka2 = mapsFeedbackDataSet.message.a.a;
        graphicsContext.save();
        this.drawAscan(graphicsContext, dataSetNode.getLineColor());
        if (bka2.cd()) {
            graphicsContext.setLineWidth(this.refPosWidth);
            graphicsContext.setStroke(dataSetNode.getMarkerColor());
            graphicsContext.setLineDashes(dataSetNode.getMarkerLineDashes());
            this.drawDashedVerticalLine(graphicsContext, bka2.du);
            graphicsContext.setLineDashes(dataSetNode.getLineDashes());
        }
        this.drawGate(graphicsContext, bjo2.a, bka2.a, bjo2.bG, 0, Color.RED);
        this.drawGate(graphicsContext, bjo2.b, bka2.b, bjo2.bG, bka2.a.dr, Color.GREEN);
        this.drawGate(graphicsContext, bjo2.c, bka2.c, bjo2.bG, bka2.b.dr, Color.BLUE);
        graphicsContext.restore();
    }

    private void drawAscan(GraphicsContext graphicsContext, Paint paint) {
        if (this.ascan.ax() == 0) {
            return;
        }
        graphicsContext.setLineWidth(this.ascanLineWidth);
        graphicsContext.setStroke(paint);
        graphicsContext.beginPath();
        graphicsContext.moveTo(this.xToDisplay.apply(0.0), this.yToDisplay.apply(this.ascan.a(0)));
        for (int i2 = 1; i2 < this.ascan.ax(); ++i2) {
            graphicsContext.lineTo(this.xToDisplay.apply(i2), this.yToDisplay.apply(this.ascan.a(i2)));
        }
        graphicsContext.stroke();
    }

    private void drawGate(GraphicsContext graphicsContext, bjm bjm2, bjy bjy2, boolean bl2, int n2, Color color) {
        if (bjm2.isEmpty()) {
            return;
        }
        if (!bl2) {
            n2 = 0;
        }
        double d2 = this.xToDisplay.apply(bjm2.dj + n2);
        double d3 = this.xToDisplay.apply(bjm2.dj + bjm2.dk + n2);
        double d4 = this.yToDisplay.apply(bjm2.dl);
        double d5 = this.yToDisplay.apply((double)bjm2.dl + this.gateLineSideLength);
        double d6 = this.yToDisplay.apply((double)bjm2.dl - this.gateLineSideLength);
        graphicsContext.setStroke((Paint)color);
        graphicsContext.setLineWidth(this.gateLineWidth);
        graphicsContext.strokeLine(d2, d4, d3, d4);
        graphicsContext.strokeLine(d2, d5, d2, d6);
        graphicsContext.strokeLine(d3, d5, d3, d6);
        if (!bjy2.isEmpty()) {
            DefaultMarker.drawCross(graphicsContext, this.xToDisplay.apply(bjy2.dr), d4, 8.0);
            DefaultMarker.drawEmptyCircle(graphicsContext, this.xToDisplay.apply(bjy2.ds), this.yToDisplay.apply(bjy2.dt), 8.0);
        }
    }

    private void drawDashedVerticalLine(GraphicsContext graphicsContext, int n2) {
        graphicsContext.strokeLine(this.xToDisplay.apply(n2), Math.min(this.yToDisplay.apply(-128.0), this.yToDisplay.apply(0.0)), this.xToDisplay.apply(n2), Math.max(this.yToDisplay.apply(127.0), this.yToDisplay.apply(0.0)));
    }

    @Override
    protected MapsFeedbackRenderer getThis() {
        return this;
    }
}

