/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps.components;

import java.io.File;
import java.util.Optional;
import java.util.UUID;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Mesh;
import javax.inject.Inject;
import lombok.Generated;
import org.controlsfx.validation.ValidationSupport;
import us.hebi.gui.b;
import us.hebi.gui.lib.aa;
import us.hebi.gui.lib.anw;
import us.hebi.gui.lib.aoy;
import us.hebi.gui.lib.aoz;
import us.hebi.gui.lib.apa;
import us.hebi.gui.lib.apx;
import us.hebi.gui.lib.aqa;
import us.hebi.gui.lib.asa;
import us.hebi.gui.lib.asj;
import us.hebi.gui.lib.asn;
import us.hebi.gui.lib.asq;
import us.hebi.gui.lib.ast;
import us.hebi.gui.lib.asv;
import us.hebi.gui.lib.atd;
import us.hebi.gui.lib.ate;
import us.hebi.gui.lib.azi;
import us.hebi.gui.lib.azj;
import us.hebi.gui.lib.azl;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.bcu;
import us.hebi.gui.lib.biw;
import us.hebi.gui.lib.bix;
import us.hebi.gui.lib.bku;
import us.hebi.gui.lib.bnv;
import us.hebi.gui.lib.can;
import us.hebi.gui.lib.jj;
import us.hebi.gui.lib.lj;
import us.hebi.gui.lib.xg;
import us.hebi.gui.views.maps.EncoderState;
import us.hebi.gui.views.maps.MapsAppState;
import us.hebi.gui.views.maps.MapsAppState$View;
import us.hebi.gui.views.maps.MapsCss;
import us.hebi.gui.views.maps.ScanningState;
import us.hebi.gui.views.scope.components.ParseUtils;

public class ScanningController
extends azi {
    @FXML
    private ToggleButton pauseToggle;
    @FXML
    private Pane pauseArea;
    @FXML
    private Pane pane2d;
    @FXML
    private Pane pane3d;
    @FXML
    private TextField resolutionField;
    @FXML
    private TextField distanceField;
    @FXML
    private Button startBtn;
    @FXML
    private Button cancelBtn;
    @FXML
    private Button restartBtn;
    @FXML
    private Button repeatBtn;
    @FXML
    private Button completeBtn;
    @FXML
    private Button backBtn;
    asn coverageImg;
    aoy coverageGrid = new aoy();
    apx mappedSurface = null;
    @Inject
    aoz maps;
    @Inject
    MapsAppState state;
    @Inject
    EncoderState encoderState;
    @Inject
    ScanningState scanState;
    @Inject
    ate notifications;
    final xg logWriter = xg.a();

    @Override
    public void initializeFx() {
        this.resolutionField.textProperty().bindBidirectional((Property)this.state.getString("scanResolution", "10"));
        this.distanceField.textProperty().bindBidirectional((Property)this.state.getString("scanMaxDistance", "30"));
        this.state.addUnitFields(this.resolutionField, this.distanceField);
        azx.b(() -> this.pauseArea.pseudoClassStateChanged(MapsCss.HIGHLIGHTED, !this.pauseToggle.selectedProperty().get()), new Observable[]{this.pauseToggle.selectedProperty()});
        this.pauseToggle.selectedProperty().bindBidirectional((Property)this.scanState.pausedProperty());
        SimpleObjectProperty simpleObjectProperty = new SimpleObjectProperty();
        asj asj2 = new asj();
        ast ast2 = MapsCss.createEndEffectorAxes3d();
        ast ast3 = new ast(new Node[]{ast2, asj2.d});
        ast ast4 = new ast(new Node[]{ast3, asq.a.a()});
        new asv(new Node[]{ast4}).a().a(this.pane3d);
        ImageView imageView = MapsCss.createView2d(this.pane2d);
        this.maps.b(arg_0 -> this.lambda$initializeFx$1((Property)simpleObjectProperty, asj2, ast3, imageView, arg_0));
        this.maps.d(apa2 -> {
            double d2;
            apa2.cv = d2 = this.coverageGrid.cv;
            this.scanState.setInContact(apa2.isInContact());
            if (this.state.isOnView(MapsAppState$View.Scanning) && this.mappedSurface != null) {
                if (this.state.getShowLiveMap()) {
                    this.mappedSurface.a((apa)apa2, this.state.getProbeWidth());
                }
                if (this.scanState.isActive().booleanValue() && this.scanState.isInContact()) {
                    boolean bl2;
                    apa apa3 = apa2;
                    aoy aoy2 = this.coverageGrid;
                    if (aoy2.aC && (asa.a(apa3.o, aoy2.r) || asa.a(apa3.p, aoy2.s))) {
                        aoy2.r = apa3.o - (float)aoy2.cq;
                        aoy2.a.a(aoy2.r);
                        aoy2.s = apa3.p - (float)aoy2.cs;
                        aoy2.b.a(aoy2.s);
                        aoy2.c.a(apa3.u);
                        jj jj2 = aoy2.a;
                        int n2 = jj2.M - 1;
                        int n3 = aoy2.q(n2);
                        int n4 = aoy2.r(n2);
                        if (aoy2.a.a(n3, n4) || (double)apa3.u > aoy2.cv) {
                            bl2 = false;
                        } else {
                            aoy2.a.f(n3, n4);
                            bl2 = true;
                        }
                    } else {
                        bl2 = false;
                    }
                    if (bl2 && this.state.getShowLiveMap()) {
                        this.redrawCoverage();
                    }
                }
            }
        });
        this.maps.c(bcu2 -> {
            if (this.state.isOnView(MapsAppState$View.Scanning) && this.mappedSurface != null) {
                ast2.b((bcu)bcu2);
            }
        });
        ValidationSupport validationSupport = azl.a();
        azl.a(validationSupport, this.resolutionField);
        azl.a(validationSupport, this.distanceField);
        azx.b(this::updateGrid, new Observable[]{this.resolutionField.textProperty(), this.distanceField.textProperty()});
        this.backBtn.setOnAction(this.state::previousView);
        SimpleBooleanProperty simpleBooleanProperty = new SimpleBooleanProperty(false);
        this.scanState.pausedProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$initializeFx$4((BooleanProperty)simpleBooleanProperty, arg_0, arg_1, arg_2));
        this.encoderState.encoderStartMessageProperty().addListener((observableValue, biw2, biw3) -> this.scanState.reset());
        this.startBtn.setOnAction(azx.a((BooleanProperty)simpleBooleanProperty, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (this.mappedSurface == null) {
                this.notifications.j("Scan cannot be started without a map.");
                return;
            }
            Optional.ofNullable(this.encoderState.getEncoderStartMessage()).ifPresent(biw2 -> {
                biw biw3 = biw2;
                aoz aoz2 = this.maps;
                aoz2.b.c().a().a(biw3);
                aoz aoz3 = aoz2;
                aoz3.a(aoz3.b, null);
            });
            this.startLogging();
            this.scanState.startScan();
        })));
        this.cancelBtn.setOnAction(azx.a((BooleanProperty)simpleBooleanProperty, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (this.notifications.k("Cancelling this scan will irrecoverably delete data. Do you want to delete this scan?")) {
                this.reset();
                this.cancelLogging();
                this.state.setActiveView(MapsAppState$View.Configuration);
            }
        })));
        this.restartBtn.setOnAction(azx.a((BooleanProperty)simpleBooleanProperty, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (this.notifications.k("Restarting will discard the current scan and begin a new scan on this same surface. Do you want to restart")) {
                this.reset();
                this.cancelLogging();
                this.maps.a(bix.b);
            }
        })));
        this.repeatBtn.setOnAction(azx.a((BooleanProperty)simpleBooleanProperty, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (this.notifications.k("Repeating will complete the current scan and begin a new scan on this same surface. Do you want to repeat?")) {
                this.reset();
                this.stopLogging().ifPresent(file -> atd.a(file, azx.a(actionEvent)));
                this.maps.a(bix.b);
            }
        })));
        this.completeBtn.setOnAction(azx.a((BooleanProperty)simpleBooleanProperty, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (this.notifications.k("Completing a scan will finish this scan and let you set up a new surface. Do you want to complete this scan?")) {
                this.reset();
                this.maps.a(bix.d);
                this.stopLogging().ifPresent(file -> atd.a(file, azx.a(actionEvent)));
                this.state.setActiveView(MapsAppState$View.Configuration);
            }
        })));
        this.updateGrid();
    }

    private void reset() {
        this.scanState.reset();
        this.coverageGrid.aS();
        this.redrawCoverage();
    }

    private void updateGrid() {
        Double d2 = ParseUtils.tryParseFiniteDouble(this.resolutionField);
        Double d3 = ParseUtils.tryParseFiniteDouble(this.distanceField);
        if (this.mappedSurface != null && d2 != null && d2 > 0.0) {
            this.mappedSurface.m(anw.b.f(d2));
        }
        if (d2 != null && d3 != null && d2 > 0.0 && d3 > 0.0) {
            boolean bl2;
            boolean bl3;
            double d4 = anw.b.f(d2);
            aoy aoy2 = this.coverageGrid;
            if (aoy2.cu != d4) {
                aoy2.cu = d4;
                aoy2.aR();
                bl3 = true;
            } else {
                bl3 = false;
            }
            boolean bl4 = false | bl3;
            d4 = anw.b.f(d3);
            aoy2 = this.coverageGrid;
            if (aoy2.cv != d4) {
                aoy2.cv = d4;
                aoy2.aR();
                bl2 = true;
            } else {
                bl2 = false;
            }
            if (bl4 | bl2) {
                this.redrawCoverage();
            }
        }
    }

    private void redrawCoverage() {
        lj lj2 = this.coverageGrid.a;
        if (lj2.j() == 0) {
            return;
        }
        if (this.coverageImg == null || this.coverageImg.cd != lj2.ad || this.coverageImg.ce != lj2.ac) {
            this.coverageImg = new asn((double)lj2.ad, (double)lj2.ac);
        }
        int n2 = asn.a(Color.WHITE);
        int n3 = asn.a(b.c);
        for (int i2 = 0; i2 < lj2.ad; ++i2) {
            for (int i3 = 0; i3 < lj2.ac; ++i3) {
                int n4 = lj2.a(i3, i2) ? n3 : n2;
                this.coverageImg.f(i2, i3, n4);
            }
        }
        aoy aoy2 = this.coverageGrid;
        aoy aoy3 = aoy2;
        aoy3 = this.coverageGrid;
        this.mappedSurface.a((Image)this.coverageImg.a().a, this.coverageGrid.cq, this.coverageGrid.cs, (double)aoy2.L() * aoy3.cu, (double)aoy3.K() * aoy3.cu);
    }

    private void startLogging() {
        try {
            UUID uUID = UUID.randomUUID();
            bnv bnv2 = xg.a();
            bnv2.a("MAPS Feedback Log").a().a(azj.b.X).b(azj.b.W);
            this.logWriter.a(new File(this.state.getLogDirectory(), String.valueOf(uUID) + ".mapslog"), bnv2);
            this.maps.a(this.logWriter);
            aoz aoz2 = this.maps;
            bku bku2 = bku.a();
            bku2.c().a().d().a(true);
            aoz2.a(bku2, null);
            return;
        }
        catch (Exception exception) {
            this.notifications.f(exception);
            return;
        }
    }

    private Optional<File> stopLogging() {
        try {
            this.maps.a((xg)null);
            return Optional.ofNullable(this.logWriter.b());
        }
        catch (Exception exception) {
            this.notifications.f(exception);
            return Optional.empty();
        }
    }

    private void cancelLogging() {
        this.stopLogging().map(File::delete).ifPresent(bl2 -> can.c(bl2, "Failed to delete log file"));
    }

    @Generated
    public MapsAppState getState() {
        return this.state;
    }

    @Generated
    public EncoderState getEncoderState() {
        return this.encoderState;
    }

    @Generated
    public ScanningState getScanState() {
        return this.scanState;
    }

    private /* synthetic */ void lambda$initializeFx$4(BooleanProperty booleanProperty, ObservableValue observableValue, Boolean bl2, Boolean bl3) {
        if (!booleanProperty.get()) {
            this.maps.a(bl3 != false ? null : this.logWriter);
            this.maps.a(bl3 != false ? bix.e : bix.f);
        }
    }

    private /* synthetic */ void lambda$initializeFx$1(Property property, asj asj2, ast ast2, ImageView imageView, aqa aqa2) {
        aqa aqa3 = aqa2;
        aoy aoy2 = this.coverageGrid;
        this.coverageGrid.cq = aqa3.cQ;
        aoy2.cs = aqa3.cR;
        aoy2.cr = aqa3.cS;
        aoy2.ct = aqa3.cT;
        aoy aoy3 = aoy2;
        aoy3.s = Float.NaN;
        aoy3.r = Float.NaN;
        aoy2.aC = true;
        aoy2.aS();
        aoy2.aR();
        property.setValue((Object)aqa2);
        asj2.a((Mesh)aqa2.a());
        azx.a((Node)ast2, aa.a((Mesh)aqa2.a()));
        this.mappedSurface = apx.a(aqa2, 1000.0, 1000.0);
        asj2.d.diffuseMapProperty().bind(this.mappedSurface.a);
        asj2.e.diffuseMapProperty().bind(this.mappedSurface.b);
        imageView.imageProperty().bind(this.mappedSurface.a);
        this.updateGrid();
        this.scanState.reset();
        this.stopLogging();
    }
}

