/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.mapslog.data;

import java.util.function.Supplier;
import us.hebi.gui.lib.aoi;
import us.hebi.gui.lib.awh;
import us.hebi.gui.lib.awz;
import us.hebi.gui.lib.axp;
import us.hebi.gui.lib.bjg;
import us.hebi.gui.lib.bkk;
import us.hebi.gui.lib.bkw;
import us.hebi.gui.lib.blm;
import us.hebi.gui.lib.blo;
import us.hebi.gui.lib.bni;
import us.hebi.gui.lib.bnr;
import us.hebi.gui.lib.bnv;
import us.hebi.gui.lib.caw;
import us.hebi.gui.lib.cay;
import us.hebi.gui.lib.jh;
import us.hebi.gui.lib.xa;
import us.hebi.gui.views.logviewer.state.ChartList;
import us.hebi.gui.views.logviewer.state.TDoubleArrayListRegistry;

public class MapsLogFeedback
extends xa {
    private static final Supplier<String> poseCategory = () -> "World Pose";
    private static final Supplier<String> MapPointCategory = () -> "Mapped Point";
    private static final Supplier<String> utCategory = () -> "UT Data";
    private static final Supplier<String> RobotCategory = () -> "Robot";
    private static final Supplier<String> RuntimeCategory = () -> "Runtime";
    long startTime = 0L;
    int numJoints = -1;
    int maxEntries = -1;
    public jh time;
    public jh mapX;
    public jh mapY;
    public jh mapTheta;
    public jh mapDistance;
    public jh mapAngularDistance;
    public jh[] mapXyz;
    public jh runtimeAmbientTemperature;
    public jh runtimeBatteryVoltage;
    public jh runtimePcResidentMemoryUsage;
    public jh runtimePcVirtualMemoryUsage;
    public jh runtimePcUserCpuUsage;
    public jh runtimePcKernelCpuUsage;
    public jh runtimePcTemperature;
    public jh runtimePcVoltage;
    public jh runtimeMainCycleTimeMs;
    public jh runtimeMainBusyTimeMs;
    public jh runtimeCyclesSincePositionSourceData;
    public jh utThicknessSamples;
    public jh[] poseTranslation;
    public jh[] poseOrientation;
    public jh poseDelay;
    public jh[] position;
    public jh[] velocity;
    public jh[] power;
    public jh[] sequence;
    public jh[] rxSequence;
    public jh[] temperature;
    public jh[] voltage;
    public jh[] roundTripTime;
    public jh[] hwResponseTime;
    public jh[] transmitTimeDelta;
    public jh[] packetLoss;
    public jh[] firstOrientation;
    private final blm prevRobotFbk = blm.a();

    public MapsLogFeedback() {
        this.init(8192);
    }

    public MapsLogFeedback init(int n2) {
        this.maxEntries = n2;
        this.resize();
        return this;
    }

    private jh[] resizeGroup(jh[] jhArray) {
        return this.resizeMultiple(jhArray, this.numJoints);
    }

    private jh[] resizeMultiple(jh[] jhArray, int n2) {
        return TDoubleArrayListRegistry.resizeMultiple(jhArray, n2, this.maxEntries);
    }

    private jh resizeSingle(jh jh2) {
        return TDoubleArrayListRegistry.resizeSingle(jh2, this.maxEntries);
    }

    @Override
    public void onHeader(bnv bnv2) {
        if (bnv2.eF()) {
            this.startTime = bnv2.aT;
            return;
        }
        if (bnv2.eE()) {
            this.startTime = bnv2.Y;
        }
    }

    @Override
    public void onResponse(bnr bnr2, bkw bkw2, int n2) {
        if (!bkw2.cz()) {
            return;
        }
        bjg bjg2 = bkw2.a;
        bkk bkk2 = bkw2.a.a;
        this.time.d(aoi.a(bnr2.Y - this.startTime));
        this.mapX.d(bkk2.o);
        this.mapY.d(bkk2.p);
        this.mapTheta.d(bkk2.t);
        this.mapDistance.d(bkk2.u);
        this.mapAngularDistance.d(bkk2.v);
        this.mapXyz[0].d((double)bkk2.a.o * 1000.0);
        this.mapXyz[1].d((double)bkk2.a.p * 1000.0);
        this.mapXyz[2].d((double)bkk2.a.q * 1000.0);
        blo blo2 = bkw2.a.a;
        this.runtimeAmbientTemperature.d(blo2.ad);
        this.runtimeBatteryVoltage.d(blo2.ae);
        this.runtimePcResidentMemoryUsage.d(blo2.af / 1024.0f);
        this.runtimePcVirtualMemoryUsage.d(blo2.ag / 1024.0f);
        this.runtimePcUserCpuUsage.d(blo2.ah);
        this.runtimePcKernelCpuUsage.d(blo2.ai);
        this.runtimePcTemperature.d(blo2.aj);
        this.runtimePcVoltage.d(blo2.ak);
        this.runtimeMainCycleTimeMs.d(blo2.al);
        this.runtimeMainBusyTimeMs.d(blo2.am);
        this.runtimeCyclesSincePositionSourceData.d(blo2.dD);
        this.utThicknessSamples.d(bjg2.a.du);
        bni bni2 = bkw2.a.a;
        this.poseTranslation[0].d((double)bni2.d.o * 1000.0);
        this.poseTranslation[1].d((double)bni2.d.p * 1000.0);
        this.poseTranslation[2].d((double)bni2.d.q * 1000.0);
        this.poseOrientation[0].d(bni2.c.ac);
        this.poseOrientation[1].d(bni2.c.o);
        this.poseOrientation[2].d(bni2.c.p);
        this.poseOrientation[3].d(bni2.c.q);
        this.poseDelay.d(bni2.dO);
        if (bjg2.bG()) {
            blm blm2 = bjg2.a;
            if (this.numJoints < 0) {
                this.numJoints = blm2.d.ax();
                this.resizeRobotFeedback(blm2);
            }
            MapsLogFeedback mapsLogFeedback = this;
            mapsLogFeedback.addMultiple(mapsLogFeedback.position, blm2.d);
            MapsLogFeedback mapsLogFeedback2 = this;
            mapsLogFeedback2.addMultiple(mapsLogFeedback2.velocity, blm2.e);
            MapsLogFeedback mapsLogFeedback3 = this;
            mapsLogFeedback3.addMultiple(mapsLogFeedback3.power, blm2.f);
            MapsLogFeedback mapsLogFeedback4 = this;
            mapsLogFeedback4.addMultiple(mapsLogFeedback4.sequence, blm2.a);
            MapsLogFeedback mapsLogFeedback5 = this;
            mapsLogFeedback5.addMultiple(mapsLogFeedback5.rxSequence, blm2.b);
            MapsLogFeedback mapsLogFeedback6 = this;
            mapsLogFeedback6.addMultiple(mapsLogFeedback6.temperature, blm2.g);
            MapsLogFeedback mapsLogFeedback7 = this;
            mapsLogFeedback7.addMultiple(mapsLogFeedback7.voltage, blm2.h);
            MapsLogFeedback mapsLogFeedback8 = this;
            mapsLogFeedback8.addMultiple(mapsLogFeedback8.firstOrientation, blm2.i);
            for (int i2 = 0; i2 < this.roundTripTime.length; ++i2) {
                this.roundTripTime[i2].d(1000.0 * aoi.a(blm2.e.e(i2) - blm2.f.e(i2)));
                this.hwResponseTime[i2].d(1000.0 * aoi.a(blm2.d.e(i2) - blm2.c.e(i2)));
                if (this.prevRobotFbk.isEmpty()) {
                    this.transmitTimeDelta[i2].d(Double.NaN);
                    this.packetLoss[i2].d(Double.NaN);
                    continue;
                }
                double d2 = aoi.a(blm2.f.e(i2) - this.prevRobotFbk.f.e(i2));
                this.transmitTimeDelta[i2].d(d2 * 1000.0);
                this.packetLoss[i2].d(blm2.a.e(i2) - this.prevRobotFbk.a.e(i2) - 1L);
            }
            this.prevRobotFbk.a(blm2);
        }
    }

    private void addMultiple(jh[] jhArray, caw caw2) {
        for (int i2 = 0; i2 < jhArray.length; ++i2) {
            jhArray[i2].d(caw2.a(i2));
        }
    }

    private void addMultiple(jh[] jhArray, cay cay2) {
        for (int i2 = 0; i2 < jhArray.length; ++i2) {
            jhArray[i2].d(cay2.e(i2));
        }
    }

    public void getCharts(ChartList chartList) {
        chartList.setTime(this.time).setTraceType(axp.a).addTimeTraces(MapPointCategory, "Position XY", null, 0.0, 1.0, new jh[]{this.mapX, this.mapY}, renderer -> {
            awh.a(renderer, 0, "X", "trace-solid");
            awh.a(renderer, 1, "Y", "trace-solid");
        }).addDeviceXY(MapPointCategory, "Position XY (2D)", awz.a("X", null), new jh[]{this.mapX}, awz.a("Y", null), new jh[]{this.mapY}).addSingleTrace(MapPointCategory, "Theta", null, 0.0, 1.0, this.mapTheta).addSingleTrace(MapPointCategory, "Distance", null, 0.0, 0.0, this.mapDistance).addSingleTrace(MapPointCategory, "Angular Distance", null, 0.0, 0.0, this.mapAngularDistance).addXyzChart(MapPointCategory, "Position XYZ (closest)", "mm", -50.0, 50.0, this.mapXyz).addXyzChart(poseCategory, "Position XYZ", "mm", -50.0, 50.0, this.poseTranslation).addQuaternionTraces(poseCategory, "Orientation", this.poseOrientation).addSingleTrace(poseCategory, "Delay", "ms", 0.0, 10.0, this.poseDelay);
        if (!this.prevRobotFbk.isEmpty()) {
            chartList.setTraceType(axp.a).addDeviceChart(RobotCategory, "Position", "rad", -1.5707963267948966, 1.5707963267948966, this.position).addDeviceChart(RobotCategory, "Velocity", "rad/s", -5.0, 5.0, this.velocity).addDeviceChart(RobotCategory, "Power", "W", 0.0, 1.0, this.power).addDeviceChart(RobotCategory, "Voltage", "V", 0.0, 50.0, this.voltage).addDeviceChart(RobotCategory, "Temperature", "\u00b0C", 0.0, 100.0, this.temperature).addQuaternionTraces(RobotCategory, "First Orientation", this.firstOrientation).setTraceType(axp.c).addDeviceChart(RobotCategory, "Round Trip Time", "ms", 0.0, 0.5, this.roundTripTime).addAsHistogram(RobotCategory, "Round Trip Time %", "ms", this.roundTripTime).addDeviceChart(RobotCategory, "Hardware Response Time", "ms", 0.0, 0.5, this.hwResponseTime).addAsHistogram(RobotCategory, "Hardware Response Time %", "ms", this.hwResponseTime).addDeviceChart(RobotCategory, "Transmit Time Delta", "ms", 0.0, 0.5, this.transmitTimeDelta).addAsHistogram(RobotCategory, "Transmit Time Delta %", "ms", this.transmitTimeDelta).addDeviceChart(RobotCategory, "Packet Loss", "", 0.0, 1.0, this.packetLoss).addAsHistogram(RobotCategory, "Packet Loss %", "", this.packetLoss).addDeviceChart(RobotCategory, "Rx Sequence", "", 0.0, 1.0, this.rxSequence).setTraceType(axp.a);
        }
        chartList.setTraceType(axp.a).addTimeTraces(RuntimeCategory, "Voltage", "V", 0.0, 50.0, new jh[]{this.runtimeBatteryVoltage, this.runtimePcVoltage}, renderer -> {
            awh.a(renderer, 0, "battery", new String[0]);
            awh.a(renderer, 1, "computer", new String[0]);
        }).addTimeTraces(RuntimeCategory, "Temperature", "\u00b0C", 0.0, 50.0, new jh[]{this.runtimeAmbientTemperature, this.runtimePcTemperature}, renderer -> {
            awh.a(renderer, 0, "ambient", new String[0]);
            awh.a(renderer, 1, "computer", new String[0]);
        }).addTimeTraces(RuntimeCategory, "CPU Usage", "%", 0.0, 100.0, new jh[]{this.runtimePcUserCpuUsage, this.runtimePcKernelCpuUsage}, renderer -> {
            awh.a(renderer, 0, "user", new String[0]);
            awh.a(renderer, 1, "kernel", new String[0]);
        }).addTimeTraces(RuntimeCategory, "Memory Usage", "MB", 0.0, 10.0, new jh[]{this.runtimePcResidentMemoryUsage, this.runtimePcVirtualMemoryUsage}, renderer -> {
            awh.a(renderer, 0, "resident", new String[0]);
            awh.a(renderer, 1, "virtual", new String[0]);
        }).addSingleTrace(RuntimeCategory, "Cycles Since Position", null, 0.0, 1.0, this.runtimeCyclesSincePositionSourceData).setTraceType(axp.c).addTimeTraces(RuntimeCategory, "Main Loop Times", "ms", 0.0, 10.0, new jh[]{this.runtimeMainCycleTimeMs, this.runtimeMainBusyTimeMs}, renderer -> {
            awh.a(renderer, 0, "cycle time", new String[0]);
            awh.a(renderer, 1, "busy time", new String[0]);
        }).addAsHistogram(RuntimeCategory, "Main Loop Times %", "ms", new jh[]{this.runtimeMainCycleTimeMs, this.runtimeMainBusyTimeMs}, renderer -> {
            awh.a(renderer, 0, "cycle time", new String[0]);
            awh.a(renderer, 1, "busy time", new String[0]);
        });
    }

    private void resize() {
        this.time = this.resizeSingle(this.time);
        this.mapX = this.resizeSingle(this.mapX);
        this.mapY = this.resizeSingle(this.mapY);
        this.mapTheta = this.resizeSingle(this.mapTheta);
        this.mapDistance = this.resizeSingle(this.mapDistance);
        this.mapAngularDistance = this.resizeSingle(this.mapAngularDistance);
        this.mapXyz = this.resizeMultiple(this.mapXyz, 3);
        this.runtimeAmbientTemperature = this.resizeSingle(this.runtimeAmbientTemperature);
        this.runtimeBatteryVoltage = this.resizeSingle(this.runtimeBatteryVoltage);
        this.runtimePcResidentMemoryUsage = this.resizeSingle(this.runtimePcResidentMemoryUsage);
        this.runtimePcVirtualMemoryUsage = this.resizeSingle(this.runtimePcVirtualMemoryUsage);
        this.runtimePcUserCpuUsage = this.resizeSingle(this.runtimePcUserCpuUsage);
        this.runtimePcKernelCpuUsage = this.resizeSingle(this.runtimePcKernelCpuUsage);
        this.runtimePcTemperature = this.resizeSingle(this.runtimePcTemperature);
        this.runtimePcVoltage = this.resizeSingle(this.runtimePcVoltage);
        this.runtimeMainCycleTimeMs = this.resizeSingle(this.runtimeMainCycleTimeMs);
        this.runtimeMainBusyTimeMs = this.resizeSingle(this.runtimeMainBusyTimeMs);
        this.runtimeCyclesSincePositionSourceData = this.resizeSingle(this.runtimeCyclesSincePositionSourceData);
        this.utThicknessSamples = this.resizeSingle(this.utThicknessSamples);
        this.poseTranslation = this.resizeMultiple(this.poseTranslation, 3);
        this.poseOrientation = this.resizeMultiple(this.poseOrientation, 4);
        this.poseDelay = this.resizeSingle(this.poseDelay);
    }

    private void resizeRobotFeedback(blm blm2) {
        this.numJoints = blm2.d.ax();
        this.position = this.resizeMultiple(this.position, blm2.d.ax());
        this.velocity = this.resizeMultiple(this.velocity, blm2.e.ax());
        this.power = this.resizeMultiple(this.power, blm2.f.ax());
        this.sequence = this.resizeMultiple(this.sequence, blm2.a.ax());
        this.rxSequence = this.resizeMultiple(this.rxSequence, blm2.b.ax());
        this.roundTripTime = this.resizeMultiple(this.roundTripTime, blm2.c.ax());
        this.hwResponseTime = this.resizeMultiple(this.hwResponseTime, this.roundTripTime.length);
        this.transmitTimeDelta = this.resizeMultiple(this.transmitTimeDelta, this.roundTripTime.length);
        this.transmitTimeDelta = this.resizeMultiple(this.transmitTimeDelta, this.roundTripTime.length);
        this.packetLoss = this.resizeMultiple(this.packetLoss, this.roundTripTime.length);
        this.temperature = this.resizeMultiple(this.temperature, blm2.g.ax());
        this.voltage = this.resizeMultiple(this.voltage, blm2.h.ax());
        this.firstOrientation = this.resizeMultiple(this.firstOrientation, 4);
        this.prevRobotFbk.c();
    }
}

