/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer;

import io.fair_acc.chartfx.XYChart;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Optional;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Material;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import us.hebi.gui.e;
import us.hebi.gui.lib.aa;
import us.hebi.gui.lib.aco;
import us.hebi.gui.lib.acq;
import us.hebi.gui.lib.afy;
import us.hebi.gui.lib.ano;
import us.hebi.gui.lib.aos;
import us.hebi.gui.lib.aro;
import us.hebi.gui.lib.arx;
import us.hebi.gui.lib.ase;
import us.hebi.gui.lib.asm;
import us.hebi.gui.lib.asq;
import us.hebi.gui.lib.ast;
import us.hebi.gui.lib.atd;
import us.hebi.gui.lib.ate;
import us.hebi.gui.lib.avk;
import us.hebi.gui.lib.awg;
import us.hebi.gui.lib.awh;
import us.hebi.gui.lib.azi;
import us.hebi.gui.lib.azw;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.bab;
import us.hebi.gui.lib.bac;
import us.hebi.gui.lib.baq;
import us.hebi.gui.lib.bar;
import us.hebi.gui.lib.bat;
import us.hebi.gui.lib.bay;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.bei;
import us.hebi.gui.lib.bej;
import us.hebi.gui.lib.wn;
import us.hebi.gui.lib.zd;
import us.hebi.gui.views.logviewer.custom.CustomLogviewerView;
import us.hebi.gui.views.logviewer.hebilog.HebiLogContent;
import us.hebi.gui.views.logviewer.hebilog.HebiLogFeedback;
import us.hebi.gui.views.logviewer.hebilog.MobileIoFeedback;
import us.hebi.gui.views.logviewer.hebilog.XyzLogData;
import us.hebi.gui.views.logviewer.state.NamedChart;
import us.hebi.gui.views.scope.assets.Asset;

public class LogviewerPresenter
extends azi {
    @FXML
    private Pane root;
    @FXML
    private TreeView<NamedChart> plotTree;
    @FXML
    private AnchorPane chartPane;
    @FXML
    private Button saveGainsBtn;
    @FXML
    private Button loadHrdfOrConfigBtn;
    @FXML
    private Button loadCustomBtn;
    @FXML
    private Button showInfoBtn;
    @FXML
    private Button view3dBtn;
    public static final PseudoClass CELL_CATEGORY = PseudoClass.getPseudoClass((String)"category");
    final TreeItem<NamedChart> rootNode = new TreeItem();
    @Inject
    HebiLogContent logContent;
    @Inject
    avk fileChooser;
    @Inject
    aro properties;
    @Inject
    ate notificationService;
    bac indicator = new bac();
    DoubleProperty selectedTime = new SimpleDoubleProperty(0.0);
    azw timer = azw.a(d2 -> this.selectedTime.set(this.selectedTime.get() + d2));
    IntegerBinding selectedIndex = Bindings.createIntegerBinding(() -> {
        double d2 = this.selectedTime.get();
        if (!Double.isFinite(d2) || this.logContent == null || !this.logContent.hasValidFeedback()) {
            return -1;
        }
        return this.logContent.getFeedback().getIndexAt(d2);
    }, (Observable[])new Observable[]{this.selectedTime});
    BooleanProperty showModelCmd = new SimpleBooleanProperty(false);
    SimpleObjectProperty<Parent> infoTable = new SimpleObjectProperty();

    @Override
    public void initializeFx() {
        bat.f((Parent)this.root);
        this.indicator.a((Pane)this.root).loading.bind((ObservableValue)this.logContent.loadingProperty());
        this.logContent.loadAsync().thenRunAsync(this::updateChartMenu, Platform::runLater);
        XYChart xYChart = awh.a(-10.0, 10.0, "");
        this.chartPane.getChildren().setAll((Object[])new Node[]{azx.c(xYChart)});
        bab.b((Node)this.chartPane);
        this.plotTree.setCellFactory(LogviewerPresenter::createStyledCell);
        this.plotTree.setRoot(this.rootNode);
        this.plotTree.getSelectionModel().selectedItemProperty().addListener((observableValue, treeItem, treeItem2) -> {
            if (treeItem2 == null || treeItem2.getValue() == null || ((NamedChart)treeItem2.getValue()).isCategory()) {
                return;
            }
            this.chartPane.getChildren().setAll((Object[])new Node[]{azx.c(((NamedChart)treeItem2.getValue()).getChart())});
        });
        this.showInfoBtn.disableProperty().bind((ObservableValue)this.infoTable.isNull());
        this.showInfoBtn.setOnAction(actionEvent -> this.chartPane.getChildren().setAll((Object[])new Node[]{azx.c((Parent)this.infoTable.get())}));
        this.saveGainsBtn.disableProperty().bind((ObservableValue)this.logContent.hasInfoProperty().not());
        this.saveGainsBtn.setOnAction(actionEvent -> {
            Window window = azx.a(actionEvent);
            File file = this.fileChooser.f(window);
            if (file != null) {
                try {
                    File file2 = file;
                    zd zd2 = zd.a(this.logContent.getInfo());
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                        zd2.a(fileOutputStream);
                    }
                    atd.a(file, window);
                    return;
                }
                catch (Exception exception) {
                    this.notificationService.f(exception);
                }
            }
        });
        this.loadHrdfOrConfigBtn.setOnAction(actionEvent -> {
            Window window = azx.a(actionEvent);
            File file = this.fileChooser.c(window);
            if (file != null) {
                try {
                    this.logContent.setRobotConfig(null);
                    if (wn.a(file) == wn.e) {
                        acq acq2 = acq.tryReadFile(file.toPath());
                        this.logContent.setRobotConfig(acq2);
                        file = new File(aa.a(acq2.getHrdf(), (Object)"Robot config does not specify an hrdf"));
                    }
                    int n2 = bej.a(file).a().W();
                    if (this.logContent.getNumJoints() != n2) {
                        throw new IllegalArgumentException("The log file contains " + this.logContent.getNumJoints() + " joints, but the selected HRDF lists " + n2 + " joints.");
                    }
                    this.logContent.setHrdfFile(file, this.logContent.getIndexMap());
                    this.updateChartMenu();
                    return;
                }
                catch (Exception exception) {
                    this.notificationService.f(exception);
                }
            }
        });
        this.loadCustomBtn.setOnAction(actionEvent -> new CustomLogviewerView(this.logContent.getFile()).getViewAsync(parent -> {
            Stage stage = new Stage();
            stage.getIcons().add((Object)e.c);
            stage.setTitle(this.logContent.getFileName());
            stage.setScene(new Scene(parent));
            azx.a(stage, azx.a(actionEvent));
        }));
        if (!azx.aV()) {
            this.view3dBtn.setDisable(true);
        } else {
            BooleanBinding booleanBinding = Bindings.size(this.logContent.getMobileIoList()).isEqualTo(0);
            this.view3dBtn.disableProperty().bind((ObservableValue)booleanBinding.and((ObservableBooleanValue)this.logContent.hasValidHrdf().not()));
            this.view3dBtn.setOnAction(actionEvent -> {
                Window window = azx.a(actionEvent);
                if (this.logContent.hasValidHrdf().get()) {
                    this.launchStage(window, (Pane)this.createRobotView3d());
                }
                for (MobileIoFeedback mobileIoFeedback : this.logContent.getMobileIoList()) {
                    this.launchStage(window, (Pane)this.createMobileIo3d(mobileIoFeedback));
                }
            });
        }
        this.selectedTime.bindBidirectional((Property)this.logContent.getChartList().getIndicatorTime());
        azx.a((Node)this.root, this::registerKeyHandler);
    }

    private void launchStage(Window window, Pane pane) {
        Stage stage = new Stage();
        stage.getIcons().add((Object)e.c);
        stage.setTitle(this.logContent.getFileName());
        stage.setScene(new Scene((Parent)pane, 700.0, 450.0, true));
        azx.a(stage, window);
        Stage stage2 = stage;
        bab.a(stage2, () -> ((Stage)stage2).close());
    }

    private void registerKeyHandler(Scene scene) {
        scene.addEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
            if (bab.o.match(keyEvent)) {
                this.timer.bZ();
                keyEvent.consume();
                return;
            }
            if (bab.a.match(keyEvent)) {
                this.showModelCmd.set(!this.showModelCmd.get());
                keyEvent.consume();
                return;
            }
            if (bab.e.match(keyEvent)) {
                this.selectedTime.set(this.selectedTime.get() - 1.0);
                keyEvent.consume();
                return;
            }
            if (bab.f.match(keyEvent)) {
                this.selectedTime.set(this.selectedTime.get() + 1.0);
                keyEvent.consume();
            }
        });
    }

    private AnchorPane createRobotView3d() {
        asq asq2 = new asq().a();
        aos aos2 = asq2.a;
        ase ase2 = new ase(this.logContent.getXmlContent());
        ase2.A.bind((ObservableValue)asq2.e.visibleProperty());
        ase2.B.bind((ObservableValue)aos2.a("CoM Axes", false));
        Object object = "Models";
        ase2.C.bind((ObservableValue)aos2.a("Models", true));
        BooleanProperty booleanProperty = aos2.a("Command Overlay", this.showModelCmd.get(), "ctrl + f");
        azx.a(booleanProperty, this.showModelCmd);
        ase ase3 = new ase(this.logContent.getXmlContent());
        ase3.A.set(false);
        ase3.B.set(false);
        ase3.C.bind((ObservableValue)ase2.C);
        ase3.c.visibleProperty().bind((ObservableValue)booleanProperty);
        aa.a((Node)ase3.c, (Material)ase.c);
        XyzLogData xyzLogData = this.logContent.getXyzData();
        asm asm2 = new asm(xyzLogData.xyzPosition, awg.f);
        asm asm3 = new asm(xyzLogData.xyzPositionCmd, awg.e);
        object = "Fbk Line";
        asm2.visibleProperty().bind((ObservableValue)aos2.a("Fbk Line", true));
        object = "Cmd Line";
        asm3.visibleProperty().bind((ObservableValue)aos2.a("Cmd Line", true));
        BooleanProperty booleanProperty2 = aos2.a("Full Line", false);
        asm2.L.bind((ObservableValue)booleanProperty2);
        asm3.L.bind((ObservableValue)booleanProperty2);
        Node node = ase.a();
        node.visibleProperty().bind((ObservableValue)ase2.B);
        bdc bdc2 = bej.a(this.logContent.getXmlContent()).a();
        object = node;
        arx arx2 = new arx(new bei(bdc2));
        new arx(new bei(bdc2)).b = object;
        asq asq3 = asq2;
        object = asq3.d;
        v0.a = object;
        arx arx3 = arx2;
        this.logContent.getRobotConfig().flatMap(aco::getGravComp).ifPresent(arx3::a);
        arx3.y.bind((ObservableValue)aos2.a("Orient Base", false));
        arx3.z.bind((ObservableValue)aos2.a("Offset Base", false));
        arx3.update();
        azx.a(aos2.a("Play", this.timer.W.get(), "ctrl + space"), this.timer.W);
        asq3 = asq2;
        asq3.d.getChildren().setAll((Object[])new Node[]{ase2.c, ase3.c, asm2, asm3, node});
        ano ano2 = this.logContent.getIndexMap();
        Runnable runnable = () -> {
            int n2 = this.selectedIndex.get();
            if (n2 < 0) {
                return;
            }
            asm3.v(n2);
            asm2.v(n2);
            HebiLogFeedback hebiLogFeedback = this.logContent.getFeedback();
            for (int i2 = 0; i2 < hebiLogFeedback.getNumJoints(); ++i2) {
                int n3 = ano2.apply(i2);
                ase2.b(i2, hebiLogFeedback.position[n3].a(n2));
                ase3.b(i2, hebiLogFeedback.positionCmd[n3].a(n2));
                arx3.a(i2, hebiLogFeedback.position[n3].a(n2));
                arx3.a(i2, hebiLogFeedback.orientationW[n3].a(n2), hebiLogFeedback.orientationX[n3].a(n2), hebiLogFeedback.orientationY[n3].a(n2), hebiLogFeedback.orientationZ[n3].a(n2));
            }
            arx3.update();
        };
        this.selectedIndex.addListener(observable -> runnable.run());
        runnable.run();
        azx.a((Node)asq2, this::registerKeyHandler);
        bar.e((Parent)asq2);
        baq.c((Parent)asq2);
        bat.f((Parent)asq2);
        azx.a((Parent)asq2);
        return asq2;
    }

    private AnchorPane createMobileIo3d(MobileIoFeedback mobileIoFeedback) {
        asq asq2 = new asq().a();
        aos aos2 = asq2.a;
        String string = "Model";
        BooleanProperty booleanProperty = aos2.a("Model", true);
        ast ast2 = new ast(new Node[0]);
        Asset.Iphone.getModelAsync(group -> {
            group.visibleProperty().bind((ObservableValue)booleanProperty);
            ast2.getChildren().add(group);
        });
        asm asm2 = new asm(mobileIoFeedback.arPosition, awg.i);
        BooleanProperty booleanProperty2 = aos2.a("Full Path", false);
        string = "Path";
        asm2.visibleProperty().bind((ObservableValue)aos2.a("Path", true));
        asm2.L.bind((ObservableValue)booleanProperty2);
        azx.a(aos2.a("Play", this.timer.W.get(), "ctrl + space"), this.timer.W);
        asq asq3 = asq2;
        asq3.d.getChildren().setAll((Object[])new Node[]{asm2, ast2});
        Runnable runnable = () -> {
            int n2 = this.selectedIndex.get();
            if (n2 < 0) {
                return;
            }
            asm2.v(n2);
            ast2.b(mobileIoFeedback.arOrientation[0].a(n2), mobileIoFeedback.arOrientation[1].a(n2), mobileIoFeedback.arOrientation[2].a(n2), mobileIoFeedback.arOrientation[3].a(n2), mobileIoFeedback.arPosition[0].a(n2), mobileIoFeedback.arPosition[1].a(n2), mobileIoFeedback.arPosition[2].a(n2));
        };
        this.selectedIndex.addListener(observable -> runnable.run());
        runnable.run();
        azx.a((Node)asq2, this::registerKeyHandler);
        bar.e((Parent)asq2);
        baq.c((Parent)asq2);
        bat.f((Parent)asq2);
        azx.a((Parent)asq2);
        return asq2;
    }

    public void updateChartMenu() {
        this.plotTree.getSelectionModel().clearSelection();
        this.rootNode.getChildren().setAll(this.logContent.createChartHierarchy());
        if (this.rootNode.getChildren().size() > 0) {
            this.plotTree.getSelectionModel().select(1);
        }
        LogviewerPresenter logviewerPresenter = this;
        Optional.ofNullable(logviewerPresenter.createInfoTable(logviewerPresenter.logContent.getInfo())).ifPresent(arg_0 -> this.infoTable.set(arg_0));
    }

    TableView<afy> createInfoTable(afy[] afyArray) {
        if (afyArray == null || afyArray.length == 0) {
            return null;
        }
        ObservableList observableList = FXCollections.observableArrayList((Object[])afyArray);
        TableView tableView = new TableView();
        Object[] objectArray = new TableColumn[7];
        objectArray[0] = this.createColumn("Index", arg_0 -> observableList.indexOf(arg_0));
        objectArray[1] = this.createCategory("Identifier", this.createColumn("Family", afy::getFamily), this.createColumn("Name", afy::getName), this.createColumn("Serial", afy2 -> afy2.a().h()));
        objectArray[2] = this.createCategory("Gains", this.createColumn("Strategy", afy2 -> afy2.a().a()));
        objectArray[3] = this.createCategory("Mechanical", this.createColumn("Type", afy2 -> afy2.a().w()), this.createColumn("Rev", afy2 -> afy2.a().x()));
        objectArray[4] = this.createCategory("Electrical", this.createColumn("Type", afy2 -> afy2.a().u()), this.createColumn("Rev", afy2 -> afy2.a().v()));
        objectArray[5] = this.createCategory("Firmware", this.createColumn("Type", afy2 -> afy2.a().getType()), this.createColumn("Rev", afy2 -> afy2.a().r()));
        objectArray[6] = this.createCategory("Network", this.createColumn("Mac", afy2 -> afy2.a().b()), this.createColumn("IP", afy2 -> afy2.a().b().getHostAddress()), this.createColumn("Subnet", afy2 -> afy2.a().c().getHostAddress()));
        tableView.getColumns().addAll(objectArray);
        tableView.setItems(observableList);
        azx.c(tableView);
        tableView.setPrefSize(Double.MAX_VALUE, Double.MAX_VALUE);
        return tableView;
    }

    private TableColumn<afy, String> createCategory(String string, TableColumn<afy, String> ... tableColumnArray) {
        TableColumn tableColumn = new TableColumn(string);
        tableColumn.getColumns().setAll((Object[])tableColumnArray);
        return tableColumn;
    }

    private TableColumn<afy, String> createColumn(String string, Function<afy, Object> function) {
        TableColumn tableColumn = new TableColumn(string);
        tableColumn.setCellValueFactory(cellDataFeatures -> {
            String string = String.valueOf(function.apply((afy)cellDataFeatures.getValue()));
            return new SimpleStringProperty(string);
        });
        return tableColumn;
    }

    public static <T> TreeCell<NamedChart> createStyledCell(TreeView<NamedChart> treeView) {
        return new bay();
    }
}

