/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.lib;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import picocli.CommandLine;
import us.hebi.gui.lib.ada;
import us.hebi.gui.lib.aej;
import us.hebi.gui.lib.aem;
import us.hebi.gui.lib.afl;
import us.hebi.gui.lib.agw;
import us.hebi.gui.lib.agz;
import us.hebi.gui.lib.aiw;
import us.hebi.gui.lib.amx;
import us.hebi.gui.lib.atu;
import us.hebi.gui.lib.aus;
import us.hebi.gui.lib.aut;
import us.hebi.gui.lib.auv;
import us.hebi.gui.lib.avc;
import us.hebi.gui.lib.avd;
import us.hebi.gui.lib.avh;
import us.hebi.gui.lib.ayi;
import us.hebi.gui.lib.ayp;
import us.hebi.gui.lib.ayr;
import us.hebi.gui.lib.ayu;
import us.hebi.gui.lib.ayv;
import us.hebi.gui.lib.baf;
import us.hebi.gui.lib.bre;
import us.hebi.gui.lib.bri;
import us.hebi.gui.lib.bsj;
import us.hebi.gui.lib.can;
import us.hebi.gui.lib.wv;
import us.hebi.gui.lib.wx;

public final class ayo
extends ayi {
    @CommandLine.Parameters(index="0", paramLabel="mode", description={"Chooses the operating mode [calibration, errorlog, getinfo, getfbk, readlog, program]"})
    protected ayr mode;
    @CommandLine.Option(names={"--frequency"}, description={"Sets the frequency [Hz] for modes that poll device data."})
    private double frequency = 10.0;
    @CommandLine.Option(names={"--imu-accel-offset"}, description={"Sets the xyz accelerometer offset after calibration. Expects 3 numbers separated by commas."}, split=",")
    private float[] imuAccelOffsets;
    @CommandLine.Option(names={"--imu-rotation"}, description={"Sets the 3x3 rotation matrix of the IMU after calibration. Expects 9 numbers  separated by commas."}, split=",")
    private float[] imuRotation;
    @CommandLine.Option(names={"--md-motor-adc"}, description={"Runs a calibration procedure and sets motor driver offsets"})
    private boolean mdMotorAdc;
    @CommandLine.Option(names={"--md-encoder-offset"}, description={"Runs a calibration procedure and sets encoder offsets"})
    private boolean mdEncoderOffset;
    @CommandLine.Option(names={"--md-table-index"}, description={"Selects the target calibration table index."})
    private int targetTableIndex = 0;
    @CommandLine.Option(names={"--md-read-encoder-offset-table"}, description={"Reads the current encoder offset table"})
    private boolean mdReadEncoderOffsetTable;
    @CommandLine.Option(names={"--hebilog"}, description={"Loads a .hebilog file and prints the output"})
    private File hebilogFile;
    @CommandLine.Option(names={"--application"}, description={"Application firmware file"})
    private File applicationFile;

    @Override
    protected final void run() throws Exception {
        if (this.frequency < 0.0) {
            throw ayv.a("frequency");
        }
        if (this.mode == ayr.errorlog || this.mode == ayr.getinfo || this.mode == ayr.getfbk) {
            ayo ayo2 = this;
            aem aem2 = ayo2.b();
            System.out.println("Polling of " + String.valueOf(aem2) + " at " + ayo2.frequency + " Hz");
            ayu ayu2 = new ayu(aem2);
            ayu2.a(ayo2.frequency);
            bsj bsj3 = ayu2.h.c();
            switch (ayo2.mode.ordinal()) {
                case 1: {
                    bsj3.j(true);
                    break;
                }
                case 2: {
                    bsj3.l(true).k(true).a(bri.b).c(true).b(true).a(true).d(true).g(true).e(true).f(true).h(true);
                    break;
                }
                case 3: {
                    bsj3.b(true).a(true).d(true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported poll mode: " + String.valueOf((Object)ayo2.mode));
                }
            }
            ada ada2 = (bsj2, l2, bl2) -> {
                switch (this.mode.ordinal()) {
                    case 1: {
                        bre bre2 = bsj2.a;
                        if (bre2.hO()) {
                            System.out.print("[error] ");
                            System.out.println(bre2.T.a(can.b));
                        }
                        if (bre2.hN()) {
                            System.out.print("[flags] ");
                            System.out.println(bre2.S.a(can.b));
                        }
                        return;
                    }
                }
                System.out.println(bsj2);
            };
            ayu2.c = ada2;
            ayu2.a();
            Runtime.getRuntime().addShutdownHook(new Thread(ayu2::bW));
            while (true) {
                amx.b(100L, TimeUnit.MILLISECONDS);
            }
        }
        if (this.mode == ayr.calibration) {
            if (this.mdMotorAdc) {
                ayo ayo3 = this;
                ayo3.b();
                aem aem3 = ayo3.b();
                System.out.println("Running ADC calibration on " + String.valueOf(aem3));
                new ayu(aem3);
                aut aut2 = new aus(aem3, afl.b, 200, 38.0f, 4.0f).a();
                System.out.println("Computed fit coefficients for ADC offsets");
                System.out.println("A:   " + Arrays.toString(aut2.a.g()));
                System.out.println("B:   " + Arrays.toString(aut2.b.g()));
                System.out.println("C:   " + Arrays.toString(aut2.c.g()));
                System.out.println("Bus: " + Arrays.toString(aut2.d.g()));
                return;
            }
            if (this.mdEncoderOffset) {
                agz agz2;
                ayo ayo4 = this;
                ayo4.b();
                ayo ayo5 = ayo4;
                aem aem4 = ayo4.b();
                System.out.println("Running encoder offset calibration on " + String.valueOf(aem4));
                System.out.println("Make sure the following are set:\n   Motor Driver: [Output Encoder] is set to your configured encoder (e.g. A1)\n   Motor Driver: [Motor Encoder] is set to POSITION_COMMAND\n   Motor Driver: [Controller Mode] is set to FOC\n   Gains:        [Control Strategy] is set to DIRECT_FOC\nPress Enter to continue...\n");
                if (ayo5.verbose) {
                    System.out.println("Requesting current motor encoder configuration");
                }
                try {
                    aiw aiw2 = aej.a(aem4);
                    agz2 = aiw2.a.a().a();
                }
                catch (IOException iOException) {
                    throw ayv.a("Failed to get info message from device", new Object[0]);
                }
                if (ayo5.verbose) {
                    System.out.println("Using motor encoder " + String.valueOf((Object)agz2));
                }
                avh avh2 = new avc(aem4, agz2, 15.0, 2.0, 11, avd.Calibrate).a();
                System.out.println("Fit Coeffs: " + Arrays.toString(avh2.e.g()));
                return;
            }
            if (this.mdReadEncoderOffsetTable) {
                agz agz3;
                ayo ayo6 = this;
                aem aem5 = ayo6.b();
                ayo ayo7 = ayo6;
                if (ayo6.verbose) {
                    System.out.println("Requesting current motor encoder offsets");
                }
                System.err.println("TODO: currently hardcoded A1 w/ 256 buckets. We need to add more parameters to define the target.");
                auv auv2 = new auv(agw.d);
                new auv(agw.d).l = agz3 = agz.c;
                auv2.a(aem5, bsj2 -> {
                    if (this.verbose) {
                        System.out.println(bsj2);
                    }
                }, bsj2 -> {
                    if (this.verbose) {
                        System.out.println(bsj2);
                    }
                });
                System.out.println(Arrays.toString(auv2.y));
                return;
            }
        }
        if (this.mode == ayr.readlog) {
            ayo ayo8 = this;
            if (!ayo8.c(ayo8.hebilogFile)) {
                throw ayv.a("Invalid '--hebilog' parameter : " + String.valueOf(ayo8.hebilogFile), new Object[0]);
            }
            try (wx wx2 = wv.a(ayo8.hebilogFile);){
                wx2.a(new ayp(ayo8));
                return;
            }
            catch (IOException iOException) {
                throw ayv.a("Failed to read log file. Reason: %s", iOException.getMessage());
            }
        }
        if (this.mode == ayr.program) {
            ayo ayo9 = this;
            if (!ayo9.c(ayo9.applicationFile)) {
                throw ayv.a("Invalid '--application' parameter : " + String.valueOf(this.applicationFile), new Object[0]);
            }
            if (!baf.a(this.b(), System.out::println)) {
                throw new IllegalStateException("Failed to get into bootloader");
            }
            atu.a(this.b(), this.applicationFile).Q();
            System.out.println("Booting into application.");
            baf.b(this.b());
        }
        super.run();
    }

    @Override
    protected final void g(List<BiConsumer<bsj, Integer>> list) {
        if (this.imuAccelOffsets != null) {
            ayo.a(this.imuAccelOffsets.length == 3, "Accelerometer offset expects 3 values: [x,y,z]. Got %d.", this.imuAccelOffsets.length);
            list.add((bsj2, n2) -> bsj2.a().e().i(true).b(this.imuAccelOffsets));
        }
        if (this.imuRotation != null) {
            ayo.a(this.imuRotation.length == 9, "IMU rotation expects 9 values separated by commas. Got %d. ", this.imuRotation.length);
            list.add((bsj2, n2) -> bsj2.a().e().h(true).a(this.imuRotation));
        }
    }

    @Override
    protected final void y(int n2) {
        if (n2 > 1) {
            ayo.a(this.imuAccelOffsets == null, "--imu-accel-offset only supports single devices", new Object[0]);
            ayo.a(this.imuRotation == null, "--imu-rotation only supports single devices", new Object[0]);
        }
    }

    private aem b() throws ayv {
        List<aem> list = this.c();
        if (list.size() > 1) {
            throw ayv.b();
        }
        return list.get(0);
    }
}

