/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.property.editor;

import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.PropertyEditor;

public abstract class AbstractPropertyEditor<T, C extends Node>
implements PropertyEditor<T> {
    private final PropertySheet.Item property;
    private final C control;
    private boolean suspendUpdate;

    public AbstractPropertyEditor(PropertySheet.Item item, C c2) {
        this(item, c2, !item.isEditable());
    }

    public AbstractPropertyEditor(PropertySheet.Item item, C c2, boolean bl2) {
        this.control = c2;
        this.property = item;
        if (!bl2) {
            this.getObservableValue().addListener((observableValue, object, object2) -> {
                if (!this.suspendUpdate) {
                    this.suspendUpdate = true;
                    this.property.setValue(this.getValue());
                    this.suspendUpdate = false;
                }
            });
            if (item.getObservableValue().isPresent()) {
                item.getObservableValue().get().addListener((observableValue, object, object2) -> {
                    if (!this.suspendUpdate) {
                        this.suspendUpdate = true;
                        this.setValue(item.getValue());
                        this.suspendUpdate = false;
                    }
                });
            }
        }
    }

    protected abstract ObservableValue<T> getObservableValue();

    public final PropertySheet.Item getProperty() {
        return this.property;
    }

    public C getEditor() {
        return this.control;
    }

    @Override
    public T getValue() {
        return (T)this.getObservableValue().getValue();
    }
}

