/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.generation;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.agrona.generation.DynamicPackageOutputManager;

public class StringWriterOutputManager
implements DynamicPackageOutputManager {
    private String packageName;
    private String initialPackageName;
    private final HashMap<String, StringWriter> sourceFileByName = new HashMap();

    @Override
    public Writer createOutput(String string) {
        StringWriter stringWriter = new StringWriter();
        this.sourceFileByName.put(this.packageName + "." + string, stringWriter);
        return new FilterWriter(stringWriter){

            @Override
            public void close() throws IOException {
                super.close();
                if (null != StringWriterOutputManager.this.initialPackageName) {
                    StringWriterOutputManager.this.packageName = StringWriterOutputManager.this.initialPackageName;
                }
            }
        };
    }

    @Override
    public void setPackageName(String string) {
        this.packageName = string;
        if (null == this.initialPackageName) {
            this.initialPackageName = string;
        }
    }

    public CharSequence getSource(String string) {
        StringWriter stringWriter = this.sourceFileByName.get(string);
        if (null == stringWriter) {
            throw new IllegalArgumentException("unknown source file name: " + string);
        }
        return stringWriter.toString();
    }

    public Map<String, CharSequence> getSources() {
        HashMap<String, CharSequence> hashMap = new HashMap<String, CharSequence>();
        for (Map.Entry<String, StringWriter> entry : this.sourceFileByName.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().toString());
        }
        return hashMap;
    }

    public void clear() {
        this.initialPackageName = null;
        this.packageName = "";
        this.sourceFileByName.clear();
    }
}

