/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.nio.channels.ClosedByInterruptException;
import java.util.Objects;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.status.AtomicCounter;

public class AgentInvoker
implements AutoCloseable {
    private boolean isClosed = false;
    private boolean isStarted = false;
    private boolean isRunning = false;
    private final AtomicCounter errorCounter;
    private final ErrorHandler errorHandler;
    private final Agent agent;

    public AgentInvoker(ErrorHandler errorHandler, AtomicCounter atomicCounter, Agent agent) {
        Objects.requireNonNull(errorHandler, "errorHandler");
        Objects.requireNonNull(agent, "agent");
        this.errorHandler = errorHandler;
        this.errorCounter = atomicCounter;
        this.agent = agent;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Agent agent() {
        return this.agent;
    }

    public void start() {
        try {
            if (!this.isStarted) {
                this.isStarted = true;
                this.agent.onStart();
                this.isRunning = true;
            }
        }
        catch (Throwable throwable) {
            this.errorHandler.onError(throwable);
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            this.close();
        }
    }

    public int invoke() {
        int n2;
        block8: {
            n2 = 0;
            if (this.isRunning) {
                try {
                    n2 = this.agent.doWork();
                    if (n2 <= 0 && Thread.currentThread().isInterrupted()) {
                        this.isRunning = false;
                    }
                }
                catch (InterruptedException | ClosedByInterruptException exception) {
                    this.close();
                    Thread.currentThread().interrupt();
                }
                catch (AgentTerminationException agentTerminationException) {
                    this.isRunning = false;
                    this.handleError(agentTerminationException);
                    this.close();
                }
                catch (Throwable throwable) {
                    boolean bl2 = Thread.currentThread().isInterrupted();
                    if (bl2) {
                        this.isRunning = false;
                    }
                    this.handleError(throwable);
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    if (!bl2 && !Thread.currentThread().isInterrupted()) break block8;
                    this.isRunning = false;
                    this.close();
                }
            }
        }
        return n2;
    }

    @Override
    public final void close() {
        block3: {
            try {
                if (!this.isClosed) {
                    this.isRunning = false;
                    this.isClosed = true;
                    this.agent.onClose();
                }
            }
            catch (Throwable throwable) {
                this.errorHandler.onError(throwable);
                if (!(throwable instanceof Error)) break block3;
                throw (Error)throwable;
            }
        }
    }

    private void handleError(Throwable throwable) {
        if (null != this.errorCounter && this.isRunning && !this.errorCounter.isClosed()) {
            this.errorCounter.increment();
        }
        this.errorHandler.onError(throwable);
    }
}

