/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSource;

public abstract class ResponseBody
implements Closeable {
    private Reader reader;

    @Nullable
    public abstract MediaType contentType();

    public abstract long contentLength();

    public final InputStream byteStream() {
        return this.source().inputStream();
    }

    public abstract BufferedSource source();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] bytes() throws IOException {
        byte[] byArray;
        long l2 = this.contentLength();
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException("Cannot buffer entire body for content length: " + l2);
        }
        BufferedSource bufferedSource = this.source();
        try {
            byArray = bufferedSource.readByteArray();
        }
        finally {
            Util.closeQuietly(bufferedSource);
        }
        if (l2 != -1L && l2 != (long)byArray.length) {
            throw new IOException("Content-Length (" + l2 + ") and stream length (" + byArray.length + ") disagree");
        }
        return byArray;
    }

    public final Reader charStream() {
        Reader reader = this.reader;
        return reader != null ? reader : (this.reader = new BomAwareReader(this.source(), this.charset()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String string() throws IOException {
        BufferedSource bufferedSource = this.source();
        try {
            Charset charset = Util.bomAwareCharset(bufferedSource, this.charset());
            String string = bufferedSource.readString(charset);
            return string;
        }
        finally {
            Util.closeQuietly(bufferedSource);
        }
    }

    private Charset charset() {
        MediaType mediaType = this.contentType();
        return mediaType != null ? mediaType.charset(Util.UTF_8) : Util.UTF_8;
    }

    @Override
    public void close() {
        Util.closeQuietly(this.source());
    }

    public static ResponseBody create(@Nullable MediaType mediaType, String string) {
        Charset charset = Util.UTF_8;
        if (mediaType != null && (charset = mediaType.charset()) == null) {
            charset = Util.UTF_8;
            mediaType = MediaType.parse(mediaType + "; charset=utf-8");
        }
        Buffer buffer = new Buffer().writeString(string, charset);
        return ResponseBody.create(mediaType, buffer.size(), buffer);
    }

    public static ResponseBody create(@Nullable MediaType mediaType, byte[] byArray) {
        Buffer buffer = new Buffer().write(byArray);
        return ResponseBody.create(mediaType, byArray.length, buffer);
    }

    public static ResponseBody create(final @Nullable MediaType mediaType, final long l2, final BufferedSource bufferedSource) {
        if (bufferedSource == null) {
            throw new NullPointerException("source == null");
        }
        return new ResponseBody(){

            @Override
            @Nullable
            public MediaType contentType() {
                return mediaType;
            }

            @Override
            public long contentLength() {
                return l2;
            }

            @Override
            public BufferedSource source() {
                return bufferedSource;
            }
        };
    }

    static final class BomAwareReader
    extends Reader {
        private final BufferedSource source;
        private final Charset charset;
        private boolean closed;
        private Reader delegate;

        BomAwareReader(BufferedSource bufferedSource, Charset charset) {
            this.source = bufferedSource;
            this.charset = charset;
        }

        @Override
        public int read(char[] cArray, int n2, int n3) throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            Reader reader = this.delegate;
            if (reader == null) {
                Charset charset = Util.bomAwareCharset(this.source, this.charset);
                reader = this.delegate = new InputStreamReader(this.source.inputStream(), charset);
            }
            return reader.read(cArray, n2, n3);
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            if (this.delegate != null) {
                this.delegate.close();
            } else {
                this.source.close();
            }
        }
    }
}

