/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.EditableDataSet;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.AbstractDataSet;
import io.fair_acc.dataset.spi.fastutil.DoubleArrayList;
import io.fair_acc.dataset.utils.AssertUtils;

public class MultiDimDoubleDataSet
extends AbstractDataSet<MultiDimDoubleDataSet>
implements EditableDataSet {
    private static final long serialVersionUID = -493232313124620828L;
    protected DoubleArrayList[] values;

    public MultiDimDoubleDataSet(String string) {
        this(string, 2);
    }

    public MultiDimDoubleDataSet(DataSet dataSet) {
        this(dataSet.getName(), dataSet.getDimension());
        this.set(dataSet);
    }

    public MultiDimDoubleDataSet(String string, int n2) {
        this(string, n2, 0);
    }

    public MultiDimDoubleDataSet(String string, boolean bl2, double[] ... dArray) {
        this(string, dArray.length);
        this.values = new DoubleArrayList[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (bl2) {
                this.values[i2] = new DoubleArrayList(dArray[i2].length);
                this.values[i2].addElements(0, dArray[i2]);
            } else {
                this.values[i2] = DoubleArrayList.wrap(dArray[i2]);
            }
            this.getAxisDescription(i2).add(dArray[i2]);
        }
    }

    public MultiDimDoubleDataSet(String string, int n2, int n3) {
        super(string, n2);
        AssertUtils.gtThanZero("nDims", n2);
        AssertUtils.gtEqThanZero("initialSize", n3);
        this.values = new DoubleArrayList[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.values[i2] = new DoubleArrayList(n3);
            this.values[i2].size(n3);
        }
    }

    public MultiDimDoubleDataSet add(double ... dArray) {
        return this.add(this.getDataCount(), dArray, null);
    }

    public MultiDimDoubleDataSet add(double[] dArray, String string) {
        this.lock().writeLockGuard(() -> {
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                this.values[i2].add(dArray[i2]);
                this.getAxisDescription(i2).add(dArray[i2]);
            }
            if (string != null) {
                this.addDataLabel(this.values[0].size() - 1, string);
            }
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (MultiDimDoubleDataSet)this.getThis();
    }

    public MultiDimDoubleDataSet add(double[][] dArray) {
        int n2 = dArray[0].length;
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            AssertUtils.notNull("coordinates dim " + i2, dArray[i2]);
            AssertUtils.checkArrayDimension("New Data for dim " + i2, dArray[i2], n2);
        }
        this.lock().writeLockGuard(() -> {
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                this.values[i2].addElements(this.values[i2].size(), dArray[i2], 0, n2);
                this.getAxisDescription(i2).add(dArray[i2]);
            }
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (MultiDimDoubleDataSet)this.getThis();
    }

    @Override
    public MultiDimDoubleDataSet add(int n2, double ... dArray) {
        return this.add(n2, dArray, null);
    }

    public MultiDimDoubleDataSet add(int n2, double[] dArray, String string) {
        if (dArray.length != this.getDimension()) {
            throw new IllegalArgumentException("Dimensionality of new point is different from dataset");
        }
        this.lock().writeLockGuard(() -> {
            int n3 = Math.max(0, Math.min(n2, this.getDataCount()));
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                this.values[i2].add(n3, dArray[i2]);
                this.getAxisDescription(i2).add(dArray[i2]);
            }
            this.getDataLabelMap().addValueAndShiftKeys(n3, this.values[0].size(), string);
            this.getDataStyleMap().shiftKeys(n3, this.values[0].size());
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (MultiDimDoubleDataSet)this.getThis();
    }

    public MultiDimDoubleDataSet add(int n2, double[][] dArray) {
        int n3;
        int n4 = Integer.MAX_VALUE;
        for (n3 = 0; n3 < this.values.length; ++n3) {
            AssertUtils.notNull("coordinates in dim " + n3, dArray[n3]);
            n4 = Math.min(n4, dArray[n3].length);
        }
        n3 = n4;
        this.lock().writeLockGuard(() -> {
            int n4 = Math.max(0, Math.min(n2, this.getDataCount() + 1));
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                this.values[i2].addElements(n4, dArray[i2], 0, n3);
                this.getAxisDescription(0).add(dArray[i2], n3);
            }
            this.getDataLabelMap().shiftKeys(n4, this.values[0].size());
            this.getDataStyleMap().shiftKeys(n4, this.values[0].size());
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (MultiDimDoubleDataSet)this.getThis();
    }

    public MultiDimDoubleDataSet clearData() {
        this.lock().writeLockGuard(() -> {
            for (DoubleArrayList doubleArrayList : this.values) {
                doubleArrayList.clear();
            }
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            this.clearMetaInfo();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetDataRemoved);
        return (MultiDimDoubleDataSet)this.getThis();
    }

    @Override
    public final double get(int n2, int n3) {
        return this.values[n2].elements()[n3];
    }

    public int getCapacity() {
        int n2 = Integer.MAX_VALUE;
        for (DoubleArrayList doubleArrayList : this.values) {
            n2 = Math.min(n2, doubleArrayList.elements().length);
        }
        return n2;
    }

    @Override
    public final double[] getValues(int n2) {
        return this.values[n2].elements();
    }

    public MultiDimDoubleDataSet increaseCapacity(int n2) {
        this.lock().writeLockGuard(() -> {
            int n3 = this.getDataCount();
            this.resize(this.getCapacity() + n2);
            this.resize(n3);
        });
        return (MultiDimDoubleDataSet)this.getThis();
    }

    @Override
    public EditableDataSet remove(int n2) {
        return this.remove(n2, n2 + 1);
    }

    public MultiDimDoubleDataSet remove(int n2, int n3) {
        this.lock().writeLockGuard(() -> {
            AssertUtils.indexInBounds(n2, this.getDataCount(), "fromIndex");
            AssertUtils.indexInBounds(n3, this.getDataCount(), "toIndex");
            AssertUtils.indexOrder(n2, "fromIndex", n3, "toIndex");
            for (DoubleArrayList doubleArrayList : this.values) {
                doubleArrayList.removeElements(n2, n3);
            }
            this.getDataLabelMap().remove(n2, n3);
            this.getDataStyleMap().remove(n2, n3);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetDataRemoved);
        return (MultiDimDoubleDataSet)this.getThis();
    }

    public MultiDimDoubleDataSet resize(int n2) {
        this.lock().writeLockGuard(() -> {
            for (DoubleArrayList doubleArrayList : this.values) {
                doubleArrayList.size(n2);
            }
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (MultiDimDoubleDataSet)this.getThis();
    }

    @Override
    public MultiDimDoubleDataSet set(DataSet dataSet, boolean bl2) {
        this.lock().writeLockGuard(() -> dataSet.lock().writeLockGuard(() -> {
            String string;
            int n2;
            this.resize(0);
            double[][] dArrayArray = new double[dataSet.getDimension()][];
            for (n2 = 0; n2 < dataSet.getDimension(); ++n2) {
                dArrayArray[n2] = dataSet.getValues(n2);
            }
            if (dataSet.getDimension() == 2) {
                this.set(dArrayArray, dataSet.getDataCount(), bl2);
            } else {
                this.set(dArrayArray, bl2);
            }
            for (n2 = 0; n2 < dataSet.getDimension(); ++n2) {
                this.recomputeLimits(n2);
            }
            for (n2 = 0; n2 < dataSet.getDataCount(); ++n2) {
                string = dataSet.getDataLabel(n2);
                if (string == null) continue;
                this.addDataLabel(n2, string);
            }
            for (n2 = 0; n2 < dataSet.getDataCount(); ++n2) {
                string = dataSet.getStyle(n2);
                if (string == null) continue;
                this.addDataStyle(n2, string);
            }
            this.setStyle(dataSet.getStyle());
        }));
        this.fireInvalidated(ChartBits.DataSetData);
        return (MultiDimDoubleDataSet)this.getThis();
    }

    public MultiDimDoubleDataSet set(double[][] dArray) {
        return this.set(dArray, true);
    }

    public MultiDimDoubleDataSet set(double[][] dArray, boolean bl2) {
        int n2 = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            AssertUtils.notNull(i2 + "-th coordinates", dArray[i2]);
            n2 = Math.min(n2, dArray[i2].length);
        }
        return this.set(dArray, n2, bl2);
    }

    public MultiDimDoubleDataSet set(double[][] dArray, int n2, boolean bl2) {
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            AssertUtils.notNull(i2 + "-th coordinates", dArray[i2]);
        }
        this.lock().writeLockGuard(() -> {
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            if (bl2) {
                this.resize(0);
                for (int i2 = 0; i2 < this.values.length; ++i2) {
                    this.values[i2].addElements(0, dArray[i2], 0, n2);
                }
            } else {
                for (int i3 = 0; i3 < this.values.length; ++i3) {
                    this.values[i3] = DoubleArrayList.wrap(dArray[i3]);
                }
            }
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (MultiDimDoubleDataSet)this.getThis();
    }

    public MultiDimDoubleDataSet setValues(int n2, double[] dArray, boolean bl2) {
        AssertUtils.notNull("X coordinates", dArray);
        AssertUtils.gtOrEqual("Available dimensions", n2, this.values.length);
        this.lock().writeLockGuard(() -> {
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            if (bl2) {
                this.values[n2].clear();
                this.values[n2].addElements(0, dArray);
            } else {
                this.values[n2] = DoubleArrayList.wrap(dArray);
            }
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (MultiDimDoubleDataSet)this.getThis();
    }

    @Override
    public MultiDimDoubleDataSet set(int n2, double ... dArray) {
        this.lock().writeLockGuard(() -> {
            int n3 = Math.max(n2 + 1, this.getDataCount());
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                this.values[i2].size(n3);
                this.values[i2].elements()[n2] = dArray[i2];
            }
            this.getDataLabelMap().remove(n2);
            this.getDataStyleMap().remove(n2);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (MultiDimDoubleDataSet)this.getThis();
    }

    public MultiDimDoubleDataSet set(int n2, double[][] dArray) {
        this.lock().writeLockGuard(() -> {
            this.resize(Math.max(n2 + dArray[0].length, this.values[0].size()));
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                System.arraycopy(dArray[i2], 0, this.values[i2].elements(), n2, dArray[i2].length);
            }
            this.getDataLabelMap().remove(n2, n2 + dArray[0].length);
            this.getDataStyleMap().remove(n2, n2 + dArray[0].length);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (MultiDimDoubleDataSet)this.getThis();
    }

    public MultiDimDoubleDataSet trim() {
        this.lock().writeLockGuard(() -> {
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                this.values[i2].trim(i2);
            }
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (MultiDimDoubleDataSet)this.getThis();
    }

    @Override
    public int getDataCount() {
        return this.values[0].size();
    }

    public double getValue(int n2, double d2) {
        int n3 = this.getIndex(0, d2);
        double d3 = this.get(0, n3);
        double d4 = this.get(n2, n3);
        int n4 = d3 < d2 ? n3 + 1 : n3 - 1;
        n4 = Math.max(0, Math.min(n4, this.getDataCount() - 1));
        double d5 = this.get(n2, n4);
        if (Double.isNaN(d4) || Double.isNaN(d5)) {
            return Double.NaN;
        }
        double d6 = this.get(0, n4);
        if (d3 == d6) {
            return d4;
        }
        return d4 + (d5 - d4) * (d2 - d3) / (d6 - d3);
    }
}

