/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi;

import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.AxisTransform;
import io.fair_acc.chartfx.renderer.ContourType;
import io.fair_acc.chartfx.renderer.datareduction.DefaultDataReducer3D;
import io.fair_acc.chartfx.renderer.datareduction.ReductionType;
import io.fair_acc.chartfx.renderer.spi.ContourDataSetRenderer;
import io.fair_acc.chartfx.renderer.spi.utils.ColorGradient;
import io.fair_acc.chartfx.utils.WritableImageCache;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.GridDataSet;
import io.fair_acc.dataset.spi.DataRange;
import io.fair_acc.dataset.utils.ByteArrayCache;
import io.fair_acc.dataset.utils.CachedDaemonThreadFactory;
import io.fair_acc.dataset.utils.DoubleArrayCache;
import io.fair_acc.dataset.utils.ProcessingProfiler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContourDataSetCache
extends WritableImageCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContourDataSetCache.class);
    private static final String PARALLEL_WORKER_ERROR = "one parallel worker thread finished execution with error";
    private static final int BGRA_BYTE_SIZE = 4;
    private static final int REF_WIDTH_PARALLEL = 1024;
    private static final int REF_HEIGHT_PARALLEL = 1000;
    protected final DataSet dataSet;
    protected final Axis xAxis;
    protected final Axis yAxis;
    protected final Axis zAxis;
    protected double xAxisWidth;
    protected double yAxisHeight;
    protected double xMin;
    protected double yMin;
    protected double xMax;
    protected double yMax;
    protected double xDataPixelMin;
    protected double xDataPixelMax;
    protected double xDataPixelRange;
    protected double yDataPixelMin;
    protected double yDataPixelMax;
    protected double yDataPixelRange;
    protected int indexXMin;
    protected int indexXMax;
    protected int indexYMin;
    protected int indexYMax;
    protected int xSize;
    protected int ySize;
    protected double zMin;
    protected double zMax;
    protected final boolean xInverted;
    protected final boolean yInverted;
    protected final boolean zInverted;
    protected final double[] dataBuffer;
    protected double[] tempDataBuffer;
    protected final double[] reduced;

    public ContourDataSetCache(XYChart xYChart, ContourDataSetRenderer contourDataSetRenderer, DataSet dataSet) {
        if (dataSet.getDimension() < 3) {
            throw new IllegalArgumentException("dataSet needs be at least 3D but is " + dataSet.getDimension());
        }
        if (!(dataSet instanceof GridDataSet)) {
            throw new IllegalArgumentException("dataSet needs be GridDataSet");
        }
        GridDataSet gridDataSet = (GridDataSet)dataSet;
        if (gridDataSet.getNGrid() < 2) {
            throw new IllegalArgumentException("Contour Renderer only supports 2D Grids");
        }
        long l2 = ProcessingProfiler.getTimeStamp();
        this.dataSet = dataSet;
        this.xAxis = contourDataSetRenderer.xAxis;
        this.yAxis = contourDataSetRenderer.yAxis;
        this.zAxis = contourDataSetRenderer.zAxis;
        this.zMin = this.zAxis.getMin();
        this.zMax = this.zAxis.getMax();
        this.xInverted = this.xAxis.isInvertedAxis();
        this.yInverted = this.yAxis.isInvertedAxis();
        this.zInverted = this.zAxis.isInvertedAxis();
        this.xAxisWidth = this.xAxis.getWidth();
        this.yAxisHeight = this.yAxis.getHeight();
        this.xMin = this.xInverted ? this.xAxis.getValueForDisplay(this.xAxisWidth) : this.xAxis.getValueForDisplay(0.0);
        this.xMax = this.xInverted ? this.xAxis.getValueForDisplay(0.0) : this.xAxis.getValueForDisplay(this.xAxisWidth);
        this.yMin = this.yInverted ? this.yAxis.getValueForDisplay(0.0) : this.yAxis.getValueForDisplay(this.yAxisHeight);
        this.yMax = this.yInverted ? this.yAxis.getValueForDisplay(this.yAxisHeight) : this.yAxis.getValueForDisplay(0.0);
        double d2 = this.xAxis.getDisplayPosition(dataSet.getAxisDescription(0).getMin());
        double d3 = this.xAxis.getDisplayPosition(dataSet.getAxisDescription(0).getMax());
        double d4 = this.yAxis.getDisplayPosition(dataSet.getAxisDescription(1).getMax());
        double d5 = this.yAxis.getDisplayPosition(dataSet.getAxisDescription(1).getMin());
        this.xDataPixelMin = Math.max(Math.min(d2, d3), 0.0);
        this.xDataPixelMax = Math.min(Math.max(d2, d3), this.xAxisWidth);
        this.yDataPixelMin = Math.max(Math.min(d4, d5), 0.0);
        this.yDataPixelMax = Math.min(Math.max(d4, d5), this.yAxisHeight);
        this.xDataPixelRange = Math.abs(this.xDataPixelMax - this.xDataPixelMin);
        this.yDataPixelRange = Math.abs(this.yDataPixelMax - this.yDataPixelMin);
        int n2 = Math.max(0, gridDataSet.getGridIndex(0, this.xMin));
        int n3 = Math.min(gridDataSet.getGridIndex(0, this.xMax), gridDataSet.getShape(0) - 1);
        int n4 = Math.max(0, gridDataSet.getGridIndex(1, this.yMax));
        int n5 = Math.min(gridDataSet.getGridIndex(1, this.yMin), gridDataSet.getShape(1) - 1);
        this.indexXMin = Math.min(n2, n3);
        this.indexXMax = Math.max(n2, n3);
        this.indexYMin = Math.min(n4, n5);
        this.indexYMax = Math.max(n4, n5);
        this.xSize = Math.abs(this.indexXMax - this.indexXMin) + 1;
        this.ySize = Math.abs(this.indexYMax - this.indexYMin) + 1;
        this.dataBuffer = DoubleArrayCache.getInstance().getArrayExact(this.xSize * this.ySize);
        int n6 = 1024000;
        boolean bl2 = this.xSize * this.ySize < 1024000;
        ContourDataSetCache.copySubFrame(dataSet, this.dataBuffer, contourDataSetRenderer.isParallelImplementation() && bl2, this.xInverted, this.indexXMin, this.indexXMax, this.yInverted, this.indexYMin, this.indexYMax);
        ProcessingProfiler.getTimeDiff(l2, "copySubFrame");
        this.reduced = this.reduceDataArray(this.dataBuffer, this.xSize, this.ySize, contourDataSetRenderer);
        ProcessingProfiler.getTimeDiff(l2, "data reduction");
        boolean bl3 = contourDataSetRenderer.computeLocalRange() && (this.zAxis.isAutoRanging() || this.zAxis.isAutoGrowRanging());
        DataRange dataRange = ContourDataSetCache.computeLocalRange(this.reduced, this.xSize, this.ySize, bl3);
        if (dataRange.isDefined()) {
            this.zMin = dataRange.getMin();
            this.zMax = dataRange.getMax();
        }
        ProcessingProfiler.getTimeDiff(l2, "recompute local z range");
        AxisTransform axisTransform = this.zAxis.getAxisTransform();
        if (axisTransform == null) {
            throw new IllegalArgumentException("zAxis of renderer needs to have an axis transform for its z-Axis");
        }
        int n7 = contourDataSetRenderer.getNumberQuantisationLevels();
        ContourDataSetCache.quantizeData(this.reduced, this.xSize, this.ySize, this.zInverted, this.zMin, this.zMax, axisTransform, n7);
        ProcessingProfiler.getTimeDiff(l2, "quantized data");
    }

    protected static void quantizeData(double[] dArray, int n2, int n3, boolean bl2, double d2, double d3, AxisTransform axisTransform, int n4) {
        double d4 = axisTransform.forward(d2);
        double d5 = Math.abs(axisTransform.forward(d3) - d4);
        double d6 = 1.0 / d5;
        int n5 = n2 * n3;
        for (int i2 = 0; i2 < n5; ++i2) {
            double d7 = dArray[i2];
            double d8 = (axisTransform.forward(d7) - d4) * d6;
            dArray[i2] = bl2 ? ContourDataSetCache.quantize(1.0 - d8, n4) : ContourDataSetCache.quantize(d8, n4);
        }
    }

    public void releaseCachedVariables() {
        DoubleArrayCache.getInstance().add(this.dataBuffer);
        DoubleArrayCache.getInstance().add(this.tempDataBuffer);
    }

    protected double[] reduceDataArray(double[] dArray, int n2, int n3, ContourDataSetRenderer contourDataSetRenderer) {
        boolean bl2;
        int n4 = Math.max(contourDataSetRenderer.getReductionFactorX(), 1);
        int n5 = Math.max(contourDataSetRenderer.getReductionFactorY(), 1);
        ReductionType reductionType = contourDataSetRenderer.getReductionType();
        double d2 = (double)n4 * (double)this.xSize / this.xAxisWidth;
        double d3 = (double)n5 * (double)this.ySize / this.yAxisHeight;
        boolean bl3 = d2 > 1.0 && this.xSize > 10;
        boolean bl4 = bl2 = d3 > 1.0 && this.ySize > 10;
        if ((bl3 || bl2) && contourDataSetRenderer.isActualReducePoints()) {
            int n6 = (int)((double)n2 / Math.max(d2, 1.0));
            int n7 = (int)((double)n3 / Math.max(d3, 1.0));
            ContourType contourType = contourDataSetRenderer.getContourType();
            if (contourType.equals((Object)ContourType.HEATMAP_HEXAGON)) {
                double d4 = Math.min(n4, n5);
                double d5 = Math.max(d4 * (double)this.xSize / this.xAxisWidth, 1.0);
                double d6 = Math.max(d4 * (double)this.ySize / this.yAxisHeight, 1.0);
                n6 = (int)((double)n2 / d5);
                n7 = (int)((double)n3 / d6);
            }
            this.tempDataBuffer = DoubleArrayCache.getInstance().getArrayExact(n6 * n7);
            DefaultDataReducer3D.resample(dArray, n2, n3, this.tempDataBuffer, n6, n7, reductionType);
            this.xSize = n6;
            this.ySize = n7;
            return this.tempDataBuffer;
        }
        double[] dArray2 = dArray;
        return dArray2;
    }

    protected static void computeCoordinates(GridDataSet gridDataSet, double[] dArray, int n2, boolean bl2, int n3, int n4, boolean bl3, int n5, int n6, int n7) {
        int n8 = Math.abs(n4 - n3) + 1;
        int n9 = gridDataSet.getNGrid();
        switch (InvertedAxisCase.get(bl2, bl3)) {
            case X_ONLY: {
                for (int i2 = n5; i2 <= n6; ++i2) {
                    int n10 = (i2 - n7 + 1) * n8 - 1;
                    for (int i3 = 0; i3 < n8; ++i3) {
                        dArray[n10 - i3] = gridDataSet.get(n9, i3 + n3, i2);
                    }
                }
                break;
            }
            case Y_ONLY: {
                int n11 = n2 - (n5 - n7 + 1) * n8;
                for (int i4 = n5; i4 <= n6; ++i4) {
                    for (int i5 = 0; i5 < n8; ++i5) {
                        dArray[n11 + i5] = gridDataSet.get(n9, i5 + n3, i4);
                    }
                    n11 -= n8;
                }
                break;
            }
            case BOTH: {
                int n12 = n2 - 1 - (n5 - n7) * n8;
                for (int i6 = n5; i6 <= n6; ++i6) {
                    for (int i7 = 0; i7 < n8; ++i7) {
                        dArray[n12 - i7] = gridDataSet.get(n9, i7 + n3, i6);
                    }
                    n12 -= n8;
                }
                break;
            }
            default: {
                for (int i8 = n5; i8 <= n6; ++i8) {
                    int n13 = (i8 - n7) * n8;
                    for (int i9 = 0; i9 < n8; ++i9) {
                        dArray[n13 + i9] = gridDataSet.get(n9, i9 + n3, i8);
                    }
                }
            }
        }
    }

    protected static DataRange computeLocalRange(double[] dArray, int n2, int n3, boolean bl2) {
        DataRange dataRange = new DataRange();
        if (bl2) {
            int n4 = n2 * n3;
            for (int i2 = 0; i2 < n4; ++i2) {
                dataRange.add(dArray[i2]);
            }
        }
        return dataRange;
    }

    protected static void copySubFrame(DataSet dataSet, double[] dArray, boolean bl2, boolean bl3, int n2, int n3, boolean bl4, int n4, int n5) {
        int n6 = Math.abs(n3 - n2) + 1;
        int n7 = Math.abs(n5 - n4) + 1;
        int n8 = n6 * n7;
        if (!bl2) {
            ContourDataSetCache.computeCoordinates((GridDataSet)dataSet, dArray, n8, bl3, n2, n3, bl4, n4, n5, n4);
            return;
        }
        int n9 = CachedDaemonThreadFactory.getNumbersOfThreads();
        int n10 = 500;
        int n11 = (int)Math.ceil((double)n7 / (double)n9);
        int n12 = Math.max(n11, 500);
        ArrayList<Callable<Boolean>> arrayList = new ArrayList<Callable<Boolean>>();
        for (int i2 = n4; i2 < n5; i2 += n12) {
            int n13 = i2;
            arrayList.add(() -> {
                int n9 = n13;
                int n10 = Math.min(n13 + n12, n5);
                ContourDataSetCache.computeCoordinates((GridDataSet)dataSet, dArray, n8, bl3, n2, n3, bl4, n9, n10, n4);
                return Boolean.TRUE;
            });
        }
        try {
            List list = CachedDaemonThreadFactory.getCommonPool().invokeAll(arrayList);
            for (Future future : list) {
                Boolean bl5 = (Boolean)future.get();
                if (!Boolean.FALSE.equals(bl5)) continue;
                throw new IllegalStateException(PARALLEL_WORKER_ERROR);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new IllegalStateException(PARALLEL_WORKER_ERROR, exception);
        }
    }

    protected static double quantize(double d2, int n2) {
        return (double)((int)(d2 * (double)n2)) / (double)n2;
    }

    protected WritableImage convertDataArrayToImage(double[] dArray, int n2, int n3, ColorGradient colorGradient) {
        int n4 = n2 * n3;
        byte[] byArray = ByteArrayCache.getInstance().getArrayExact(n4 * 4);
        int n5 = 4 * n2;
        WritableImage writableImage = this.getImage(n2, n3);
        PixelWriter pixelWriter = writableImage.getPixelWriter();
        if (pixelWriter == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.atError().log("Could not get PixelWriter for image");
            }
            return writableImage;
        }
        int n6 = n3 - 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n7 = n2 * i2;
            int n8 = n5 * (n6 - i2);
            for (int i3 = 0; i3 < n2; ++i3) {
                int[] nArray = colorGradient.getColorBytes(dArray[n7 + i3]);
                int n9 = n8 + i3 * 4;
                byArray[n9] = (byte)nArray[3];
                byArray[n9 + 1] = (byte)nArray[2];
                byArray[n9 + 2] = (byte)nArray[1];
                byArray[n9 + 3] = (byte)nArray[0];
            }
        }
        pixelWriter.setPixels(0, 0, n2, n3, (PixelFormat)PixelFormat.getByteBgraPreInstance(), byArray, 0, n5);
        ByteArrayCache.getInstance().add(byArray);
        return writableImage;
    }

    protected static int roundDownEven(double d2) {
        return (int)Math.floor(d2 / 2.0) * 2;
    }

    protected static enum InvertedAxisCase {
        NORMAL,
        X_ONLY,
        Y_ONLY,
        BOTH;


        public static InvertedAxisCase get(boolean bl2, boolean bl3) {
            if (bl2 && bl3) {
                return BOTH;
            }
            if (bl2) {
                return X_ONLY;
            }
            if (bl3) {
                return Y_ONLY;
            }
            return NORMAL;
        }
    }
}

