/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.datareduction;

import io.fair_acc.chartfx.renderer.datareduction.ReductionType;

public final class DefaultDataReducer3D {
    private DefaultDataReducer3D() {
    }

    public static void resample(double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5, ReductionType reductionType) {
        int n6 = (n2 << 16) / n4 + 1;
        int n7 = (n3 << 16) / n5 + 1;
        int n8 = n6 >> 16;
        int n9 = n7 >> 16;
        double d2 = n8 * n9;
        switch (reductionType) {
            case MIN: {
                for (int i2 = 0; i2 < n5; ++i2) {
                    int n10 = i2 * n7 >> 16;
                    int n11 = n10 * n2;
                    int n12 = i2 * n4;
                    for (int i3 = 0; i3 < n4; ++i3) {
                        int n13 = i3 * n6 >> 16;
                        double d3 = Double.MAX_VALUE;
                        for (int i4 = 0; i4 < n9; ++i4) {
                            int n14 = i4 * n2;
                            for (int i5 = 0; i5 < n8; ++i5) {
                                d3 = Math.min(d3, dArray[n11 + n14 + n13 + i5]);
                            }
                        }
                        dArray2[n12 + i3] = d3;
                    }
                }
                break;
            }
            case MAX: {
                for (int i6 = 0; i6 < n5; ++i6) {
                    int n15 = i6 * n7 >> 16;
                    int n16 = n15 * n2;
                    int n17 = i6 * n4;
                    for (int i7 = 0; i7 < n4; ++i7) {
                        int n18 = i7 * n6 >> 16;
                        double d4 = -1.7976931348623157E308;
                        for (int i8 = 0; i8 < n9; ++i8) {
                            int n19 = i8 * n2;
                            for (int i9 = 0; i9 < n8; ++i9) {
                                d4 = Math.max(d4, dArray[n16 + n19 + n18 + i9]);
                            }
                        }
                        dArray2[n17 + i7] = d4;
                    }
                }
                break;
            }
            case DOWN_SAMPLE: {
                for (int i10 = 0; i10 < n5; ++i10) {
                    int n20 = i10 * n7 >> 16;
                    int n21 = n20 * n2;
                    int n22 = i10 * n4;
                    for (int i11 = 0; i11 < n4; ++i11) {
                        int n23 = i11 * n6 >> 16;
                        dArray2[n22 + i11] = dArray[n21 + n23];
                    }
                }
                break;
            }
            default: {
                for (int i12 = 0; i12 < n5; ++i12) {
                    int n24 = i12 * n7 >> 16;
                    int n25 = n24 * n2;
                    int n26 = i12 * n4;
                    for (int i13 = 0; i13 < n4; ++i13) {
                        int n27 = i13 * n6 >> 16;
                        double d5 = 0.0;
                        for (int i14 = 0; i14 < n9; ++i14) {
                            int n28 = i14 * n2;
                            for (int i15 = 0; i15 < n8; ++i15) {
                                d5 += dArray[n25 + n28 + n27 + i15];
                            }
                        }
                        dArray2[n26 + i13] = d5 / d2;
                    }
                }
            }
        }
    }

    public static void scaleDownByFactorTwo(double[] dArray, int n2, int n3, double[] dArray2, int n4, int n5, int n6, int n7, ReductionType reductionType) {
        int n8 = n4 / n2;
        if (n8 != 2 && n8 != 1) {
            throw new IllegalArgumentException("targetWidth=" + n2 + " to srcWidth=" + n4 + " mismatch");
        }
        int n9 = n5 / n3;
        if (n9 != 2 && n9 != 1) {
            throw new IllegalArgumentException("targetHeight=" + n3 + " to srcHeight=" + n5 + " mismatch");
        }
        int n10 = Math.min(n7, n3);
        ScaleAxis scaleAxis = ScaleAxis.get(n8 >= 2, n9 >= 2);
        switch (reductionType) {
            case MIN: {
                DefaultDataReducer3D.scaleDownByFactorTwoMin(dArray, n2, dArray2, n4, n6, n10, scaleAxis);
                break;
            }
            case MAX: {
                DefaultDataReducer3D.scaleDownByFactorTwoMax(dArray, n2, dArray2, n4, n6, n10, scaleAxis);
                break;
            }
            default: {
                DefaultDataReducer3D.scaleDownByFactorTwoAvg(dArray, n2, dArray2, n4, n6, n10, scaleAxis);
            }
        }
    }

    private static void copyIdentity(double[] dArray, int n2, int n3, double[] dArray2, int n4) {
        for (int i2 = n3; i2 <= n4; ++i2) {
            int n5 = i2 * n2;
            if (n2 < 0) continue;
            System.arraycopy(dArray2, n5 + 0, dArray, n5 + 0, n2);
        }
    }

    private static void scaleDownByFactorTwoAvg(double[] dArray, int n2, double[] dArray2, int n3, int n4, int n5, ScaleAxis scaleAxis) {
        switch (scaleAxis) {
            case BOTH: {
                for (int i2 = n4; i2 < n5; ++i2) {
                    int n6 = i2 << 1;
                    int n7 = n6 * n3;
                    int n8 = n7 + n3;
                    for (int i3 = 0; i3 < n2; ++i3) {
                        double d2;
                        int n9 = n7 + (i3 << 1);
                        int n10 = n8 + (i3 << 1);
                        double d3 = 0.5 * (dArray2[n9] + dArray2[n9 + 1]);
                        double d4 = 0.5 * (dArray2[n10] + dArray2[n10 + 1]);
                        dArray[i2 * n2 + i3] = d2 = 0.5 * (d3 + d4);
                    }
                }
                return;
            }
            case X_ONLY: {
                for (int i4 = n4; i4 <= n5; ++i4) {
                    int n11 = i4 * n3;
                    int n12 = i4 * n2;
                    for (int i5 = 0; i5 < n2; ++i5) {
                        double d5;
                        int n13 = n11 + (i5 << 1);
                        dArray[n12 + i5] = d5 = 0.5 * (dArray2[n13] + dArray2[n13 + 1]);
                    }
                }
                return;
            }
            case Y_ONLY: {
                for (int i6 = n4; i6 < n5; ++i6) {
                    int n14 = i6 << 1;
                    int n15 = n14 * n3;
                    int n16 = n15 + n3;
                    int n17 = i6 * n2;
                    for (int i7 = 0; i7 < n2; ++i7) {
                        double d6;
                        dArray[n17 + i7] = d6 = 0.5 * (dArray2[n15 + i7] + dArray2[n16 + i7]);
                    }
                }
                return;
            }
        }
        DefaultDataReducer3D.copyIdentity(dArray, n2, n4, dArray2, n5);
    }

    private static void scaleDownByFactorTwoMax(double[] dArray, int n2, double[] dArray2, int n3, int n4, int n5, ScaleAxis scaleAxis) {
        switch (scaleAxis) {
            case BOTH: {
                for (int i2 = n4; i2 < n5; ++i2) {
                    int n6 = i2 << 1;
                    int n7 = n6 * n3;
                    int n8 = n7 + n3;
                    int n9 = i2 * n2;
                    for (int i3 = 0; i3 < n2; ++i3) {
                        double d2;
                        int n10 = n7 + (i3 << 1);
                        int n11 = n8 + (i3 << 1);
                        double d3 = Math.max(dArray2[n10], dArray2[n10 + 1]);
                        double d4 = Math.max(dArray2[n11], dArray2[n11 + 1]);
                        dArray[n9 + i3] = d2 = Math.max(d3, d4);
                    }
                }
                return;
            }
            case X_ONLY: {
                for (int i4 = n4; i4 <= n5; ++i4) {
                    int n12 = i4 * n3;
                    int n13 = i4 * n2;
                    for (int i5 = 0; i5 < n2; ++i5) {
                        double d5;
                        int n14 = n12 + (i5 << 1);
                        dArray[n13 + i5] = d5 = Math.max(dArray2[n14], dArray2[n14 + 1]);
                    }
                }
                return;
            }
            case Y_ONLY: {
                for (int i6 = n4; i6 < n5; ++i6) {
                    int n15 = i6 << 1;
                    int n16 = n15 * n3;
                    int n17 = n16 + n3;
                    int n18 = i6 * n2;
                    for (int i7 = 0; i7 < n2; ++i7) {
                        double d6;
                        dArray[n18 + i7] = d6 = Math.max(dArray2[n16 + i7], dArray2[n17 + i7]);
                    }
                }
                return;
            }
        }
        DefaultDataReducer3D.copyIdentity(dArray, n2, n4, dArray2, n5);
    }

    private static void scaleDownByFactorTwoMin(double[] dArray, int n2, double[] dArray2, int n3, int n4, int n5, ScaleAxis scaleAxis) {
        switch (scaleAxis) {
            case BOTH: {
                for (int i2 = n4; i2 < n5; ++i2) {
                    int n6 = i2 << 1;
                    int n7 = n6 * n3;
                    int n8 = n7 + n3;
                    int n9 = i2 * n2;
                    for (int i3 = 0; i3 < n2; ++i3) {
                        double d2;
                        int n10 = n7 + (i3 << 1);
                        int n11 = n8 + (i3 << 1);
                        double d3 = Math.min(dArray2[n10], dArray2[n10 + 1]);
                        double d4 = Math.min(dArray2[n11], dArray2[n11 + 1]);
                        dArray[n9 + i3] = d2 = Math.min(d3, d4);
                    }
                }
                return;
            }
            case X_ONLY: {
                for (int i4 = n4; i4 <= n5; ++i4) {
                    int n12 = i4 * n2;
                    int n13 = i4 * n3;
                    for (int i5 = 0; i5 < n2; ++i5) {
                        double d5;
                        int n14 = n13 + (i5 << 1);
                        dArray[n12 + i5] = d5 = Math.min(dArray2[n14], dArray2[n14 + 1]);
                    }
                }
                return;
            }
            case Y_ONLY: {
                for (int i6 = n4; i6 < n5; ++i6) {
                    int n15 = i6 << 1;
                    int n16 = n15 * n3;
                    int n17 = n16 + n3;
                    int n18 = i6 * n2;
                    for (int i7 = 0; i7 < n2; ++i7) {
                        double d6;
                        dArray[n18 + i7] = d6 = Math.min(dArray2[n16 + i7], dArray2[n17 + i7]);
                    }
                }
                return;
            }
        }
        DefaultDataReducer3D.copyIdentity(dArray, n2, n4, dArray2, n5);
    }

    private static enum ScaleAxis {
        BOTH,
        X_ONLY,
        Y_ONLY,
        NONE;


        static ScaleAxis get(boolean bl2, boolean bl3) {
            if (bl2 && bl3) {
                return BOTH;
            }
            if (bl2) {
                return X_ONLY;
            }
            if (bl3) {
                return Y_ONLY;
            }
            return NONE;
        }
    }
}

