/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins;

import io.fair_acc.bench.BenchLevel;
import io.fair_acc.bench.MeasurementRecorder;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.bench.LiveDisplayRecorder;
import io.fair_acc.chartfx.plugins.ChartPlugin;
import io.fair_acc.chartfx.utils.FXUtils;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import org.kordamp.ikonli.javafx.FontIcon;

public class BenchPlugin
extends ChartPlugin {
    private static final int FONT_SIZE = 22;
    private static final String ICON_ENABLE_BENCH = "fa-hourglass-start:22";
    private static final String ICON_DISABLE_BENCH = "fa-hourglass-end:22";
    protected final BooleanProperty enabled = new SimpleBooleanProperty(false);
    private final HBox buttons = this.createButtonBar();
    private UnaryOperator<MeasurementRecorder> measurementFilter = measurementRecorder -> measurementRecorder.atLevel(BenchLevel.Info).contains("draw");
    protected final Stage stage = new Stage();
    private static final Runnable NO_OP = () -> {};
    private Runnable resetRecorder = NO_OP;

    protected HBox createButtonBar() {
        Button button = new Button(null, (Node)new FontIcon(ICON_ENABLE_BENCH));
        button.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        button.setTooltip(new Tooltip("starts displaying live benchmark stats"));
        button.disableProperty().bind((ObservableValue)this.chartProperty().isNull());
        Button button2 = new Button(null, (Node)new FontIcon(ICON_DISABLE_BENCH));
        button2.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        button2.setTooltip(new Tooltip("stops displaying live benchmark stats"));
        FXUtils.bindManagedToVisible((Node)button).bind((ObservableValue)this.enabled.not());
        button.setOnAction(actionEvent -> this.enable());
        FXUtils.bindManagedToVisible((Node)button2).bind((ObservableValue)this.enabled);
        button2.setOnAction(actionEvent -> this.disable());
        HBox hBox = new HBox(new Node[]{button, button2});
        hBox.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        return hBox;
    }

    public BenchPlugin() {
        this.chartProperty().addListener((observableValue, chart, chart2) -> {
            if (chart != null) {
                chart.getToolBar().getChildren().remove((Object)this.buttons);
                if (chart instanceof XYChart) {
                    ((XYChart)chart).setGlobalRecorder(MeasurementRecorder.DISABLED);
                }
                this.enabled.set(false);
            }
            if (chart2 != null && this.isAddButtonsToToolBar()) {
                chart2.getToolBar().getChildren().add((Object)this.buttons);
            }
        });
        this.stage.showingProperty().addListener((observableValue, bl2, bl3) -> {
            if (!bl3.booleanValue()) {
                this.disable();
            }
        });
    }

    public BenchPlugin setFilter(UnaryOperator<MeasurementRecorder> unaryOperator) {
        this.measurementFilter = AssertUtils.notNull("MeasurementFilter", unaryOperator);
        return this;
    }

    public void enable() {
        if (!this.enabled.get() && this.getChart() != null && this.getChart() instanceof XYChart) {
            XYChart xYChart = (XYChart)this.getChart();
            MeasurementRecorder measurementRecorder = this.createRecorder(xYChart);
            xYChart.setGlobalRecorder((MeasurementRecorder)this.measurementFilter.apply(measurementRecorder));
            this.resetRecorder = () -> xYChart.setGlobalRecorder(MeasurementRecorder.DISABLED);
            this.enabled.set(true);
        }
    }

    protected MeasurementRecorder createRecorder(XYChart xYChart) {
        String string2 = Optional.ofNullable(xYChart.getTitle()).filter(string -> !string.isEmpty()).orElse("Benchmark");
        return LiveDisplayRecorder.createChart(string2, parent -> {
            this.stage.setScene(new Scene(parent));
            this.stage.show();
        });
    }

    public void disable() {
        if (this.enabled.get()) {
            this.enabled.set(false);
            this.resetRecorder.run();
            this.resetRecorder = NO_OP;
            this.stage.hide();
        }
    }
}

