/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.plugins.ChartPlugin;
import io.fair_acc.dataset.events.BitState;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.events.EventSource;
import io.fair_acc.dataset.events.StateListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ListChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;

public abstract class AbstractValueIndicator
extends ChartPlugin
implements EventSource {
    private final Axis axis;
    private final StateListener axisBoundsListener = (bitState, n2) -> this.runPostLayout();
    private final BitState state = BitState.initDirty(this);
    private final ListChangeListener<? super ChartPlugin> pluginsListListener = change -> this.updateStyleClass();
    private double xOffset;
    private double yOffset;
    protected final Label label = new Label();
    protected final TextField labelEdit = new TextField();
    protected final Delta dragDelta = new Delta();
    protected final BooleanProperty editableIndicator = new SimpleBooleanProperty(this, "editableIndicator", true){

        protected void invalidated() {
            AbstractValueIndicator.this.runPostLayout();
        }
    };
    private final ObjectProperty<HPos> labelHorizontalAnchor = new SimpleObjectProperty<HPos>((Object)this, "labelHorizontalAnchor", HPos.CENTER){

        protected void invalidated() {
            AbstractValueIndicator.this.runPostLayout();
        }
    };
    private final ObjectProperty<VPos> labelVerticalAnchor = new SimpleObjectProperty<VPos>((Object)this, "labelVerticalAnchor", VPos.CENTER){

        protected void invalidated() {
            AbstractValueIndicator.this.runPostLayout();
        }
    };

    protected AbstractValueIndicator(Axis axis, String string3) {
        this.axis = axis;
        this.setText(string3);
        this.label.pickOnBoundsProperty().set(true);
        this.label.toFront();
        this.label.setOnMousePressed(mouseEvent -> {
            if (mouseEvent.isPrimaryButtonDown() && this.isEditable()) {
                Point2D point2D = this.label.sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY());
                this.dragDelta.x = -(point2D.getX() + this.xOffset);
                this.dragDelta.y = point2D.getY() + this.yOffset;
                this.label.setCursor(Cursor.MOVE);
                mouseEvent.consume();
            }
        });
        this.label.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                this.label.setVisible(false);
                this.getChartChildren().add((Object)this.labelEdit);
                this.labelEdit.requestFocus();
                this.labelEdit.setLayoutX(this.label.getLayoutX());
                this.labelEdit.setLayoutY(this.label.getLayoutY());
                this.labelEdit.resizeRelocate(this.label.getLayoutX() - 20.0, this.label.getLayoutY() - 5.0, this.label.getWidth() + 40.0, this.label.getHeight() + 10.0);
                this.labelEdit.setOnAction(actionEvent -> {
                    this.label.setText(this.labelEdit.getText());
                    this.getChartChildren().remove((Object)this.labelEdit);
                    this.label.setVisible(true);
                });
                this.labelEdit.setOnKeyPressed(keyEvent -> {
                    if (keyEvent.getCode().equals((Object)KeyCode.DELETE) && keyEvent.isControlDown()) {
                        this.getChart().getPlugins().remove((Object)this);
                    }
                    if (keyEvent.getCode().equals((Object)KeyCode.ESCAPE)) {
                        this.getChartChildren().remove((Object)this.labelEdit);
                        this.label.setVisible(true);
                    }
                });
            }
        });
        this.editableIndicatorProperty().addListener((observableValue, bl2, bl3) -> this.updateMouseListener((boolean)bl3));
        this.updateMouseListener(this.isEditable());
        this.chartProperty().addListener((observableValue, chart, chart2) -> {
            if (chart != null) {
                this.removeAxisListener();
                this.removePluginsListListener((Chart)chart);
            }
            if (chart2 != null) {
                this.addAxisListener();
                this.addPluginsListListener((Chart)chart2);
            }
        });
        this.textProperty().addListener((observableValue, string, string2) -> this.runPostLayout());
    }

    private void addAxisListener() {
        Axis axis = this.getAxis();
        axis.getBitState().addChangeListener(ChartBits.AxisRange, this.axisBoundsListener);
    }

    protected void addChildNodeIfNotPresent(Node node) {
        if (!this.getChartChildren().contains((Object)node)) {
            this.getChartChildren().add(0, (Object)node);
            node.setManaged(false);
        }
    }

    private void addPluginsListListener(Chart chart) {
        chart.getPlugins().addListener(this.pluginsListListener);
        this.updateStyleClass();
    }

    public final BooleanProperty editableIndicatorProperty() {
        return this.editableIndicator;
    }

    private int getIndicatorInstanceIndex() {
        if (this.getChart() == null) {
            return 0;
        }
        Class<?> clazz = this.getClass();
        int n2 = -1;
        for (ChartPlugin chartPlugin : this.getChart().getPlugins()) {
            if (chartPlugin.getClass().equals(clazz)) {
                ++n2;
            }
            if (chartPlugin != this) continue;
            break;
        }
        return Math.max(n2, 0);
    }

    public final HPos getLabelHorizontalAnchor() {
        return (HPos)this.labelHorizontalAnchorProperty().get();
    }

    public final VPos getLabelVerticalAnchor() {
        return (VPos)this.labelVerticalAnchorProperty().get();
    }

    public Axis getAxis() {
        return this.axis;
    }

    public final String getText() {
        return (String)this.textProperty().get();
    }

    public final boolean isEditable() {
        return this.editableIndicatorProperty().get();
    }

    public final ObjectProperty<HPos> labelHorizontalAnchorProperty() {
        return this.labelHorizontalAnchor;
    }

    public final ObjectProperty<VPos> labelVerticalAnchorProperty() {
        return this.labelVerticalAnchor;
    }

    protected final void layoutLabel(Bounds bounds, double d2, double d3) {
        if (this.label.getText() == null || this.label.getText().isEmpty()) {
            this.getChartChildren().remove((Object)this.label);
            return;
        }
        double d4 = bounds.getMinX();
        double d5 = bounds.getMinY();
        this.xOffset = bounds.getWidth() * d2;
        this.yOffset = bounds.getHeight() * (1.0 - d3);
        double d6 = this.label.prefWidth(-1.0);
        double d7 = this.label.prefHeight(d6);
        if (this.getLabelHorizontalAnchor() == HPos.CENTER) {
            this.xOffset -= d6 / 2.0;
        } else if (this.getLabelHorizontalAnchor() == HPos.RIGHT) {
            this.xOffset -= d6;
        }
        if (this.getLabelVerticalAnchor() == VPos.CENTER) {
            this.yOffset -= d7 / 2.0;
        } else if (this.getLabelVerticalAnchor() == VPos.BASELINE) {
            this.yOffset -= this.label.getBaselineOffset();
        } else if (this.getLabelVerticalAnchor() == VPos.BOTTOM) {
            this.yOffset -= d7;
        }
        this.label.resizeRelocate(d4 + this.xOffset, d5 + this.yOffset, d6, d7);
        this.addChildNodeIfNotPresent((Node)this.label);
    }

    private void removeAxisListener() {
        Axis axis = this.getAxis();
        axis.getBitState().removeChangeListener(this.axisBoundsListener);
    }

    private void removePluginsListListener(Chart chart) {
        chart.getPlugins().removeListener(this.pluginsListListener);
    }

    public final void setEditable(boolean bl2) {
        this.editableIndicatorProperty().set(bl2);
    }

    public final void setLabelHorizontalAnchor(HPos hPos) {
        this.labelHorizontalAnchorProperty().set((Object)hPos);
    }

    public final void setLabelVerticalAnchor(VPos vPos) {
        this.labelVerticalAnchorProperty().set((Object)vPos);
    }

    public void setStyleClasses(Node node, String string, String string2) {
        node.getStyleClass().setAll((Object[])new String[]{string2, string + string2, string + string2 + this.getIndicatorInstanceIndex()});
    }

    public final void setText(String string) {
        this.textProperty().set((Object)string);
    }

    public final StringProperty textProperty() {
        return this.label.textProperty();
    }

    private void updateMouseListener(boolean bl2) {
        if (bl2) {
            this.label.setOnMouseReleased(mouseEvent -> this.label.setCursor(Cursor.HAND));
            this.label.setOnMouseEntered(mouseEvent -> this.label.setCursor(Cursor.HAND));
        } else {
            this.label.setOnMouseReleased(null);
            this.label.setOnMouseEntered(null);
        }
    }

    public abstract void updateStyleClass();

    @Override
    public BitState getBitState() {
        return this.state;
    }

    protected static class Delta {
        protected double x;
        protected double y;

        protected Delta() {
        }
    }
}

