/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.legend.spi;

import io.fair_acc.chartfx.legend.Legend;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.ui.css.CssPropertyFactory;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.chartfx.ui.css.StyleUtil;
import io.fair_acc.chartfx.ui.geometry.Side;
import io.fair_acc.chartfx.utils.PropUtil;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Label;
import javafx.scene.layout.FlowPane;

public class DefaultLegend
extends FlowPane
implements Legend {
    private static final PseudoClass disabledClass = PseudoClass.getPseudoClass((String)"disabled");
    StyleableObjectProperty<Side> side = CSS.createSideProperty(this, Side.BOTTOM, new Runnable[0]);
    private final ObservableList<LegendItem> items = FXCollections.observableArrayList();
    private final ArrayList<LegendItem> tmpItems = new ArrayList();
    private static final CssPropertyFactory<DefaultLegend> CSS = new CssPropertyFactory(FlowPane.getClassCssMetaData());

    public DefaultLegend() {
        StyleUtil.addStyles(this, "chart-legend");
        this.items.addListener(change -> this.getChildren().setAll(this.items));
        PropUtil.runOnChange(() -> ((DefaultLegend)this).applyCss(), new ObservableValue[]{this.sideProperty()});
    }

    protected double computePrefHeight(double d2) {
        return this.getItems().isEmpty() ? 0.0 : super.computePrefHeight(d2);
    }

    protected double computePrefWidth(double d2) {
        return this.getItems().isEmpty() ? 0.0 : super.computePrefWidth(d2);
    }

    public final ObservableList<LegendItem> getItems() {
        return this.items;
    }

    public final void setItems(List<LegendItem> list) {
        this.items.setAll(list);
    }

    public LegendItem getNewLegendItem(DataSetNode dataSetNode) {
        LegendItem legendItem = new LegendItem(dataSetNode);
        legendItem.setOnMouseClicked(mouseEvent -> dataSetNode.setVisible(!dataSetNode.isVisible()));
        PropUtil.initAndRunOnChange(() -> legendItem.pseudoClassStateChanged(disabledClass, !dataSetNode.isVisible()), new ObservableValue[]{dataSetNode.visibleProperty()});
        legendItem.visibleProperty().bind((ObservableValue)dataSetNode.getRenderer().showInLegendProperty().and((ObservableBooleanValue)dataSetNode.showInLegendProperty()));
        legendItem.managedProperty().bind((ObservableValue)legendItem.visibleProperty());
        return legendItem;
    }

    @Override
    public Node getNode() {
        return this;
    }

    @Override
    public final boolean isVertical() {
        return this.getOrientation() == Orientation.VERTICAL;
    }

    @Override
    public final void setVertical(boolean bl2) {
        this.setOrientation(bl2 ? Orientation.VERTICAL : Orientation.HORIZONTAL);
    }

    @Override
    public void updateLegend(List<Renderer> list, boolean bl2) {
        if (bl2) {
            this.getItems().clear();
        }
        this.tmpItems.clear();
        for (Renderer renderer : list) {
            for (DataSetNode dataSetNode : renderer.getDatasetNodes()) {
                LegendItem legendItem = null;
                for (LegendItem legendItem2 : this.getItems()) {
                    if (legendItem2.getSeries() != dataSetNode) continue;
                    legendItem = legendItem2;
                    break;
                }
                if (legendItem == null) {
                    legendItem = this.getNewLegendItem(dataSetNode);
                }
                this.tmpItems.add(legendItem);
            }
        }
        this.getItems().setAll(this.tmpItems);
    }

    @Override
    public void drawLegend() {
        for (LegendItem legendItem : this.items) {
            if (!legendItem.isVisible()) continue;
            legendItem.drawLegendSymbol();
        }
    }

    @Override
    public Side getSide() {
        return (Side)((Object)this.side.get());
    }

    public StyleableObjectProperty<Side> sideProperty() {
        return this.side;
    }

    @Override
    public void setSide(Side side) {
        this.side.set((Object)side);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return DefaultLegend.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return CSS.getCssMetaData();
    }

    public static class LegendItem
    extends Label {
        final Canvas symbol = new Canvas();
        final StyleableDoubleProperty symbolWidth = CSS.createDoubleProperty(this, "symbolWidth", 20.0, new Runnable[0]);
        final StyleableDoubleProperty symbolHeight = CSS.createDoubleProperty(this, "symbolHeight", 20.0, new Runnable[0]);
        final DataSetNode series;
        private static final CssPropertyFactory<LegendItem> CSS = new CssPropertyFactory(Label.getClassCssMetaData());

        public LegendItem(DataSetNode dataSetNode) {
            StyleUtil.addStyles(this, "chart-legend-item");
            this.textProperty().bind((ObservableValue)dataSetNode.nameProperty());
            this.setGraphic((Node)this.symbol);
            this.symbol.managedProperty().bind((ObservableValue)this.symbol.visibleProperty());
            this.symbol.widthProperty().bind((ObservableValue)this.symbolWidth);
            this.symbol.heightProperty().bind((ObservableValue)this.symbolHeight);
            this.series = dataSetNode;
        }

        public DataSetNode getSeries() {
            return this.series;
        }

        public void drawLegendSymbol() {
            if (this.symbol.isVisible()) {
                this.symbol.getGraphicsContext2D().clearRect(0.0, 0.0, this.symbol.getWidth(), this.symbol.getWidth());
            }
            this.symbol.setVisible(this.series.getRenderer().drawLegendSymbol(this.series, this.symbol));
        }

        public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
            return CSS.getCssMetaData();
        }
    }
}

