/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.media.UdpTransportPoller;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import org.agrona.BufferUtil;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.UnsafeBuffer;

public final class ControlTransportPoller
extends UdpTransportPoller {
    private final ByteBuffer byteBuffer = BufferUtil.allocateDirectAligned(65504, 64);
    private final UnsafeBuffer unsafeBuffer = new UnsafeBuffer(this.byteBuffer);
    private final NakFlyweight nakMessage = new NakFlyweight(this.unsafeBuffer);
    private final StatusMessageFlyweight statusMessage = new StatusMessageFlyweight(this.unsafeBuffer);
    private final RttMeasurementFlyweight rttMeasurement = new RttMeasurementFlyweight(this.unsafeBuffer);
    private SendChannelEndpoint[] transports = new SendChannelEndpoint[0];

    public ControlTransportPoller(ErrorHandler errorHandler) {
        super(errorHandler);
    }

    @Override
    public void close() {
        CloseHelper.closeAll(this.errorHandler, (AutoCloseable[])this.transports);
        super.close();
    }

    @Override
    public int pollTransports() {
        int n2 = 0;
        try {
            if (this.transports.length <= ITERATION_THRESHOLD) {
                for (SendChannelEndpoint sendChannelEndpoint : this.transports) {
                    n2 += this.poll(sendChannelEndpoint);
                }
            } else {
                this.selector.selectNow();
                SelectionKey[] selectionKeyArray = this.selectedKeySet.keys();
                int n3 = this.selectedKeySet.size();
                for (int i2 = 0; i2 < n3; ++i2) {
                    n2 += this.poll((SendChannelEndpoint)selectionKeyArray[i2].attachment());
                }
                this.selectedKeySet.reset();
            }
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
        return n2;
    }

    @Override
    public SelectionKey registerForRead(UdpChannelTransport udpChannelTransport) {
        return this.registerChannelForRead((SendChannelEndpoint)udpChannelTransport);
    }

    private SelectionKey registerChannelForRead(SendChannelEndpoint sendChannelEndpoint) {
        SelectionKey selectionKey = null;
        try {
            selectionKey = sendChannelEndpoint.receiveDatagramChannel().register(this.selector, 1, sendChannelEndpoint);
            this.transports = ArrayUtil.add(this.transports, sendChannelEndpoint);
        }
        catch (ClosedChannelException closedChannelException) {
            LangUtil.rethrowUnchecked(closedChannelException);
        }
        return selectionKey;
    }

    @Override
    public void cancelRead(UdpChannelTransport udpChannelTransport) {
        this.transports = ArrayUtil.remove(this.transports, (SendChannelEndpoint)udpChannelTransport);
    }

    public void checkForReResolutions(long l2, DriverConductorProxy driverConductorProxy) {
        for (SendChannelEndpoint sendChannelEndpoint : this.transports) {
            sendChannelEndpoint.checkForReResolution(l2, driverConductorProxy);
        }
    }

    public String toString() {
        return "ControlTransportPoller{}";
    }

    private int poll(SendChannelEndpoint sendChannelEndpoint) {
        int n2 = 0;
        InetSocketAddress inetSocketAddress = sendChannelEndpoint.receive(this.byteBuffer);
        if (null != inetSocketAddress && sendChannelEndpoint.isValidFrame(this.unsafeBuffer, n2 = this.byteBuffer.position())) {
            sendChannelEndpoint.receiveHook(this.unsafeBuffer, n2, inetSocketAddress);
            int n3 = FrameDescriptor.frameType(this.unsafeBuffer, 0);
            if (2 == n3) {
                sendChannelEndpoint.onNakMessage(this.nakMessage, this.unsafeBuffer, n2, inetSocketAddress);
            } else if (3 == n3) {
                sendChannelEndpoint.onStatusMessage(this.statusMessage, this.unsafeBuffer, n2, inetSocketAddress);
            } else if (6 == n3) {
                sendChannelEndpoint.onRttMeasurement(this.rttMeasurement, this.unsafeBuffer, n2, inetSocketAddress);
            }
        }
        return n2;
    }
}

