/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FeedbackDelayGenerator;
import io.aeron.driver.LossHandler;
import io.aeron.logbuffer.TermGapScanner;
import org.agrona.concurrent.UnsafeBuffer;

public class LossDetector
implements TermGapScanner.GapHandler {
    private long deadlineNs = -1L;
    private int scannedTermId;
    private int scannedTermOffset = -1;
    private int scannedLength;
    private int activeTermId;
    private int activeTermOffset = -1;
    private int activeLength;
    private final FeedbackDelayGenerator delayGenerator;
    private final LossHandler lossHandler;

    public LossDetector(FeedbackDelayGenerator feedbackDelayGenerator, LossHandler lossHandler) {
        this.delayGenerator = feedbackDelayGenerator;
        this.lossHandler = lossHandler;
    }

    public long scan(UnsafeBuffer unsafeBuffer, long l2, long l3, long l4, int n2, int n3, int n4) {
        boolean bl2 = false;
        int n5 = (int)l2 & n2;
        if (l2 < l3) {
            int n6 = (int)(l2 >>> n3);
            int n7 = (int)(l3 >>> n3);
            int n8 = n4 + n6;
            int n9 = (int)l3 & n2;
            int n10 = n6 == n7 ? n9 : n2 + 1;
            if ((n5 = TermGapScanner.scanForGap(unsafeBuffer, n8, n5, n10, this)) < n10) {
                if (this.scannedTermOffset != this.activeTermOffset || this.scannedTermId != this.activeTermId) {
                    this.activateGap(l4);
                    bl2 = true;
                }
                this.checkTimerExpiry(l4);
            }
        }
        return LossDetector.pack(n5, bl2);
    }

    @Override
    public void onGap(int n2, int n3, int n4) {
        this.scannedTermId = n2;
        this.scannedTermOffset = n3;
        this.scannedLength = n4;
    }

    public static long pack(int n2, boolean bl2) {
        return (long)n2 << 32 | (long)(bl2 ? 1 : 0);
    }

    public static boolean lossFound(long l2) {
        return (int)l2 != 0;
    }

    public static int rebuildOffset(long l2) {
        return (int)(l2 >>> 32);
    }

    private void activateGap(long l2) {
        this.activeTermId = this.scannedTermId;
        this.activeTermOffset = this.scannedTermOffset;
        this.activeLength = this.scannedLength;
        this.deadlineNs = this.delayGenerator.shouldFeedbackImmediately() ? l2 : l2 + this.delayGenerator.generateDelay();
    }

    private void checkTimerExpiry(long l2) {
        if (this.deadlineNs - l2 <= 0L) {
            this.lossHandler.onGapDetected(this.activeTermId, this.activeTermOffset, this.activeLength);
            this.deadlineNs = l2 + this.delayGenerator.generateDelay();
        }
    }
}

