/*
 * Decompiled with CFR 0.152.
 */
package de.jensd.fx.glyphs;

import de.jensd.fx.glyphs.GlyphIcons;
import java.io.InputStream;
import java.lang.reflect.Field;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.TreeItem;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class GlyphsFactory {
    public GlyphsFactory(Class clazz) {
        this.loadFont(this.getPathToFontFromClass(clazz));
    }

    public GlyphsFactory(String string) {
        this.loadFont(string);
    }

    private String getPathToFontFromClass(Class clazz) {
        String string = "";
        try {
            Field field = clazz.getField("TTF_PATH");
            string = (String)field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
        return string;
    }

    private final void loadFont(String string) {
        try {
            Font.loadFont((InputStream)this.getClass().getResource(string).openStream(), (double)10.0);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Text createIcon(GlyphIcons glyphIcons) {
        return this.createIcon(glyphIcons, "1em");
    }

    public Text createIcon(GlyphIcons glyphIcons, String string) {
        Text text = new Text(glyphIcons.unicode());
        text.getStyleClass().add((Object)"glyph-icon");
        text.setStyle(String.format("-fx-font-family: %s; -fx-font-size: %s;", glyphIcons.fontFamily(), string));
        return text;
    }

    public Label createIconLabel(GlyphIcons glyphIcons, String string, String string2, String string3, ContentDisplay contentDisplay) {
        Text text = this.createIcon(glyphIcons, string2);
        Label label = new Label(string);
        label.setStyle("-fx-font-size: " + string3);
        label.setGraphic((Node)text);
        label.setContentDisplay(contentDisplay);
        return label;
    }

    public Button createIconButton(GlyphIcons glyphIcons) {
        return this.createIconButton(glyphIcons, "");
    }

    public Button createIconButton(GlyphIcons glyphIcons, String string) {
        Text text = this.createIcon(glyphIcons, "1em");
        Button button = new Button(string);
        button.setGraphic((Node)text);
        return button;
    }

    public Button createIconButton(GlyphIcons glyphIcons, String string, String string2, String string3, ContentDisplay contentDisplay) {
        Text text = this.createIcon(glyphIcons, string2);
        Button button = new Button(string);
        button.setStyle("-fx-font-size: " + string3);
        button.setGraphic((Node)text);
        button.setContentDisplay(contentDisplay);
        return button;
    }

    public ToggleButton createIconToggleButton(GlyphIcons glyphIcons) {
        return this.createIconToggleButton(glyphIcons, "");
    }

    public ToggleButton createIconToggleButton(GlyphIcons glyphIcons, String string) {
        return this.createIconToggleButton(glyphIcons, string, "1em");
    }

    public ToggleButton createIconToggleButton(GlyphIcons glyphIcons, String string, String string2) {
        Text text = this.createIcon(glyphIcons, string2);
        ToggleButton toggleButton = new ToggleButton(string);
        toggleButton.setGraphic((Node)text);
        return toggleButton;
    }

    public ToggleButton createIconToggleButton(GlyphIcons glyphIcons, String string, String string2, ContentDisplay contentDisplay) {
        return this.createIconToggleButton(glyphIcons, string, string2, "1em", contentDisplay);
    }

    public ToggleButton createIconToggleButton(GlyphIcons glyphIcons, String string, String string2, String string3, ContentDisplay contentDisplay) {
        Text text = this.createIcon(glyphIcons, string2);
        ToggleButton toggleButton = new ToggleButton(string);
        toggleButton.setStyle("-fx-font-size: " + string3);
        toggleButton.setGraphic((Node)text);
        toggleButton.setContentDisplay(contentDisplay);
        return toggleButton;
    }

    public void setIcon(Tab tab, GlyphIcons glyphIcons) {
        this.setIcon(tab, glyphIcons, "1em");
    }

    public void setIcon(Tab tab, GlyphIcons glyphIcons, String string) {
        tab.setGraphic((Node)this.createIcon(glyphIcons, string));
    }

    public void setIcon(Labeled labeled, GlyphIcons glyphIcons) {
        this.setIcon(labeled, glyphIcons, "1em");
    }

    public void setIcon(Labeled labeled, GlyphIcons glyphIcons, ContentDisplay contentDisplay) {
        this.setIcon(labeled, glyphIcons, "1em", contentDisplay);
    }

    public void setIcon(Labeled labeled, GlyphIcons glyphIcons, String string) {
        this.setIcon(labeled, glyphIcons, string, ContentDisplay.LEFT);
    }

    public void setIcon(Labeled labeled, GlyphIcons glyphIcons, String string, ContentDisplay contentDisplay) {
        if (labeled == null) {
            throw new IllegalArgumentException("The component must not be 'null'!");
        }
        labeled.setGraphic((Node)this.createIcon(glyphIcons, string));
        labeled.setContentDisplay(contentDisplay);
    }

    public void setIcon(MenuItem menuItem, GlyphIcons glyphIcons) {
        this.setIcon(menuItem, glyphIcons, "1em", "1em");
    }

    public void setIcon(MenuItem menuItem, GlyphIcons glyphIcons, String string) {
        this.setIcon(menuItem, glyphIcons, "1em", string);
    }

    public void setIcon(MenuItem menuItem, GlyphIcons glyphIcons, String string, String string2) {
        if (menuItem == null) {
            throw new IllegalArgumentException("The menu item must not be 'null'!");
        }
        Text text = this.createIcon(glyphIcons, string2);
        menuItem.setStyle("-fx-font-size: " + string);
        menuItem.setGraphic((Node)text);
    }

    public void setIcon(TreeItem treeItem, GlyphIcons glyphIcons) {
        this.setIcon(treeItem, glyphIcons, "1em");
    }

    public void setIcon(TreeItem treeItem, GlyphIcons glyphIcons, String string) {
        if (treeItem == null) {
            throw new IllegalArgumentException("The tree item must not be 'null'!");
        }
        Text text = this.createIcon(glyphIcons, string);
        treeItem.setGraphic((Node)text);
    }
}

