/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.unmarshaller;

import com.sun.xml.bind.WhiteSpaceProcessor;
import com.sun.xml.bind.v2.runtime.unmarshaller.Base64Data;
import com.sun.xml.bind.v2.runtime.unmarshaller.StAXConnector;
import com.sun.xml.bind.v2.runtime.unmarshaller.XmlVisitor;
import com.sun.xml.fastinfoset.stax.StAXDocumentParser;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

final class FastInfosetConnector
extends StAXConnector {
    private final StAXDocumentParser fastInfosetStreamReader;
    private boolean textReported;
    private final Base64Data base64Data = new Base64Data();
    private final StringBuilder buffer = new StringBuilder();
    private final CharSequenceImpl charArray = new CharSequenceImpl();

    public FastInfosetConnector(StAXDocumentParser stAXDocumentParser, XmlVisitor xmlVisitor) {
        super(xmlVisitor);
        stAXDocumentParser.setStringInterning(true);
        this.fastInfosetStreamReader = stAXDocumentParser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void bridge() throws XMLStreamException {
        try {
            int n2 = 0;
            int n3 = this.fastInfosetStreamReader.getEventType();
            if (n3 == 7) {
                while (!this.fastInfosetStreamReader.isStartElement()) {
                    n3 = this.fastInfosetStreamReader.next();
                }
            }
            if (n3 != 1) {
                throw new IllegalStateException("The current event is not START_ELEMENT\n but " + n3);
            }
            this.handleStartDocument(this.fastInfosetStreamReader.getNamespaceContext());
            block8: while (true) {
                switch (n3) {
                    case 1: {
                        this.handleStartElement();
                        ++n2;
                        break;
                    }
                    case 2: {
                        this.handleEndElement();
                        if (--n2 != 0) break;
                        break block8;
                    }
                    case 4: 
                    case 6: 
                    case 12: {
                        if (!this.predictor.expectText()) break;
                        n3 = this.fastInfosetStreamReader.peekNext();
                        if (n3 == 2) {
                            this.processNonIgnorableText();
                            break;
                        }
                        if (n3 == 1) {
                            this.processIgnorableText();
                            break;
                        }
                        this.handleFragmentedCharacters();
                    }
                }
                n3 = this.fastInfosetStreamReader.next();
            }
            this.fastInfosetStreamReader.next();
            this.handleEndDocument();
            return;
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException(sAXException);
        }
    }

    @Override
    protected Location getCurrentLocation() {
        return this.fastInfosetStreamReader.getLocation();
    }

    @Override
    protected String getCurrentQName() {
        return this.fastInfosetStreamReader.getNameString();
    }

    private void handleStartElement() throws SAXException {
        this.processUnreportedText();
        for (int i2 = 0; i2 < this.fastInfosetStreamReader.accessNamespaceCount(); ++i2) {
            this.visitor.startPrefixMapping(this.fastInfosetStreamReader.getNamespacePrefix(i2), this.fastInfosetStreamReader.getNamespaceURI(i2));
        }
        this.tagName.uri = this.fastInfosetStreamReader.accessNamespaceURI();
        this.tagName.local = this.fastInfosetStreamReader.accessLocalName();
        this.tagName.atts = this.fastInfosetStreamReader.getAttributesHolder();
        this.visitor.startElement(this.tagName);
    }

    private void handleFragmentedCharacters() throws XMLStreamException, SAXException {
        this.buffer.setLength(0);
        this.buffer.append(this.fastInfosetStreamReader.getTextCharacters(), this.fastInfosetStreamReader.getTextStart(), this.fastInfosetStreamReader.getTextLength());
        block5: while (true) {
            switch (this.fastInfosetStreamReader.peekNext()) {
                case 1: {
                    this.processBufferedText(true);
                    return;
                }
                case 2: {
                    this.processBufferedText(false);
                    return;
                }
                case 4: 
                case 6: 
                case 12: {
                    this.fastInfosetStreamReader.next();
                    this.buffer.append(this.fastInfosetStreamReader.getTextCharacters(), this.fastInfosetStreamReader.getTextStart(), this.fastInfosetStreamReader.getTextLength());
                    continue block5;
                }
            }
            this.fastInfosetStreamReader.next();
        }
    }

    private void handleEndElement() throws SAXException {
        this.processUnreportedText();
        this.tagName.uri = this.fastInfosetStreamReader.accessNamespaceURI();
        this.tagName.local = this.fastInfosetStreamReader.accessLocalName();
        this.visitor.endElement(this.tagName);
        for (int i2 = this.fastInfosetStreamReader.accessNamespaceCount() - 1; i2 >= 0; --i2) {
            this.visitor.endPrefixMapping(this.fastInfosetStreamReader.getNamespacePrefix(i2));
        }
    }

    private void processNonIgnorableText() throws SAXException {
        boolean bl2;
        this.textReported = true;
        boolean bl3 = bl2 = this.fastInfosetStreamReader.getTextAlgorithmBytes() != null;
        if (bl2 && this.fastInfosetStreamReader.getTextAlgorithmIndex() == 1) {
            this.base64Data.set(this.fastInfosetStreamReader.getTextAlgorithmBytesClone(), null);
            this.visitor.text(this.base64Data);
        } else {
            if (bl2) {
                this.fastInfosetStreamReader.getText();
            }
            this.charArray.set();
            this.visitor.text(this.charArray);
        }
    }

    private void processIgnorableText() throws SAXException {
        boolean bl2;
        boolean bl3 = bl2 = this.fastInfosetStreamReader.getTextAlgorithmBytes() != null;
        if (bl2 && this.fastInfosetStreamReader.getTextAlgorithmIndex() == 1) {
            this.base64Data.set(this.fastInfosetStreamReader.getTextAlgorithmBytesClone(), null);
            this.visitor.text(this.base64Data);
            this.textReported = true;
        } else {
            if (bl2) {
                this.fastInfosetStreamReader.getText();
            }
            this.charArray.set();
            if (!WhiteSpaceProcessor.isWhiteSpace(this.charArray)) {
                this.visitor.text(this.charArray);
                this.textReported = true;
            }
        }
    }

    private void processBufferedText(boolean bl2) throws SAXException {
        if (!bl2 || !WhiteSpaceProcessor.isWhiteSpace(this.buffer)) {
            this.visitor.text(this.buffer);
            this.textReported = true;
        }
    }

    private void processUnreportedText() throws SAXException {
        if (!this.textReported && this.predictor.expectText()) {
            this.visitor.text("");
        }
        this.textReported = false;
    }

    private final class CharSequenceImpl
    implements CharSequence {
        char[] ch;
        int start;
        int length;

        CharSequenceImpl() {
        }

        CharSequenceImpl(char[] cArray, int n2, int n3) {
            this.ch = cArray;
            this.start = n2;
            this.length = n3;
        }

        public void set() {
            this.ch = FastInfosetConnector.this.fastInfosetStreamReader.getTextCharacters();
            this.start = FastInfosetConnector.this.fastInfosetStreamReader.getTextStart();
            this.length = FastInfosetConnector.this.fastInfosetStreamReader.getTextLength();
        }

        @Override
        public final int length() {
            return this.length;
        }

        @Override
        public final char charAt(int n2) {
            return this.ch[this.start + n2];
        }

        @Override
        public final CharSequence subSequence(int n2, int n3) {
            return new CharSequenceImpl(this.ch, this.start + n2, n3 - n2);
        }

        @Override
        public String toString() {
            return new String(this.ch, this.start, this.length);
        }
    }
}

