/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.unmarshaller;

import com.sun.xml.bind.unmarshaller.InfosetScanner;
import com.sun.xml.bind.v2.runtime.unmarshaller.LocatorEx;
import java.util.Enumeration;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class DOMScanner
implements LocatorEx,
InfosetScanner {
    private Node currentNode = null;
    private final AttributesImpl atts = new AttributesImpl();
    private ContentHandler receiver = null;
    private Locator locator = this;

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    public void scan(Object object) throws SAXException {
        if (object instanceof Document) {
            this.scan((Document)object);
        } else {
            this.scan((Element)object);
        }
    }

    public void scan(Document document) throws SAXException {
        this.scan(document.getDocumentElement());
    }

    public void scan(Element element) throws SAXException {
        String string;
        this.setCurrentLocation(element);
        this.receiver.setDocumentLocator(this.locator);
        this.receiver.startDocument();
        NamespaceSupport namespaceSupport = new NamespaceSupport();
        this.buildNamespaceSupport(namespaceSupport, element.getParentNode());
        Enumeration<String> enumeration = namespaceSupport.getPrefixes();
        while (enumeration.hasMoreElements()) {
            string = enumeration.nextElement();
            this.receiver.startPrefixMapping(string, namespaceSupport.getURI(string));
        }
        this.visit(element);
        enumeration = namespaceSupport.getPrefixes();
        while (enumeration.hasMoreElements()) {
            string = enumeration.nextElement();
            this.receiver.endPrefixMapping(string);
        }
        this.setCurrentLocation(element);
        this.receiver.endDocument();
    }

    public void parse(Element element, ContentHandler contentHandler) throws SAXException {
        this.receiver = contentHandler;
        this.setCurrentLocation(element);
        this.receiver.startDocument();
        this.receiver.setDocumentLocator(this.locator);
        this.visit(element);
        this.setCurrentLocation(element);
        this.receiver.endDocument();
    }

    public void parseWithContext(Element element, ContentHandler contentHandler) throws SAXException {
        this.setContentHandler(contentHandler);
        this.scan(element);
    }

    private void buildNamespaceSupport(NamespaceSupport namespaceSupport, Node node) {
        if (node == null || node.getNodeType() != 1) {
            return;
        }
        this.buildNamespaceSupport(namespaceSupport, node.getParentNode());
        namespaceSupport.pushContext();
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
            Attr attr = (Attr)namedNodeMap.item(i2);
            if ("xmlns".equals(attr.getPrefix())) {
                namespaceSupport.declarePrefix(attr.getLocalName(), attr.getValue());
                continue;
            }
            if (!"xmlns".equals(attr.getName())) continue;
            namespaceSupport.declarePrefix("", attr.getValue());
        }
    }

    public void visit(Element element) throws SAXException {
        int n2;
        Object object;
        String string;
        Object object2;
        this.setCurrentLocation(element);
        NamedNodeMap namedNodeMap = element.getAttributes();
        this.atts.clear();
        int n3 = namedNodeMap == null ? 0 : namedNodeMap.getLength();
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            String string2;
            object2 = (Attr)namedNodeMap.item(i2);
            string = object2.getName();
            if (string.startsWith("xmlns")) {
                if (string.length() == 5) {
                    this.receiver.startPrefixMapping("", object2.getValue());
                    continue;
                }
                object = object2.getLocalName();
                if (object == null) {
                    object = string.substring(6);
                }
                this.receiver.startPrefixMapping((String)object, object2.getValue());
                continue;
            }
            object = object2.getNamespaceURI();
            if (object == null) {
                object = "";
            }
            if ((string2 = object2.getLocalName()) == null) {
                string2 = object2.getName();
            }
            this.atts.addAttribute((String)object, string2, object2.getName(), "CDATA", object2.getValue());
        }
        String string3 = element.getNamespaceURI();
        if (string3 == null) {
            string3 = "";
        }
        object2 = element.getLocalName();
        string = element.getTagName();
        if (object2 == null) {
            object2 = string;
        }
        this.receiver.startElement(string3, (String)object2, string, this.atts);
        object = element.getChildNodes();
        int n4 = object.getLength();
        for (n2 = 0; n2 < n4; ++n2) {
            this.visit(object.item(n2));
        }
        this.setCurrentLocation(element);
        this.receiver.endElement(string3, (String)object2, string);
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            Attr attr = (Attr)namedNodeMap.item(n2);
            String string4 = attr.getName();
            if (!string4.startsWith("xmlns")) continue;
            if (string4.length() == 5) {
                this.receiver.endPrefixMapping("");
                continue;
            }
            this.receiver.endPrefixMapping(attr.getLocalName());
        }
    }

    private void visit(Node node) throws SAXException {
        this.setCurrentLocation(node);
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                String string = node.getNodeValue();
                this.receiver.characters(string.toCharArray(), 0, string.length());
                break;
            }
            case 1: {
                this.visit((Element)node);
                break;
            }
            case 5: {
                this.receiver.skippedEntity(node.getNodeName());
                break;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                this.receiver.processingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
            }
        }
    }

    private void setCurrentLocation(Node node) {
        this.currentNode = node;
    }

    public Node getCurrentLocation() {
        return this.currentNode;
    }

    public Object getCurrentElement() {
        return this.currentNode;
    }

    @Override
    public LocatorEx getLocator() {
        return this;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.receiver = contentHandler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.receiver;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return null;
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public ValidationEventLocator getLocation() {
        return new ValidationEventLocatorImpl(this.getCurrentLocation());
    }
}

