/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.bindings;

import com.jfoenix.bindings.base.IBiBinder;
import com.jfoenix.bindings.base.IPropertyConverter;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.function.Consumer;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.util.Callback;

public class CustomBidirectionalBinding<A, B>
implements IBiBinder {
    private final WeakReference<ReadOnlyProperty<A>> propertyRef1;
    private final WeakReference<ReadOnlyProperty<B>> propertyRef2;
    private final Consumer<A> propertyRef1Setter;
    private final Consumer<B> propertyRef2Setter;
    private HashMap<ReadOnlyProperty<?>, ChangeListener> listeners = new HashMap();
    private IPropertyConverter<A, B> converter;

    public CustomBidirectionalBinding(Property<A> property, Property<B> property2, IPropertyConverter<A, B> iPropertyConverter) {
        this((ReadOnlyProperty<Object>)property, object -> property.setValue(object), (ReadOnlyProperty<Object>)property2, object -> property2.setValue(object), (IPropertyConverter<Object, Object>)iPropertyConverter);
    }

    public CustomBidirectionalBinding(ReadOnlyProperty<A> readOnlyProperty, Consumer<A> consumer, ReadOnlyProperty<B> readOnlyProperty2, Consumer<B> consumer2, IPropertyConverter<A, B> iPropertyConverter) {
        this.propertyRef1 = new WeakReference<ReadOnlyProperty<A>>(readOnlyProperty);
        this.propertyRef2 = new WeakReference<ReadOnlyProperty<B>>(readOnlyProperty2);
        this.propertyRef1Setter = consumer;
        this.propertyRef2Setter = consumer2;
        this.converter = iPropertyConverter;
    }

    @Override
    public void unbindBi() {
        this.listeners.entrySet().forEach(entry -> ((ReadOnlyProperty)entry.getKey()).removeListener((ChangeListener)entry.getValue()));
    }

    @Override
    public void bindBi() {
        this.addFlaggedChangeListener((ReadOnlyProperty)this.propertyRef1.get(), this.propertyRef1Setter, (ReadOnlyProperty)this.propertyRef2.get(), this.propertyRef2Setter, object -> this.converter.to(object));
        this.addFlaggedChangeListener((ReadOnlyProperty)this.propertyRef2.get(), this.propertyRef2Setter, (ReadOnlyProperty)this.propertyRef1.get(), this.propertyRef1Setter, object -> this.converter.from(object));
        this.propertyRef2Setter.accept(this.converter.to(((ReadOnlyProperty)this.propertyRef1.get()).getValue()));
    }

    private <a, b> void addFlaggedChangeListener(ReadOnlyProperty<a> readOnlyProperty, Consumer<a> consumer, ReadOnlyProperty<b> readOnlyProperty2, final Consumer<b> consumer2, final Callback<a, b> callback) {
        ChangeListener changeListener = new ChangeListener<a>(){
            private boolean alreadyCalled = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void changed(ObservableValue<? extends a> observableValue, a a2, a a3) {
                if (this.alreadyCalled) {
                    return;
                }
                try {
                    this.alreadyCalled = true;
                    consumer2.accept(callback.call(a3));
                }
                finally {
                    this.alreadyCalled = false;
                }
            }
        };
        this.listeners.put(readOnlyProperty, changeListener);
        readOnlyProperty.addListener(changeListener);
    }
}

