/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.services;

import com.github.scribejava.core.exceptions.OAuthSignatureException;
import com.github.scribejava.core.services.SignatureService;
import com.github.scribejava.core.utils.OAuthEncoder;
import com.github.scribejava.core.utils.Preconditions;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HMACSha1SignatureService
implements SignatureService {
    private static final String EMPTY_STRING = "";
    private static final String CARRIAGE_RETURN = "\r\n";
    private static final String UTF8 = "UTF-8";
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final String METHOD = "HMAC-SHA1";

    @Override
    public String getSignature(String string, String string2, String string3) {
        try {
            Preconditions.checkEmptyString(string, "Base string cant be null or empty string");
            Preconditions.checkEmptyString(string2, "Api secret cant be null or empty string");
            return this.doSign(string, OAuthEncoder.encode(string2) + '&' + OAuthEncoder.encode(string3));
        }
        catch (UnsupportedEncodingException | RuntimeException | InvalidKeyException | NoSuchAlgorithmException exception) {
            throw new OAuthSignatureException(string, exception);
        }
    }

    private String doSign(String string, String string2) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(string2.getBytes(UTF8), HMAC_SHA1);
        Mac mac = Mac.getInstance(HMAC_SHA1);
        mac.init(secretKeySpec);
        byte[] byArray = mac.doFinal(string.getBytes(UTF8));
        return BASE_64_ENCODER.encodeToString(byArray).replace(CARRIAGE_RETURN, EMPTY_STRING);
    }

    @Override
    public String getSignatureMethod() {
        return METHOD;
    }
}

