/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.builder.api.OAuth1SignatureType;
import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuth1RequestToken;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.oauth.OAuthService;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class OAuth10aService
extends OAuthService {
    private static final String VERSION = "1.0";
    private final DefaultApi10a api;

    public OAuth10aService(DefaultApi10a defaultApi10a, OAuthConfig oAuthConfig) {
        super(oAuthConfig);
        this.api = defaultApi10a;
    }

    public OAuth1RequestToken getRequestToken() throws IOException, InterruptedException, ExecutionException {
        OAuthConfig oAuthConfig = this.getConfig();
        oAuthConfig.log("obtaining request token from " + this.api.getRequestTokenEndpoint());
        OAuthRequest oAuthRequest = this.prepareRequestTokenRequest();
        oAuthConfig.log("sending request...");
        Response response = this.execute(oAuthRequest);
        String string = response.getBody();
        oAuthConfig.log("response status code: " + response.getCode());
        oAuthConfig.log("response body: " + string);
        return this.api.getRequestTokenExtractor().extract(response);
    }

    public Future<OAuth1RequestToken> getRequestTokenAsync() {
        return this.getRequestTokenAsync(null);
    }

    public Future<OAuth1RequestToken> getRequestTokenAsync(OAuthAsyncRequestCallback<OAuth1RequestToken> oAuthAsyncRequestCallback) {
        OAuthConfig oAuthConfig = this.getConfig();
        oAuthConfig.log("async obtaining request token from " + this.api.getRequestTokenEndpoint());
        OAuthRequest oAuthRequest = this.prepareRequestTokenRequest();
        return this.execute(oAuthRequest, oAuthAsyncRequestCallback, new OAuthRequest.ResponseConverter<OAuth1RequestToken>(){

            @Override
            public OAuth1RequestToken convert(Response response) throws IOException {
                return OAuth10aService.this.getApi().getRequestTokenExtractor().extract(response);
            }
        });
    }

    protected OAuthRequest prepareRequestTokenRequest() {
        OAuthRequest oAuthRequest = new OAuthRequest(this.api.getRequestTokenVerb(), this.api.getRequestTokenEndpoint());
        OAuthConfig oAuthConfig = this.getConfig();
        oAuthConfig.log("setting oauth_callback to " + oAuthConfig.getCallback());
        oAuthRequest.addOAuthParameter("oauth_callback", oAuthConfig.getCallback());
        this.addOAuthParams(oAuthRequest, "");
        this.appendSignature(oAuthRequest);
        return oAuthRequest;
    }

    protected void addOAuthParams(OAuthRequest oAuthRequest, String string) {
        OAuthConfig oAuthConfig = this.getConfig();
        oAuthRequest.addOAuthParameter("oauth_timestamp", this.api.getTimestampService().getTimestampInSeconds());
        oAuthRequest.addOAuthParameter("oauth_nonce", this.api.getTimestampService().getNonce());
        oAuthRequest.addOAuthParameter("oauth_consumer_key", oAuthConfig.getApiKey());
        oAuthRequest.addOAuthParameter("oauth_signature_method", this.api.getSignatureService().getSignatureMethod());
        oAuthRequest.addOAuthParameter("oauth_version", this.getVersion());
        String string2 = oAuthConfig.getScope();
        if (string2 != null) {
            oAuthRequest.addOAuthParameter("scope", string2);
        }
        oAuthRequest.addOAuthParameter("oauth_signature", this.getSignature(oAuthRequest, string));
        oAuthConfig.log("appended additional OAuth parameters: " + oAuthRequest.getOauthParameters());
    }

    public OAuth1AccessToken getAccessToken(OAuth1RequestToken oAuth1RequestToken, String string) throws IOException, InterruptedException, ExecutionException {
        this.getConfig().log("obtaining access token from " + this.api.getAccessTokenEndpoint());
        OAuthRequest oAuthRequest = this.prepareAccessTokenRequest(oAuth1RequestToken, string);
        Response response = this.execute(oAuthRequest);
        return this.api.getAccessTokenExtractor().extract(response);
    }

    public Future<OAuth1AccessToken> getAccessTokenAsync(OAuth1RequestToken oAuth1RequestToken, String string) {
        return this.getAccessTokenAsync(oAuth1RequestToken, string, null);
    }

    public Future<OAuth1AccessToken> getAccessTokenAsync(OAuth1RequestToken oAuth1RequestToken, String string, OAuthAsyncRequestCallback<OAuth1AccessToken> oAuthAsyncRequestCallback) {
        OAuthConfig oAuthConfig = this.getConfig();
        oAuthConfig.log("async obtaining access token from " + this.api.getAccessTokenEndpoint());
        OAuthRequest oAuthRequest = this.prepareAccessTokenRequest(oAuth1RequestToken, string);
        return this.execute(oAuthRequest, oAuthAsyncRequestCallback, new OAuthRequest.ResponseConverter<OAuth1AccessToken>(){

            @Override
            public OAuth1AccessToken convert(Response response) throws IOException {
                return OAuth10aService.this.getApi().getAccessTokenExtractor().extract(response);
            }
        });
    }

    protected OAuthRequest prepareAccessTokenRequest(OAuth1RequestToken oAuth1RequestToken, String string) {
        OAuthRequest oAuthRequest = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        OAuthConfig oAuthConfig = this.getConfig();
        oAuthRequest.addOAuthParameter("oauth_token", oAuth1RequestToken.getToken());
        oAuthRequest.addOAuthParameter("oauth_verifier", string);
        oAuthConfig.log("setting token to: " + oAuth1RequestToken + " and verifier to: " + string);
        this.addOAuthParams(oAuthRequest, oAuth1RequestToken.getTokenSecret());
        this.appendSignature(oAuthRequest);
        return oAuthRequest;
    }

    public void signRequest(OAuth1AccessToken oAuth1AccessToken, OAuthRequest oAuthRequest) {
        OAuthConfig oAuthConfig = this.getConfig();
        oAuthConfig.log("signing request: " + oAuthRequest.getCompleteUrl());
        if (!oAuth1AccessToken.isEmpty() || this.api.isEmptyOAuthTokenParamIsRequired()) {
            oAuthRequest.addOAuthParameter("oauth_token", oAuth1AccessToken.getToken());
        }
        oAuthConfig.log("setting token to: " + oAuth1AccessToken);
        this.addOAuthParams(oAuthRequest, oAuth1AccessToken.getTokenSecret());
        this.appendSignature(oAuthRequest);
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    public String getAuthorizationUrl(OAuth1RequestToken oAuth1RequestToken) {
        return this.api.getAuthorizationUrl(oAuth1RequestToken);
    }

    private String getSignature(OAuthRequest oAuthRequest, String string) {
        OAuthConfig oAuthConfig = this.getConfig();
        oAuthConfig.log("generating signature...");
        String string2 = this.api.getBaseStringExtractor().extract(oAuthRequest);
        String string3 = this.api.getSignatureService().getSignature(string2, oAuthConfig.getApiSecret(), string);
        oAuthConfig.log("base string is: " + string2);
        oAuthConfig.log("signature is: " + string3);
        return string3;
    }

    protected void appendSignature(OAuthRequest oAuthRequest) {
        OAuthConfig oAuthConfig = this.getConfig();
        OAuth1SignatureType oAuth1SignatureType = this.api.getSignatureType();
        switch (oAuth1SignatureType) {
            case Header: {
                oAuthConfig.log("using Http Header signature");
                String string = this.api.getHeaderExtractor().extract(oAuthRequest);
                oAuthRequest.addHeader("Authorization", string);
                break;
            }
            case QueryString: {
                oAuthConfig.log("using Querystring signature");
                for (Map.Entry<String, String> entry : oAuthRequest.getOauthParameters().entrySet()) {
                    oAuthRequest.addQuerystringParameter(entry.getKey(), entry.getValue());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown new Signature Type '" + (Object)((Object)oAuth1SignatureType) + "'.");
            }
        }
    }

    public DefaultApi10a getApi() {
        return this.api;
    }
}

