/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.ErrorReportConfiguration;
import com.fasterxml.jackson.core.io.CharTypes;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class ContentReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final ContentReference UNKNOWN_CONTENT = new ContentReference(false, null);
    protected static final ContentReference REDACTED_CONTENT = new ContentReference(false, null);
    @Deprecated
    public static final int DEFAULT_MAX_CONTENT_SNIPPET = 500;
    protected final transient Object _rawContent;
    protected final int _offset;
    protected final int _length;
    protected final boolean _isContentTextual;
    protected final int _maxRawContentLength;

    @Deprecated
    protected ContentReference(boolean bl2, Object object) {
        this(bl2, object, -1, -1, ErrorReportConfiguration.defaults());
    }

    @Deprecated
    protected ContentReference(boolean bl2, Object object, int n2, int n3) {
        this(bl2, object, n2, n3, ErrorReportConfiguration.defaults());
    }

    protected ContentReference(boolean bl2, Object object, ErrorReportConfiguration errorReportConfiguration) {
        this(bl2, object, -1, -1, errorReportConfiguration);
    }

    protected ContentReference(boolean bl2, Object object, int n2, int n3, ErrorReportConfiguration errorReportConfiguration) {
        this._isContentTextual = bl2;
        this._rawContent = object;
        this._offset = n2;
        this._length = n3;
        this._maxRawContentLength = errorReportConfiguration.getMaxRawContentLength();
    }

    public static ContentReference unknown() {
        return UNKNOWN_CONTENT;
    }

    public static ContentReference redacted() {
        return REDACTED_CONTENT;
    }

    @Deprecated
    public static ContentReference construct(boolean bl2, Object object) {
        return new ContentReference(bl2, object, ErrorReportConfiguration.defaults());
    }

    @Deprecated
    public static ContentReference construct(boolean bl2, Object object, int n2, int n3) {
        return new ContentReference(bl2, object, n2, n3, ErrorReportConfiguration.defaults());
    }

    public static ContentReference construct(boolean bl2, Object object, int n2, int n3, ErrorReportConfiguration errorReportConfiguration) {
        return new ContentReference(bl2, object, n2, n3, errorReportConfiguration);
    }

    public static ContentReference construct(boolean bl2, Object object, ErrorReportConfiguration errorReportConfiguration) {
        return new ContentReference(bl2, object, errorReportConfiguration);
    }

    public static ContentReference rawReference(boolean bl2, Object object) {
        if (object instanceof ContentReference) {
            return (ContentReference)object;
        }
        return new ContentReference(bl2, object);
    }

    public static ContentReference rawReference(Object object) {
        return ContentReference.rawReference(false, object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    protected Object readResolve() {
        return UNKNOWN_CONTENT;
    }

    public boolean hasTextualContent() {
        return this._isContentTextual;
    }

    public Object getRawContent() {
        return this._rawContent;
    }

    public int contentOffset() {
        return this._offset;
    }

    public int contentLength() {
        return this._length;
    }

    protected int maxRawContentLength() {
        return this._maxRawContentLength;
    }

    public String buildSourceDescription() {
        return this.appendSourceDescription(new StringBuilder(200)).toString();
    }

    public StringBuilder appendSourceDescription(StringBuilder stringBuilder) {
        Object object = this.getRawContent();
        if (object == null) {
            if (this == REDACTED_CONTENT) {
                stringBuilder.append("REDACTED (`StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION` disabled)");
            } else {
                stringBuilder.append("UNKNOWN");
            }
            return stringBuilder;
        }
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        String string = clazz.getName();
        if (string.startsWith("java.")) {
            string = clazz.getSimpleName();
        } else if (object instanceof byte[]) {
            string = "byte[]";
        } else if (object instanceof char[]) {
            string = "char[]";
        }
        stringBuilder.append('(').append(string).append(')');
        if (this.hasTextualContent()) {
            String string2;
            String string3 = " chars";
            int n2 = this.maxRawContentLength();
            int[] nArray = new int[]{this.contentOffset(), this.contentLength()};
            if (object instanceof CharSequence) {
                string2 = this._truncate((CharSequence)object, nArray, n2);
            } else if (object instanceof char[]) {
                string2 = this._truncate((char[])object, nArray, n2);
            } else if (object instanceof byte[]) {
                string2 = this._truncate((byte[])object, nArray, n2);
                string3 = " bytes";
            } else {
                string2 = null;
            }
            if (string2 != null) {
                this._append(stringBuilder, string2);
                if (nArray[1] > n2) {
                    stringBuilder.append("[truncated ").append(nArray[1] - n2).append(string3).append(']');
                }
            }
        } else if (object instanceof byte[]) {
            int n3 = this.contentLength();
            if (n3 < 0) {
                n3 = ((byte[])object).length;
            }
            stringBuilder.append('[').append(n3).append(" bytes]");
        }
        return stringBuilder;
    }

    protected String _truncate(CharSequence charSequence, int[] nArray, int n2) {
        this._truncateOffsets(nArray, charSequence.length());
        int n3 = nArray[0];
        int n4 = Math.min(nArray[1], n2);
        return charSequence.subSequence(n3, n3 + n4).toString();
    }

    protected String _truncate(char[] cArray, int[] nArray, int n2) {
        this._truncateOffsets(nArray, cArray.length);
        int n3 = nArray[0];
        int n4 = Math.min(nArray[1], n2);
        return new String(cArray, n3, n4);
    }

    protected String _truncate(byte[] byArray, int[] nArray, int n2) {
        this._truncateOffsets(nArray, byArray.length);
        int n3 = nArray[0];
        int n4 = Math.min(nArray[1], n2);
        return new String(byArray, n3, n4, StandardCharsets.UTF_8);
    }

    protected void _truncateOffsets(int[] nArray, int n2) {
        int n3 = nArray[0];
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= n2) {
            n3 = n2;
        }
        nArray[0] = n3;
        int n4 = nArray[1];
        int n5 = n2 - n3;
        if (n4 < 0 || n4 > n5) {
            nArray[1] = n5;
        }
    }

    protected int _append(StringBuilder stringBuilder, String string) {
        stringBuilder.append('\"');
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isISOControl(c2) && this._appendEscaped(stringBuilder, c2)) continue;
            stringBuilder.append(c2);
        }
        stringBuilder.append('\"');
        return string.length();
    }

    protected boolean _appendEscaped(StringBuilder stringBuilder, int n2) {
        if (n2 == 13 || n2 == 10) {
            return false;
        }
        stringBuilder.append('\\');
        stringBuilder.append('u');
        stringBuilder.append(CharTypes.hexToChar(n2 >> 12 & 0xF));
        stringBuilder.append(CharTypes.hexToChar(n2 >> 8 & 0xF));
        stringBuilder.append(CharTypes.hexToChar(n2 >> 4 & 0xF));
        stringBuilder.append(CharTypes.hexToChar(n2 & 0xF));
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ContentReference)) {
            return false;
        }
        ContentReference contentReference = (ContentReference)object;
        if (this._offset != contentReference._offset || this._length != contentReference._length) {
            return false;
        }
        Object object2 = contentReference._rawContent;
        if (this._rawContent == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        if (this._rawContent instanceof File || this._rawContent instanceof URL || this._rawContent instanceof URI) {
            return this._rawContent.equals(object2);
        }
        return this._rawContent == contentReference._rawContent;
    }

    public int hashCode() {
        return Objects.hashCode(this._rawContent);
    }
}

