/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import java.util.Objects;
import java.util.function.BiConsumer;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import org.jetbrains.annotations.Nullable;

final class SlotListener
implements ChangeListener<Node> {
    private static final PseudoClass FILLED = PseudoClass.getPseudoClass((String)"filled");
    private final Pane slot;
    @Nullable
    private final BiConsumer<Node, Boolean> onContentUpdate;

    public SlotListener(Pane pane) {
        this((Node)pane, null);
    }

    public SlotListener(Node node, @Nullable BiConsumer<Node, Boolean> biConsumer) {
        Pane pane;
        Objects.requireNonNull(node, "Slot cannot be null.");
        this.onContentUpdate = biConsumer;
        if (!(node instanceof Pane)) {
            throw new IllegalArgumentException("Invalid slot type. Pane is required.");
        }
        this.slot = pane = (Pane)node;
    }

    public void changed(ObservableValue<? extends Node> observableValue, Node node, Node node2) {
        if (node2 != null) {
            this.slot.getChildren().setAll((Object[])new Node[]{node2});
        } else {
            this.slot.getChildren().clear();
        }
        this.slot.setVisible(node2 != null);
        this.slot.setManaged(node2 != null);
        this.slot.pseudoClassStateChanged(FILLED, node2 != null);
        if (this.onContentUpdate != null) {
            this.onContentUpdate.accept(node2, node2 != null);
        }
    }
}

