/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.Message;
import atlantafx.base.controls.TileSkinBase;
import atlantafx.base.theme.Styles;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;

public class MessageSkin
extends TileSkinBase<Message> {
    protected static final PseudoClass CLOSEABLE = PseudoClass.getPseudoClass((String)"closeable");
    protected final StackPane closeButton = new StackPane();
    protected final StackPane closeButtonIcon = new StackPane();

    public MessageSkin(Message message) {
        super(message);
        this.pseudoClassStateChanged(Styles.STATE_INTERACTIVE, message.getActionHandler() != null);
        this.registerChangeListener((ObservableValue)message.actionHandlerProperty(), observableValue -> this.pseudoClassStateChanged(Styles.STATE_INTERACTIVE, ((Message)this.getSkinnable()).getActionHandler() != null));
        this.container.setOnMouseClicked(mouseEvent -> {
            if (((Message)this.getSkinnable()).getActionHandler() != null) {
                ((Message)this.getSkinnable()).getActionHandler().run();
            }
        });
        this.closeButton.getStyleClass().add((Object)"close-button");
        this.closeButton.getChildren().setAll((Object[])new Node[]{this.closeButtonIcon});
        this.closeButton.setOnMouseClicked(mouseEvent -> this.handleClose());
        this.closeButton.setVisible(message.getOnClose() != null);
        this.closeButton.setManaged(message.getOnClose() != null);
        this.closeButtonIcon.getStyleClass().add((Object)"icon");
        this.getChildren().add((Object)this.closeButton);
        this.pseudoClassStateChanged(CLOSEABLE, message.getOnClose() != null);
        this.registerChangeListener((ObservableValue)message.onCloseProperty(), observableValue -> {
            this.closeButton.setVisible(((Message)this.getSkinnable()).getOnClose() != null);
            this.closeButton.setManaged(((Message)this.getSkinnable()).getOnClose() != null);
            this.pseudoClassStateChanged(CLOSEABLE, ((Message)this.getSkinnable()).onCloseProperty() != null);
        });
    }

    protected void handleClose() {
        if (((Message)this.getSkinnable()).getOnClose() != null) {
            ((Message)this.getSkinnable()).getOnClose().handle(new Event(Event.ANY));
        }
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        if (this.closeButton.isManaged()) {
            Bounds bounds = this.closeButton.getLayoutBounds();
            this.layoutInArea((Node)this.closeButton, d4 - bounds.getWidth() - 5.0, 5.0, bounds.getWidth(), bounds.getHeight(), -1.0, HPos.RIGHT, VPos.TOP);
        }
        this.layoutInArea((Node)this.container, d2, d3, d4, d5, -1.0, HPos.CENTER, VPos.CENTER);
    }

    @Override
    public void dispose() {
        this.unregisterChangeListeners((ObservableValue)((Message)this.getSkinnable()).actionHandlerProperty());
        this.unregisterChangeListeners((ObservableValue)((Message)this.getSkinnable()).onCloseProperty());
        super.dispose();
    }
}

