/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunkTextVar;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PngChunkZTXT
extends PngChunkTextVar {
    public static final String ID = "zTXt";

    public PngChunkZTXT(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    public ChunkRaw createRawChunk() {
        if (this.key == null || this.key.trim().length() == 0) {
            throw new PngjException("Text chunk key must be non empty");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(ChunkHelper.toBytes(this.key));
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byte[] byArray = ChunkHelper.compressBytes(ChunkHelper.toBytes(this.val), true);
            byteArrayOutputStream.write(byArray);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            ChunkRaw chunkRaw = this.createEmptyChunk(byArray2.length, false);
            chunkRaw.data = byArray2;
            return chunkRaw;
        }
        catch (IOException iOException) {
            throw new PngjException(iOException);
        }
    }

    public void parseFromRaw(ChunkRaw chunkRaw) {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < chunkRaw.data.length; ++n2) {
            if (chunkRaw.data[n2] != 0) continue;
            n3 = n2;
            break;
        }
        if (n3 < 0 || n3 > chunkRaw.data.length - 2) {
            throw new PngjException("bad zTXt chunk: no separator found");
        }
        this.key = ChunkHelper.toString(chunkRaw.data, 0, n3);
        n2 = chunkRaw.data[n3 + 1];
        if (n2 != 0) {
            throw new PngjException("bad zTXt chunk: unknown compression method");
        }
        byte[] byArray = ChunkHelper.compressBytes(chunkRaw.data, n3 + 2, chunkRaw.data.length - n3 - 2, false);
        this.val = ChunkHelper.toString(byArray);
    }
}

