/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkSingle;

public class PngChunkSBIT
extends PngChunkSingle {
    public static final String ID = "sBIT";
    private int graysb;
    private int alphasb;
    private int redsb;
    private int greensb;
    private int bluesb;

    public PngChunkSBIT(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_PLTE_AND_IDAT;
    }

    private int getCLen() {
        int n2;
        int n3 = n2 = this.imgInfo.greyscale ? 1 : 3;
        if (this.imgInfo.alpha) {
            ++n2;
        }
        return n2;
    }

    public void parseFromRaw(ChunkRaw chunkRaw) {
        if (chunkRaw.len != this.getCLen()) {
            throw new PngjException("bad chunk length " + chunkRaw);
        }
        if (this.imgInfo.greyscale) {
            this.graysb = PngHelperInternal.readInt1fromByte(chunkRaw.data, 0);
            if (this.imgInfo.alpha) {
                this.alphasb = PngHelperInternal.readInt1fromByte(chunkRaw.data, 1);
            }
        } else {
            this.redsb = PngHelperInternal.readInt1fromByte(chunkRaw.data, 0);
            this.greensb = PngHelperInternal.readInt1fromByte(chunkRaw.data, 1);
            this.bluesb = PngHelperInternal.readInt1fromByte(chunkRaw.data, 2);
            if (this.imgInfo.alpha) {
                this.alphasb = PngHelperInternal.readInt1fromByte(chunkRaw.data, 3);
            }
        }
    }

    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = null;
        chunkRaw = this.createEmptyChunk(this.getCLen(), true);
        if (this.imgInfo.greyscale) {
            chunkRaw.data[0] = (byte)this.graysb;
            if (this.imgInfo.alpha) {
                chunkRaw.data[1] = (byte)this.alphasb;
            }
        } else {
            chunkRaw.data[0] = (byte)this.redsb;
            chunkRaw.data[1] = (byte)this.greensb;
            chunkRaw.data[2] = (byte)this.bluesb;
            if (this.imgInfo.alpha) {
                chunkRaw.data[3] = (byte)this.alphasb;
            }
        }
        return chunkRaw;
    }

    public void setGraysb(int n2) {
        if (!this.imgInfo.greyscale) {
            throw new PngjException("only greyscale images support this");
        }
        this.graysb = n2;
    }

    public int getGraysb() {
        if (!this.imgInfo.greyscale) {
            throw new PngjException("only greyscale images support this");
        }
        return this.graysb;
    }

    public void setAlphasb(int n2) {
        if (!this.imgInfo.alpha) {
            throw new PngjException("only images with alpha support this");
        }
        this.alphasb = n2;
    }

    public int getAlphasb() {
        if (!this.imgInfo.alpha) {
            throw new PngjException("only images with alpha support this");
        }
        return this.alphasb;
    }

    public void setRGB(int n2, int n3, int n4) {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        this.redsb = n2;
        this.greensb = n3;
        this.bluesb = n4;
    }

    public int[] getRGB() {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        return new int[]{this.redsb, this.greensb, this.bluesb};
    }
}

