/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.dialogs.calibrate;

import io.fair_acc.chartfx.XYChart;
import io.fair_acc.dataset.DataSet;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.scene.Parent;
import us.hebi.gui.lib.aem;
import us.hebi.gui.lib.agz;
import us.hebi.gui.lib.aoa;
import us.hebi.gui.lib.aqy;
import us.hebi.gui.lib.are;
import us.hebi.gui.lib.arf;
import us.hebi.gui.lib.auu;
import us.hebi.gui.lib.auv;
import us.hebi.gui.lib.avc;
import us.hebi.gui.lib.avd;
import us.hebi.gui.lib.avh;
import us.hebi.gui.lib.awh;
import us.hebi.gui.lib.axg;
import us.hebi.gui.lib.axp;
import us.hebi.gui.lib.bfm;
import us.hebi.gui.lib.bfu;
import us.hebi.gui.lib.uk;
import us.hebi.gui.views.scope.dialogs.calibrate.CalibrationDialog;
import us.hebi.gui.views.scope.dialogs.calibrate.CalibrationResultDialog;

public class MotorEncoderCalibrationDialog
extends CalibrationDialog<avh> {
    ReadOnlyObjectProperty<agz> motorEncoder;
    ReadOnlyObjectProperty<avd> calibrationAction;
    DoubleBinding idCmd;
    DoubleBinding poleSweepTime;
    ReadOnlyDoubleProperty numPolePairs;

    @Override
    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        super.initialize(uRL, resourceBundle);
        this.setTitle("Calibrate motor encoder");
        this.calibrationAction = this.addEnumParameter("Action", List.of(avd.values()), avd.Calibrate, "Verify runs the calibration process with the existing table");
        List<agz> list = List.of(agz.c, agz.d, agz.e, agz.f);
        Object object = this.device.getInfo();
        object = ((aqy)object).a;
        this.motorEncoder = this.addEnumParameter("Motor Encoder", list, ((are)object).a.a(), "The port used for the encoder");
        this.idCmd = this.addDoubleParameter("FOC Id [A]", 1.0, "If the motor doesn't move, or doesn\u2019t move smoothly, this should be increased. Be careful to make sure this value stays at or below the current rating for your motor.");
        this.poleSweepTime = this.addDoubleParameter("Pole sweep time", 1.5, "Time spent per pole [s]");
        object = this.device.getInfo();
        object = ((aqy)object).a;
        object = ((are)object).a;
        this.numPolePairs = ((arf)object).cj;
    }

    @Override
    protected void sendPersistAllAsync() throws IOException {
        Optional.ofNullable((avh)this.result.get()).map(avh::a).ifPresent(auv2 -> auv2.c((aem)this.device.getDeviceAddress().get(), null, null));
    }

    private auu subsample(auu auu2, int n2) {
        if (auu2.getNumSamples() < n2) {
            return auu2;
        }
        auu auu3 = new auu().a(n2);
        int n3 = auu2.getNumSamples() / n2;
        for (int i2 = 0; i2 < auu2.getNumSamples() && auu3.getNumSamples() <= n2; i2 += n3) {
            auu3.c(auu2.c(i2), auu2.d(i2));
        }
        return auu3;
    }

    @Override
    protected void fillResultGrid(avh avh2) {
        auu auu2;
        auu auu3 = this.subsample(avh2.e, 2000);
        String string = Math.abs(auu2.g()[0]) < 1.0E-4 ? "Wrong encoder" : (!auu3.aN() ? "Bad fit" : (auu3.g()[1] < 0.0 ? "Wrong direction" : "Ok"));
        this.addChart(MotorEncoderCalibrationDialog.createPrimaryChart(avh2));
        this.addResult("Linear fit", auu3.dk(), string);
        this.addResult("Offset (1 rotation)", uk.e(avh2.dy), "[rad]");
        this.addResult("Offset (+/- 0.5 rotation)", uk.e(avh2.dz), "[rad]");
    }

    private static axg toDataSet(String string, auv auv2) {
        return (axg)new axg(string, auv2::Q, n2 -> aoa.j(auv2.f(n2)), n2 -> aoa.j(auv2.g(n2))).addStyleClasses(new String[]{axp.c.F()});
    }

    private static XYChart createChartWithAxes() {
        XYChart xYChart = awh.d();
        xYChart.getXAxis().setName("Commanded Rotor Position Offset");
        xYChart.getXAxis().setUnit("deg");
        xYChart.getYAxis().setName("Encoder Position");
        xYChart.getYAxis().setUnit("deg");
        return xYChart;
    }

    public static XYChart createPrimaryChart(avh avh2) {
        XYChart xYChart = MotorEncoderCalibrationDialog.createChartWithAxes();
        xYChart.getDatasets().add((Object)new axg("Samples", avh2.e::getNumSamples, n2 -> aoa.j(bfm.a(true, avh2.e.c(n2))), n2 -> aoa.j(avh2.e.e(n2))).addStyleClasses(new String[]{axp.c.F()}));
        xYChart.getDatasets().addAll((Object[])new DataSet[]{MotorEncoderCalibrationDialog.toDataSet("Forward table", avh2.b), MotorEncoderCalibrationDialog.toDataSet("Backward table", avh2.c), MotorEncoderCalibrationDialog.toDataSet("Combined table", avh2.a())});
        double[] dArray = bfm.a(0.0, Math.PI * 2, 4096);
        xYChart.getDatasets().add((Object)new axg("Offset", () -> dArray.length, n2 -> aoa.j(dArray[n2]), n2 -> aoa.j(avh2.a().r(dArray[n2]))).addStyleClasses(new String[]{axp.a.F()}));
        return xYChart;
    }

    public static XYChart createSecondaryChart(avh avh2) {
        auv auv2 = avh2.a();
        auu auu2 = avh2.e;
        XYChart xYChart = MotorEncoderCalibrationDialog.createChartWithAxes();
        Object[] objectArray = new DataSet[3];
        objectArray[0] = new axg("Forward delta", auv2::Q, n2 -> aoa.j(auv2.f(n2)), n2 -> aoa.j(avh2.b.g(n2) - auv2.g(n2))).addStyleClasses(new String[]{axp.c.F()});
        objectArray[1] = new axg("Backward delta", auv2::Q, n2 -> aoa.j(auv2.f(n2)), n2 -> aoa.j(avh2.c.g(n2) - auv2.g(n2))).addStyleClasses(new String[]{axp.c.F()});
        objectArray[2] = new axg("Corrected samples", auu2::getNumSamples, n2 -> aoa.j(bfm.a(true, auu2.c(n2))), n2 -> aoa.j(auu2.e(n2) - auv2.r(auu2.c(n2)))).addStyleClasses(new String[]{axp.c.F()});
        xYChart.getDatasets().addAll(objectArray);
        return xYChart;
    }

    @Override
    protected Parent renderResult(avh avh2) {
        CalibrationResultDialog calibrationResultDialog = new CalibrationResultDialog();
        calibrationResultDialog.setPrimaryChart(MotorEncoderCalibrationDialog.createPrimaryChart(avh2));
        calibrationResultDialog.setSecondaryChart(MotorEncoderCalibrationDialog.createSecondaryChart(avh2));
        if (avh2.cf > 0) {
            calibrationResultDialog.addResult("Missing Data", avh2.cf, "[buckets]");
        }
        calibrationResultDialog.addResult("Raw Offset", avh2.dx, "[rad]");
        calibrationResultDialog.addResult("Offset (1 rotation)", avh2.dz, "[rad]");
        calibrationResultDialog.addResult("Offset (1 pole)", avh2.dB, "[rad]");
        calibrationResultDialog.setMatFileSupplier(() -> avh2.a().a("motorEncoder", bfu.a(String.valueOf(this.motorEncoder))).a("idCmd", bfu.a(this.idCmd.get())).a("poleSweepTime", bfu.a(this.poleSweepTime.get())).a("numPolePairs", bfu.a(this.numPolePairs.get())));
        calibrationResultDialog.setPrefHeight(900.0);
        calibrationResultDialog.setPrefWidth(900.0);
        return calibrationResultDialog;
    }

    @Override
    protected Callable<avh> createTask(aem aem2) {
        avc avc2 = new avc(aem2, (agz)((Object)((Object)this.motorEncoder.get())), this.idCmd.get(), this.poleSweepTime.get(), (int)this.numPolePairs.get(), (avd)((Object)((Object)this.calibrationAction.get())));
        MotorEncoderCalibrationDialog motorEncoderCalibrationDialog = this;
        new avc(aem2, (agz)((Object)((Object)this.motorEncoder.get())), this.idCmd.get(), this.poleSweepTime.get(), (int)this.numPolePairs.get(), (avd)((Object)((Object)this.calibrationAction.get()))).a = motorEncoderCalibrationDialog;
        return avc2;
    }
}

