/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.dialogs.calibrate;

import io.fair_acc.chartfx.Chart;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import lombok.Generated;
import us.hebi.gui.controls.Css;
import us.hebi.gui.controls.HBlockSection;
import us.hebi.gui.controls.TextUtil;
import us.hebi.gui.lib.aej;
import us.hebi.gui.lib.aem;
import us.hebi.gui.lib.amx;
import us.hebi.gui.lib.art;
import us.hebi.gui.lib.atd;
import us.hebi.gui.lib.aum;
import us.hebi.gui.lib.avi;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.bat;
import us.hebi.gui.views.scope.dialogs.BasicFxmlDialog;

public abstract class CalibrationDialog<T>
extends BasicFxmlDialog
implements Initializable,
avi {
    @FXML
    private Button startButton;
    @FXML
    private Button cancelButton;
    @FXML
    private Button showDetailsButton;
    @FXML
    private Button sendPersistButton;
    @FXML
    HBlockSection parameterSection;
    @FXML
    GridPane parameterGrid;
    @FXML
    Separator paramDivider;
    @FXML
    Separator chartDivider;
    @FXML
    Pane chartPane;
    @FXML
    GridPane settingsGrid;
    @FXML
    HBlockSection progressSection;
    @FXML
    HBlockSection resultSection;
    @FXML
    GridPane resultGrid;
    @FXML
    Text progressText;
    @FXML
    ProgressBar progressBar;
    private BooleanProperty isWorking;
    private List<ObservableBooleanValue> inputValidConditions;
    protected Runnable onCallAsync = null;
    private Consumer<T> onResult = object -> {};
    @Inject
    protected aum device;
    @Inject
    ExecutorService executorService;
    @Inject
    art properties;
    protected final ObjectProperty<T> result = new SimpleObjectProperty(null);

    public CalibrationDialog() {
        super("calibrationdialog.fxml");
    }

    public BooleanBinding addExpectedSetting(String string, String string2, ObservableStringValue observableStringValue) {
        Text text = Css.addClass(new Text(string), "param-name");
        Label label = Css.addClass(new Label(string2), "param-label");
        Label label2 = Css.addClass(new Label(), "param-label");
        label2.textProperty().bind((ObservableValue)observableStringValue);
        this.settingsGrid.addRow(this.settingsGrid.getRowCount(), new Node[]{text, label, label2});
        this.settingsGrid.setVisible(true);
        return Bindings.createBooleanBinding(() -> string2.equalsIgnoreCase((String)observableStringValue.get()), (Observable[])new Observable[]{observableStringValue});
    }

    public <E extends Enum<E>> ReadOnlyObjectProperty<E> addEnumParameter(String string, List<E> list, E e2, String string2) {
        ObjectProperty<E> objectProperty = this.properties.getEnum(CalibrationDialog.getPropName(string), e2);
        ChoiceBox choiceBox = Css.addClass(new ChoiceBox(), "param-ComboBox");
        choiceBox.getItems().setAll(list);
        if (list.contains(e2)) {
            choiceBox.setValue((Object)((Enum)objectProperty.get()));
        }
        ObjectProperty objectProperty2 = this.addParameter(string, choiceBox, string2).valueProperty();
        BooleanBinding booleanBinding = objectProperty2.isNotNull();
        this.addValidityRequirement((ObservableBooleanValue)booleanBinding);
        objectProperty.bind((ObservableValue)Bindings.when((ObservableBooleanValue)booleanBinding).then((ObservableObjectValue)objectProperty2).otherwise(e2));
        return objectProperty2;
    }

    public DoubleBinding addDoubleParameter(String string, double d2, String string2) {
        DoubleProperty doubleProperty = this.properties.getDouble(CalibrationDialog.getPropName(string), d2);
        String string3 = String.valueOf(doubleProperty.get());
        if (string3.endsWith(".0")) {
            string3 = string3.substring(0, string3.length() - 2);
        }
        TextField textField = Css.addClass(new TextField(string3), "param-input");
        DoubleBinding doubleBinding = TextUtil.asDoubleBinding((ObservableStringValue)this.addParameter(string, textField, string2).textProperty());
        BooleanBinding booleanBinding = TextUtil.isFinite((ObservableDoubleValue)doubleBinding);
        this.addValidityRequirement((ObservableBooleanValue)booleanBinding);
        doubleProperty.bind((ObservableValue)Bindings.when((ObservableBooleanValue)booleanBinding).then((ObservableNumberValue)doubleBinding).otherwise(d2));
        return doubleBinding;
    }

    private <C extends Control> C addParameter(String string, C c2, String string2) {
        Text text = Css.addClass(new Text(string), "param-name");
        c2.setTooltip(bat.a(string2));
        this.parameterGrid.addRow(this.parameterGrid.getRowCount(), new Node[]{text, c2});
        this.parameterGrid.setVisible(true);
        return c2;
    }

    private static String getPropName(String string) {
        return "CALIBRATION_" + string.toUpperCase(Locale.US).replaceAll("\\s+", "_");
    }

    public void addResult(String string, Object object, String string2) {
        Text text = Css.addClass(new Text(string), "param-name");
        TextField textField = Css.addClass(new TextField(String.valueOf(object)), "param-input");
        textField.setEditable(false);
        Text text2 = Css.addClass(new Text(string2), "param-name");
        this.resultGrid.addRow(this.resultGrid.getRowCount(), new Node[]{text, textField, text2});
        this.resultGrid.setVisible(true);
    }

    public void addChart(Chart chart) {
        this.chartPane.getChildren().add((Object)chart);
    }

    private void addValidityRequirement(ObservableBooleanValue observableBooleanValue) {
        this.inputValidConditions.add(observableBooleanValue);
        BooleanBinding booleanBinding = Bindings.createBooleanBinding(() -> {
            Iterator<ObservableBooleanValue> iterator = this.inputValidConditions.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().get()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }, (Observable[])((Observable[])this.inputValidConditions.toArray(ObservableBooleanValue[]::new)));
        this.startButton.disableProperty().unbind();
        this.startButton.disableProperty().bind((ObservableValue)this.isWorking.or((ObservableBooleanValue)booleanBinding.not()));
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.isWorking = new SimpleBooleanProperty(false);
        this.inputValidConditions = new ArrayList<ObservableBooleanValue>();
        this.parameterSection.visibleProperty().bind((ObservableValue)this.isWorking.not());
        this.progressSection.visibleProperty().bind((ObservableValue)this.isWorking);
        this.resultSection.visibleProperty().bind((ObservableValue)this.showDetailsButton.visibleProperty());
        this.startButton.disableProperty().bind((ObservableValue)this.isWorking.or((ObservableBooleanValue)this.device.getEmptyProperty()));
        this.cancelButton.visibleProperty().bind((ObservableValue)this.isWorking);
        this.closeButton.disableProperty().bind((ObservableValue)this.isWorking);
        this.showDetailsButton.setVisible(false);
        this.sendPersistButton.visibleProperty().bind((ObservableValue)this.showDetailsButton.visibleProperty());
        this.settingsGrid.setVisible(false);
        this.parameterGrid.setVisible(false);
        this.paramDivider.visibleProperty().bind((ObservableValue)this.settingsGrid.visibleProperty().and((ObservableBooleanValue)this.parameterGrid.visibleProperty()));
        this.chartDivider.visibleProperty().bind((ObservableValue)this.chartPane.visibleProperty());
        this.chartPane.visibleProperty().bind((ObservableValue)Bindings.isNotEmpty((ObservableList)this.chartPane.getChildren()));
        azx.a(new Node[]{this.progressSection, this.parameterSection, this.resultSection, this.paramDivider, this.parameterGrid, this.settingsGrid, this.chartDivider, this.chartPane, this.showDetailsButton, this.sendPersistButton, this.cancelButton});
        this.startButton.setOnAction(actionEvent2 -> {
            this.isWorking.set(true);
            this.showDetailsButton.setVisible(false);
            this.b("Starting", -1.0);
            CalibrationDialog calibrationDialog = this;
            Future future = this.executorService.submit(calibrationDialog.createTask((aem)calibrationDialog.device.getDeviceAddress().get()));
            this.cancelButton.setOnAction(actionEvent -> future.cancel(true));
            ((CompletableFuture)CompletableFuture.supplyAsync(amx.a(() -> future.get()), this.executorService).thenAcceptAsync(object -> {
                this.isWorking.set(false);
                this.clearResultGrid();
                this.fillResultGrid(object);
                this.result.set(object);
                this.onResult.accept(object);
                this.showDetailsButton.setVisible(true);
                this.showDetailsButton.setOnAction(actionEvent -> this.showResultInStage(azx.a(actionEvent), object));
                this.startButton.setText("Run again");
            }, azx.d)).exceptionallyAsync(throwable -> {
                this.isWorking.set(false);
                this.startButton.setText("Run");
                if (!future.isCancelled()) {
                    throwable.printStackTrace();
                    atd.a(throwable.getCause().getMessage(), azx.a(actionEvent2));
                }
                return null;
            }, azx.d);
        });
        this.sendPersistButton.setOnAction(actionEvent -> {
            this.sendPersistButton.setDisable(true);
            CompletableFuture.runAsync(() -> {
                try {
                    this.sendPersistAllAsync();
                    return;
                }
                catch (IOException iOException) {
                    Platform.runLater(() -> atd.a("Failed to send persist message", azx.a(actionEvent)));
                    return;
                }
                finally {
                    Platform.runLater(() -> this.sendPersistButton.setDisable(false));
                }
            });
        });
    }

    protected void sendPersistAllAsync() throws IOException {
        aej.a((aem)this.device.getDeviceAddress().get());
    }

    protected void clearResultGrid() {
        this.resultGrid.getChildren().removeIf(node -> {
            Integer n2 = GridPane.getRowIndex((Node)node);
            return n2 != null && n2 > 0;
        });
        this.chartPane.getChildren().clear();
        this.result.set(null);
    }

    protected abstract void fillResultGrid(T var1);

    @Override
    public void updateProgress(String string) {
        azx.b(() -> this.progressText.setText(string));
    }

    @Override
    public void updateProgress(double d2) {
        azx.b(() -> this.progressBar.setProgress(d2));
    }

    protected void showResultInStage(Window window, T t2) {
        Stage stage = new Stage();
        stage.setTitle(this.getTitle());
        stage.setScene(new Scene(this.renderResult(t2)));
        stage.initOwner(window);
        azx.a(stage.getScene().getRoot());
        azx.b(stage);
    }

    protected abstract Parent renderResult(T var1);

    protected abstract Callable<T> createTask(aem var1);

    @Generated
    public void setOnResult(Consumer<T> consumer) {
        this.onResult = consumer;
    }
}

