/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.dialogs.calibrate;

import io.fair_acc.chartfx.XYChart;
import io.fair_acc.dataset.DataSet;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.scene.Parent;
import us.hebi.gui.lib.aem;
import us.hebi.gui.lib.afl;
import us.hebi.gui.lib.aus;
import us.hebi.gui.lib.aut;
import us.hebi.gui.lib.auu;
import us.hebi.gui.lib.awh;
import us.hebi.gui.lib.axg;
import us.hebi.gui.lib.axp;
import us.hebi.gui.lib.jh;
import us.hebi.gui.lib.uk;
import us.hebi.gui.views.scope.dialogs.calibrate.CalibrationDialog;
import us.hebi.gui.views.scope.dialogs.calibrate.CalibrationResultDialog;

public class AdcCalibrationDialog
extends CalibrationDialog<aut> {
    ReadOnlyObjectProperty<afl> controlStrategy;
    DoubleBinding baseOffset;
    DoubleBinding sampleRange;
    DoubleBinding numSamples;

    @Override
    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        super.initialize(uRL, resourceBundle);
        this.setTitle("Calibrate ADC offsets");
        List<afl> list = Arrays.stream(afl.values()).filter(afl2 -> afl2 != afl.a).toList();
        this.controlStrategy = this.addEnumParameter("Control strategy", list, afl.b, "The strategy that the adc should be calibrated in. We recommend using 'Off'. The strategy will not be reset afterwards.");
        this.baseOffset = this.addDoubleParameter("Base offset", 38.0, "center base");
        this.sampleRange = this.addDoubleParameter("Sample range", 4.0, "searches base offset +/- sample range");
        this.numSamples = this.addDoubleParameter("# Samples", 200.0, "number of samples");
    }

    @Override
    protected void fillResultGrid(aut aut2) {
        this.addResult("I a", aut2.a);
        this.addResult("I b", aut2.b);
        this.addResult("I c", aut2.c);
        this.addResult("I bus", aut2.d);
    }

    private void addResult(String string, auu auu2) {
        this.addResult(string, uk.d(auu2.g()[0]), this.getComment(auu2));
    }

    private String getComment(auu auu2) {
        if (!auu2.aN()) {
            return "Bad fit: " + auu2.dk();
        }
        return "Ok";
    }

    @Override
    protected Parent renderResult(aut aut2) {
        XYChart xYChart = awh.d();
        xYChart.setTitle("Phase Current");
        xYChart.getXAxis().setName("Offset");
        xYChart.getYAxis().setName("Current");
        xYChart.getYAxis().setUnit("A");
        DataSet dataSet = AdcCalibrationDialog.wrap("A", aut2.a);
        DataSet dataSet2 = AdcCalibrationDialog.wrap("B", aut2.b);
        DataSet dataSet3 = AdcCalibrationDialog.wrap("C", aut2.c);
        xYChart.getDatasets().addAll((Object[])new DataSet[]{dataSet, dataSet2, dataSet3});
        awh.a(xYChart, "A", aut2.K);
        awh.a(xYChart, "B", aut2.L);
        awh.a(xYChart, "C", aut2.M);
        awh.a(xYChart, null);
        XYChart xYChart2 = awh.d();
        xYChart2.setTitle("Bus Current");
        xYChart2.getXAxis().setName("Offset");
        xYChart2.getYAxis().setName("Current");
        xYChart2.getYAxis().setUnit("A");
        DataSet dataSet4 = AdcCalibrationDialog.wrap("Bus", aut2.d);
        xYChart2.getDatasets().add((Object)dataSet4);
        awh.a(xYChart2, null, aut2.N);
        awh.a(xYChart2, null);
        CalibrationResultDialog calibrationResultDialog = new CalibrationResultDialog();
        calibrationResultDialog.setPrimaryChart(xYChart);
        calibrationResultDialog.setSecondaryChart(xYChart2);
        calibrationResultDialog.addResult("Offset A", aut2.a.g()[0], this.getComment(aut2.a));
        calibrationResultDialog.addResult("Offset B", aut2.b.g()[0], this.getComment(aut2.b));
        calibrationResultDialog.addResult("Offset C", aut2.c.g()[0], this.getComment(aut2.c));
        calibrationResultDialog.addResult("Offset Bus", aut2.d.g()[0], this.getComment(aut2.d));
        return calibrationResultDialog;
    }

    private static DataSet wrap(String string, auu auu2) {
        return new axg(string, auu2::getNumSamples, auu2::c, auu2::d).addStyleClasses(new String[]{axp.c.F()});
    }

    private static DataSet wrapCoeffs(auu auu2) {
        jh jh2 = new jh(100);
        jh jh3 = new jh(100);
        auu2.g();
        return new axg("coeffs", jh2, jh3).addStyleClasses(new String[]{axp.c.F()});
    }

    @Override
    protected Callable<aut> createTask(aem aem2) {
        aus aus2 = new aus(aem2, (afl)((Object)((Object)this.controlStrategy.get())), this.numSamples.intValue(), this.baseOffset.floatValue(), this.sampleRange.floatValue());
        AdcCalibrationDialog adcCalibrationDialog = this;
        new aus(aem2, (afl)((Object)((Object)this.controlStrategy.get())), this.numSamples.intValue(), this.baseOffset.floatValue(), this.sampleRange.floatValue()).a = adcCalibrationDialog;
        return aus2;
    }
}

