/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import com.jfoenix.controls.JFXSlider;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.text.Text;
import javafx.stage.Window;
import javafx.util.StringConverter;
import javax.inject.Inject;
import us.hebi.gui.controls.SliderUtil;
import us.hebi.gui.lib.afl;
import us.hebi.gui.lib.aib;
import us.hebi.gui.lib.aqj;
import us.hebi.gui.lib.aqt;
import us.hebi.gui.lib.aqy;
import us.hebi.gui.lib.aro;
import us.hebi.gui.lib.asw;
import us.hebi.gui.lib.asy;
import us.hebi.gui.lib.atb;
import us.hebi.gui.lib.atd;
import us.hebi.gui.lib.aty;
import us.hebi.gui.lib.auh;
import us.hebi.gui.lib.aum;
import us.hebi.gui.lib.avk;
import us.hebi.gui.lib.awd;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.bbt;
import us.hebi.gui.lib.wn;
import us.hebi.gui.views.scope.assets.Asset;
import us.hebi.gui.views.scope.dialogs.convertlog.ConvertLogPresenter;
import us.hebi.gui.views.scope.dialogs.convertlog.ConvertLogView;

public class MonitoringController {
    @FXML
    private Text fbkFrequencyLabel;
    @FXML
    private Button fbkFrequencyTarget;
    @FXML
    private JFXSlider fbkFrequencySlider;
    @FXML
    private ToggleButton fbkFrequencyEnabledCheckbox;
    @FXML
    private Button startLogButton;
    @FXML
    private Button stopLogButton;
    @FXML
    private ComboBox<String> timeRangeSelector;
    @FXML
    private TabPane tabPane;
    @FXML
    private Button clearCommandsButton;
    @FXML
    private Button closePlotsButton;
    @FXML
    private Tab customTab;
    @FXML
    private Button viewKinematicsBtn;
    @FXML
    private Button viewLogBtn;
    @FXML
    private Button convertLogBtn;
    public static final StringConverter<Double> frequencylabelFormatter = new bbt();
    private final DoubleProperty posFbk = new SimpleDoubleProperty(Double.NaN);
    private final DoubleProperty velFbk = new SimpleDoubleProperty(Double.NaN);
    private final DoubleProperty effortFbk = new SimpleDoubleProperty(Double.NaN);
    boolean commandsEnabled = false;
    @Inject
    awd plottingService;
    @Inject
    aum module;
    @Inject
    auh moduleSelector;
    @Inject
    atb loggingService;
    @Inject
    aro properties;
    @Inject
    aty commandService;
    final aib command = new aib();
    @Inject
    avk fileChooser;
    @Inject
    asy dialogHelper;
    @Inject
    asw hebiFileLoader;

    @FXML
    void initialize() {
        this.timeRangeSelector.getSelectionModel().select((Object)((String)this.properties.a.get()));
        this.properties.a.bind((ObservableValue)this.timeRangeSelector.getSelectionModel().selectedItemProperty());
        ChangeListener changeListener = (observableValue, string, string2) -> {
            if (string2 != null) {
                if (string2.startsWith("60")) {
                    this.plottingService.a(TimeUnit.SECONDS, 60L);
                    return;
                }
                if (string2.startsWith("30")) {
                    this.plottingService.a(TimeUnit.SECONDS, 30L);
                    return;
                }
                if (string2.startsWith("10")) {
                    this.plottingService.a(TimeUnit.SECONDS, 10L);
                    return;
                }
                if (string2.startsWith("5")) {
                    this.plottingService.a(TimeUnit.SECONDS, 5L);
                    return;
                }
                this.plottingService.bJ();
                return;
            }
            this.plottingService.bJ();
        };
        changeListener.changed(null, null, (Object)((String)this.timeRangeSelector.getSelectionModel().getSelectedItem()));
        this.timeRangeSelector.getSelectionModel().selectedItemProperty().addListener(changeListener);
        DoubleBinding doubleBinding = Bindings.createDoubleBinding(() -> MonitoringController.sliderToHz(this.fbkFrequencyEnabledCheckbox.isSelected(), this.fbkFrequencySlider.getValue()), (Observable[])new Observable[]{this.fbkFrequencyEnabledCheckbox.selectedProperty(), this.fbkFrequencySlider.valueProperty()});
        this.fbkFrequencySlider.disableProperty().bind((ObservableValue)this.fbkFrequencyEnabledCheckbox.selectedProperty().not());
        this.fbkFrequencyLabel.textProperty().bind((ObservableValue)doubleBinding.asString("%.1f Hz"));
        this.fbkFrequencySlider.setLabelFormatter(frequencylabelFormatter);
        SliderUtil.setValueLabelFactory(this.fbkFrequencySlider, MonitoringController::sliderToHz);
        SliderUtil.setupTargetButton(this.fbkFrequencySlider, this.fbkFrequencyEnabledCheckbox.selectedProperty(), this.fbkFrequencyTarget, MonitoringController::hzToSlider, MonitoringController::sliderToHz0);
        this.fbkFrequencySlider.setValue(MonitoringController.hzToSlider(100.0));
        this.plottingService.k.bind((ObservableValue)doubleBinding);
        Object object = this.module.getInfo();
        BooleanBinding booleanBinding = ((aqy)object).d.greaterThan(0);
        this.startLogButton.disableProperty().bind((ObservableValue)booleanBinding.not().or((ObservableBooleanValue)this.loggingService.O));
        this.startLogButton.setOnAction(actionEvent -> {
            this.loggingService.p((ActionEvent)actionEvent);
            this.startLogButton.getParent().requestFocus();
        });
        this.stopLogButton.disableProperty().bind((ObservableValue)this.loggingService.O.not());
        this.stopLogButton.setOnAction(actionEvent -> {
            this.loggingService.q((ActionEvent)actionEvent);
            this.stopLogButton.getParent().requestFocus();
        });
        this.startLogButton.visibleProperty().bind((ObservableValue)this.loggingService.O.not());
        this.startLogButton.managedProperty().bind((ObservableValue)this.startLogButton.visibleProperty());
        this.stopLogButton.visibleProperty().bind((ObservableValue)this.startLogButton.visibleProperty().not());
        this.stopLogButton.managedProperty().bind((ObservableValue)this.stopLogButton.visibleProperty());
        object = this.module.getFeedback();
        this.posFbk.bind((ObservableValue)((aqj)object).y);
        object = this.module.getFeedback();
        this.velFbk.bind((ObservableValue)((aqj)object).D);
        Observable[] observableArray = new Observable[2];
        object = this.module.getGains();
        observableArray[0] = ((aqt)object).v;
        object = this.module.getFeedback();
        observableArray[1] = ((aqj)object).h;
        this.effortFbk.bind((ObservableValue)Bindings.createDoubleBinding(() -> {
            if (this.module.getGains().a() == afl.c) {
                return Double.NaN;
            }
            aqj aqj2 = this.module.getFeedback();
            return aqj2.h.get();
        }, (Observable[])observableArray));
        this.clearCommandsButton.disableProperty().bind((ObservableValue)this.module.getEmptyProperty());
        this.clearCommandsButton.setOnAction(actionEvent -> this.commandService.a(this.moduleSelector.getSelectedAddresses()));
        this.closePlotsButton.disableProperty().bind((ObservableValue)this.plottingService.Q.not());
        this.closePlotsButton.setOnAction(actionEvent -> this.plottingService.bH());
        this.closePlotsButton.disabledProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl2.booleanValue() && !bl3.booleanValue()) {
                this.tabPane.requestFocus();
            }
        });
        if (!azx.aV()) {
            this.viewKinematicsBtn.setDisable(true);
        }
    }

    @FXML
    public void viewKinematics(ActionEvent actionEvent) {
        Asset.loadCommonAssets();
        Window window = azx.a(actionEvent);
        File file = this.fileChooser.c(window);
        if (file == null) {
            return;
        }
        switch (wn.a(file)) {
            case d: {
                this.hebiFileLoader.b(window, file);
                return;
            }
            case e: {
                this.hebiFileLoader.a(window, file);
                return;
            }
        }
        atd.a("Unknown file type", window);
    }

    @FXML
    public void viewLogfile(ActionEvent actionEvent) {
        Window window = azx.a(actionEvent);
        File file = this.fileChooser.a(window);
        if (file == null) {
            return;
        }
        asw.c(window, file);
    }

    @FXML
    void convertLogfile(ActionEvent actionEvent) {
        File file = this.fileChooser.a(azx.a(actionEvent));
        if (file == null) {
            return;
        }
        ConvertLogView convertLogView = new ConvertLogView(file);
        convertLogView.getViewAsync(parent -> this.dialogHelper.a((Parent)parent, ((ConvertLogPresenter)convertLogView.getPresenter()).getCloseButton()));
    }

    public static double hzToSlider(double d2) {
        return Math.log10(d2);
    }

    public static double sliderToHz(double d2) {
        return MonitoringController.sliderToHz(true, d2);
    }

    public static double sliderToHz(boolean bl2, double d2) {
        if (bl2) {
            return MonitoringController.sliderToHz0(d2);
        }
        return 0.0;
    }

    private static double sliderToHz0(double d2) {
        return Math.pow(10.0, d2);
    }
}

