/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.rima;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.spi.DefaultNumericAxis;
import io.fair_acc.chartfx.plugins.ChartPlugin;
import io.fair_acc.chartfx.plugins.XValueIndicator;
import io.fair_acc.chartfx.plugins.YRangeIndicator;
import io.fair_acc.chartfx.plugins.YValueIndicator;
import io.fair_acc.chartfx.plugins.Zoomer;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.ui.geometry.Side;
import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.spi.DataRange;
import io.fair_acc.dataset.utils.DataSetStyleBuilder;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javax.inject.Inject;
import us.hebi.gui.lib.anh;
import us.hebi.gui.lib.aqh;
import us.hebi.gui.lib.aqi;
import us.hebi.gui.lib.art;
import us.hebi.gui.lib.asn;
import us.hebi.gui.lib.awh;
import us.hebi.gui.lib.awk;
import us.hebi.gui.lib.awx;
import us.hebi.gui.lib.awy;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.b;
import us.hebi.gui.lib.bbp;

public class TfmImageView
extends VBox {
    @Inject
    aqi tfmImageAnalysis;
    @Inject
    art properties;

    public TfmImageView() {
        b.a(this);
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("tfmimageview.css").toExternalForm());
        this.setPrefHeight(500.0);
        this.initialize();
    }

    void initialize() {
        Chart chart = azx.a(this.createTfmChart(), "tfm-chart");
        Chart chart2 = azx.a(this.createColorPicker(), "color-picker");
        VBox.setVgrow((Node)chart, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{chart, chart2});
    }

    private Chart createTfmChart() {
        awx awx2 = new awx("image").a();
        awk awk2 = awk.a("selected", 1000, new String[0]);
        awk2.addStyleClasses(new String[]{"trace-points"});
        awk2.setStyle(DataSetStyleBuilder.instance().setDatasetColor("black").setLineWidth(2.0).build());
        awk awk3 = awk.a("surface", 1000, new String[0]);
        awk3.addStyleClasses(new String[]{"trace-solid"});
        awk3.setStyle(DataSetStyleBuilder.instance().setDatasetColor("lightgreen").setMarkerSize(3.0).build());
        XYChart xYChart = new XYChart();
        Zoomer zoomer = awh.a();
        xYChart.getToolBar().setVisible(false);
        xYChart.getPlugins().add((Object)zoomer);
        xYChart.getRenderers().setAll((Object[])new Renderer[]{new awy(awx2), awh.a()});
        DefaultNumericAxis defaultNumericAxis = (DefaultNumericAxis)xYChart.getFirstAxis(Orientation.HORIZONTAL);
        defaultNumericAxis.setTickUnit(5.0);
        defaultNumericAxis.setSide(Side.TOP);
        defaultNumericAxis.setUnit("mm");
        defaultNumericAxis.setName("x width");
        defaultNumericAxis.setAutoRanging(false);
        DefaultNumericAxis defaultNumericAxis2 = (DefaultNumericAxis)xYChart.getFirstAxis(Orientation.VERTICAL);
        defaultNumericAxis2.setTickUnit(5.0);
        defaultNumericAxis2.invertAxis(true);
        defaultNumericAxis2.setUnit("mm");
        defaultNumericAxis2.setName("z depth");
        defaultNumericAxis2.setAutoRanging(false);
        YValueIndicator yValueIndicator = new YValueIndicator((Axis)defaultNumericAxis2, 0.0);
        YValueIndicator yValueIndicator2 = new YValueIndicator((Axis)defaultNumericAxis2, 0.0);
        YRangeIndicator yRangeIndicator = new YRangeIndicator(defaultNumericAxis2, yValueIndicator.getValue(), yValueIndicator2.getValue());
        DoubleBinding doubleBinding = Bindings.createDoubleBinding(() -> Math.min(yValueIndicator.getValue(), yValueIndicator2.getValue()), (Observable[])new Observable[]{yValueIndicator.valueProperty(), yValueIndicator2.valueProperty()});
        DoubleBinding doubleBinding2 = Bindings.createDoubleBinding(() -> Math.max(yValueIndicator.getValue(), yValueIndicator2.getValue()), (Observable[])new Observable[]{yValueIndicator.valueProperty(), yValueIndicator2.valueProperty()});
        yRangeIndicator.lowerBoundProperty().bind((ObservableValue)doubleBinding);
        yRangeIndicator.upperBoundProperty().bind((ObservableValue)doubleBinding2);
        xYChart.getPlugins().addAll((Object[])new ChartPlugin[]{yValueIndicator, yValueIndicator2, yRangeIndicator});
        azx.a(this.tfmImageAnalysis::o, (ObservableDoubleValue)doubleBinding);
        azx.a(this.tfmImageAnalysis::p, (ObservableDoubleValue)doubleBinding2);
        this.tfmImageAnalysis.f(aqh2 -> {
            awk2.x(aqh2.P());
            aqh2.a(awk2::f);
            awk2.bL();
            awk3.x(aqh2.a.C.ax());
            anh anh2 = awk3::f;
            aqh aqh3 = aqh2;
            float f2 = aqh3.a.cY;
            float f3 = aqh3.a.cZ;
            int n2 = aqh3.a.C.ax();
            float[] fArray = aqh3.a.C.A;
            for (int i2 = 0; i2 < n2; ++i2) {
                anh2.accept(f2 + f3 * (float)i2, fArray[i2]);
            }
            awk3.bL();
            aqh aqh4 = aqh2;
            aqh3 = aqh4;
            aqh3 = aqh2;
            awx2.a((Image)aqh2.c.a, aqh2.a.da, aqh4.a.da + aqh3.a.dc * (float)aqh3.a.gH, aqh2.a.db, aqh3.a.db + aqh3.a.dd * (float)aqh3.a.gI);
        });
        yValueIndicator.valueProperty().bindBidirectional((Property)this.properties.getDouble("TFM_MIN_DEPTH", 1.0));
        yValueIndicator2.valueProperty().bindBidirectional((Property)this.properties.getDouble("TFM_MAX_DEPTH", 11.0));
        ObservableList<DataSet> observableList = ((Chart)xYChart).getAllDatasets();
        DataRange dataRange = new DataRange();
        DataRange dataRange2 = new DataRange();
        Runnable runnable = () -> {
            double d2;
            if (!zoomer.zoomStackDeque().isEmpty()) {
                return;
            }
            dataRange.clear();
            dataRange2.clear();
            for (DataSet dataSet : observableList) {
                AxisDescription axisDescription = dataSet.getAxisDescription(0);
                dataRange.add(axisDescription.getMin());
                dataRange.add(axisDescription.getMax());
                AxisDescription axisDescription2 = dataSet.getAxisDescription(1);
                dataRange2.add(axisDescription2.getMin());
                dataRange2.add(axisDescription2.getMax());
            }
            double d3 = dataRange.getLength() / xYChart.getCanvas().getWidth();
            double d4 = dataRange2.getLength() / xYChart.getCanvas().getHeight();
            double d5 = d3 / d4;
            if (d2 > 1.0) {
                double d6 = dataRange2.getLength() * (d5 - 1.0);
                DataRange dataRange3 = dataRange2;
                dataRange3.set(dataRange3.getMin(), dataRange2.getMax() + d6);
            } else if (d5 < 1.0) {
                double d7 = dataRange.getLength() * (1.0 / d5 - 1.0);
                DataRange dataRange4 = dataRange;
                dataRange4.set(dataRange4.getMin(), dataRange.getMax() + d7);
            }
            if (doubleBinding2.get() > dataRange2.getMax()) {
                if (yValueIndicator.getValue() > dataRange2.getMax()) {
                    yValueIndicator.setValue(dataRange2.getMax());
                }
                if (yValueIndicator2.getValue() > dataRange2.getMax()) {
                    yValueIndicator2.setValue(dataRange2.getMax());
                }
            }
            if (doubleBinding.get() < dataRange2.getMin()) {
                if (yValueIndicator.getValue() < dataRange2.getMin()) {
                    yValueIndicator.setValue(dataRange2.getMin());
                }
                if (yValueIndicator2.getValue() < dataRange2.getMin()) {
                    yValueIndicator2.setValue(dataRange2.getMin());
                }
            }
            defaultNumericAxis.set(dataRange.getMin(), dataRange.getMax());
            defaultNumericAxis2.set(dataRange2.getMin(), dataRange2.getMax());
        };
        azx.b(runnable, new Observable[]{xYChart.getCanvas().heightProperty(), xYChart.getCanvas().widthProperty()});
        awx2.addListener((bitState, n2) -> azx.b(runnable));
        return xYChart;
    }

    private Chart createColorPicker() {
        Color[] colorArray = this.tfmImageAnalysis.b.a();
        asn asn2 = new asn(1.0, 1.0);
        asn asn3 = new asn(1.0, 1.0);
        asn asn4 = new asn((double)colorArray.length, 1.0);
        asn2.a(0, colorArray[0]);
        asn3.a(0, colorArray[colorArray.length - 1]);
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            asn4.a(i2, colorArray[i2]);
        }
        XYChart xYChart = new XYChart();
        xYChart.setLegendVisible(false);
        xYChart.getGridRenderer().getHorizontalMajorGrid().setVisible(false);
        xYChart.getGridRenderer().getVerticalMajorGrid().setVisible(false);
        xYChart.getToolBar().setVisible(false);
        Axis axis = xYChart.getXAxis();
        axis.setTickUnit(100.0);
        axis.setUnit(null);
        axis.setName("intensity");
        XValueIndicator xValueIndicator = new XValueIndicator(axis, 0.0);
        XValueIndicator xValueIndicator2 = new XValueIndicator(axis, 0.0);
        xYChart.getPlugins().addAll((Object[])new ChartPlugin[]{xValueIndicator, xValueIndicator2});
        bbp bbp2 = new bbp(axis);
        azx.a(this.tfmImageAnalysis::n, (ObservableDoubleValue)bbp2.valueProperty());
        xYChart.getPlugins().add((Object)bbp2);
        awx awx2 = new awx("below");
        awx awx3 = new awx("above");
        awx awx4 = new awx("range");
        xYChart.getRenderers().setAll((Object[])new Renderer[]{new awy(awx2, awx3, awx4)});
        azx.b(() -> {
            double d2 = Math.min(xValueIndicator.getValue(), xValueIndicator2.getValue());
            double d3 = Math.max(xValueIndicator.getValue(), xValueIndicator2.getValue());
            this.tfmImageAnalysis.b.dS = d2;
            this.tfmImageAnalysis.b.F = d3;
            awx2.a((Image)asn2.a, 0.0, d2, 0.0, 0.1);
            awx3.a((Image)asn3.a, d3, 350.0, 0.0, 0.1);
            awx4.a((Image)asn4.a, d2, d3, 0.0, 0.1);
        }, new Observable[]{xValueIndicator.valueProperty(), xValueIndicator2.valueProperty()});
        xValueIndicator.valueProperty().bindBidirectional((Property)this.properties.getDouble("TFM_COLORMAP_MIN", 50.0));
        xValueIndicator2.valueProperty().bindBidirectional((Property)this.properties.getDouble("TFM_COLORMAP_MAX", 235.0));
        bbp2.valueProperty().bindBidirectional((Property)this.properties.getDouble("TFM_MIN_INTENSITY", 122.0));
        return xYChart;
    }
}

