/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps.components;

import com.jfoenix.controls.JFXButton;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Stack;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.shape.MeshView;
import javafx.stage.Window;
import javax.inject.Inject;
import lombok.Generated;
import us.hebi.gui.lib.anw;
import us.hebi.gui.lib.aoz;
import us.hebi.gui.lib.apb;
import us.hebi.gui.lib.apc;
import us.hebi.gui.lib.asq;
import us.hebi.gui.lib.ast;
import us.hebi.gui.lib.asv;
import us.hebi.gui.lib.asy;
import us.hebi.gui.lib.ate;
import us.hebi.gui.lib.avk;
import us.hebi.gui.lib.azi;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.b;
import us.hebi.gui.lib.bab;
import us.hebi.gui.lib.baq;
import us.hebi.gui.lib.bcu;
import us.hebi.gui.lib.bku;
import us.hebi.gui.lib.bzz;
import us.hebi.gui.views.maps.MapsAppState;
import us.hebi.gui.views.maps.MapsAppState$View;
import us.hebi.gui.views.maps.MapsCss;
import us.hebi.gui.views.maps.components.dialogs.ElbowWizardController;
import us.hebi.gui.views.maps.components.dialogs.FlatWizardController;

public class RegistrationController
extends azi {
    @FXML
    private Button addWaypointBtn;
    @FXML
    private Button createSurfaceBtn;
    @FXML
    private Button loadFileBtn;
    @FXML
    private Button clearBtn;
    @FXML
    private Button deletePrevBtn;
    @FXML
    private Button wizardFlatBtn;
    @FXML
    private Button wizardElbowBtn;
    @FXML
    private Button backBtn;
    @FXML
    private Button addRowBtn;
    @FXML
    private AnchorPane pane3d;
    @FXML
    private Pane waypointList;
    @FXML
    private ScrollPane waypointScrollPane;
    @FXML
    private Pane flatWizard;
    @FXML
    private FlatWizardController flatWizardController;
    @FXML
    private Pane elbowWizard;
    @FXML
    private ElbowWizardController elbowWizardController;
    BooleanProperty hasScrollContentChanged = null;
    @Inject
    MapsAppState state;
    @Inject
    apc registration;
    @Inject
    aoz maps;
    @Inject
    ate notifications;
    @Inject
    asy dialogService;

    @Override
    public void initializeFx() {
        ast ast2 = MapsCss.createEndEffectorAxes3d();
        ast ast3 = new ast(new Node[0]);
        ast ast4 = new ast(new Node[]{ast2, ast3});
        new asv(new Node[]{ast4, asq.a.a()}).a((Pane)this.pane3d);
        this.hasScrollContentChanged = baq.a(this.waypointScrollPane);
        this.maps.c(bcu2 -> {
            if (!this.state.isOnView(MapsAppState$View.Registration)) {
                return;
            }
            ast2.b((bcu)bcu2);
            if (this.registration.b.isEmpty()) {
                ast4.setTranslateX(anw.a.g(-bcu2.dY));
                ast4.setTranslateY(anw.a.g(-bcu2.ea));
                ast4.setTranslateZ(anw.a.g(-bcu2.ee));
            }
        });
        Stack stack = new Stack();
        this.addWaypointBtn.setOnAction(actionEvent -> {
            this.registration.a(this.maps.b);
            stack.empty();
        });
        bab.a((Node)this.addWaypointBtn, bab.h, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> {
            if (azx.a((Node)this.addWaypointBtn)) {
                this.registration.a(this.maps.b);
                stack.empty();
                keyEvent.consume();
            }
        }));
        this.deletePrevBtn.setOnAction(actionEvent -> stack.push(this.registration.a()));
        bab.a((Node)this.deletePrevBtn, bab.j, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> {
            if (!this.registration.b.isEmpty() && azx.a((Node)this.deletePrevBtn)) {
                stack.push(this.registration.a());
                keyEvent.consume();
            }
        }));
        bab.a((Node)this.deletePrevBtn, bab.i, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> {
            if (!stack.isEmpty() && azx.a((Node)this.addWaypointBtn)) {
                this.registration.a((bcu)stack.pop());
                keyEvent.consume();
            }
        }));
        bab.a((Node)this.addRowBtn, bab.d, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> {
            if (azx.a((Node)this.addRowBtn)) {
                this.registration.aY();
            }
        }));
        this.clearBtn.disableProperty().bind((ObservableValue)this.registration.a.isEqualTo(0));
        this.clearBtn.setOnAction(actionEvent -> {
            if (this.notifications.k("Are you sure that you want to delete all existing points?")) {
                this.registration.aX();
                stack.empty();
            }
        });
        this.addRowBtn.visibleProperty().bind((ObservableValue)this.registration.a.not().and((ObservableBooleanValue)this.registration.a.greaterThanOrEqualTo(3)));
        this.addRowBtn.setOnAction(actionEvent -> this.registration.aY());
        BooleanProperty booleanProperty = this.registration.g;
        this.createSurfaceBtn.disableProperty().bind((ObservableValue)booleanProperty.not());
        this.createSurfaceBtn.setOnAction(actionEvent -> this.maps.a(this.registration.a(new apb(0, 0))).thenRun(() -> this.state.nextView((ActionEvent)actionEvent)));
        this.backBtn.setOnAction(this.state::previousView);
        booleanProperty.addListener((observableValue, bl2, bl3) -> this.createSurfaceBtn.pseudoClassStateChanged(MapsCss.HIGHLIGHTED, bl3.booleanValue()));
        this.registration.b.addListener(observable -> {
            ast3.getChildren().setAll(this.registration.a(true));
            apc apc2 = this.registration;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            for (bcu bcu2 : apc2.b) {
                d2 += bcu2.dY;
                d3 += bcu2.ea;
                d4 += bcu2.ee;
            }
            double d5 = anw.a.g(1.0 / (double)apc2.b.size());
            azx.a((Node)ast4, new Point3D(d2 * d5, d3 * d5, d4 * d5));
            this.updateGrid();
        });
        this.registration.b.addListener((observableValue, number, number2) -> this.updateGrid());
        this.updateGrid();
        this.wizardFlatBtn.setOnAction(actionEvent -> this.dialogService.a((Parent)this.flatWizard, this.flatWizardController.getCloseButton()));
        this.wizardElbowBtn.setOnAction(actionEvent -> this.dialogService.a((Parent)this.elbowWizard, this.elbowWizardController.getCloseButton()));
        this.loadFileBtn.visibleProperty().bind((ObservableValue)this.state.enableMapRequestProperty());
        this.loadFileBtn.managedProperty().bind((ObservableValue)this.loadFileBtn.visibleProperty());
        this.loadFileBtn.setOnAction(actionEvent -> {
            Window window = azx.a(actionEvent);
            avk avk2 = b.b(avk.class);
            avk2.a(avk2.h, "lastJsonChoiceDirectory");
            avk avk3 = avk2;
            Optional.ofNullable(avk3.b(avk3.h.showOpenDialog(window), "lastJsonChoiceDirectory")).ifPresent(file -> {
                try {
                    apb apb2 = aoz.a(bku.a((bzz)bzz.a((String)Files.readString((Path)file.toPath()))).a.a.a());
                    this.registration.aX();
                    this.registration.a(apb2);
                    return;
                }
                catch (Throwable throwable) {
                    this.notifications.f(throwable);
                    return;
                }
            });
        });
    }

    private void updateGrid() {
        int n2;
        MeshView meshView = this.registration.b;
        ArrayList<Button> arrayList = new ArrayList<Button>();
        for (n2 = 0; n2 < meshView.size() - 1; ++n2) {
            arrayList.add(azx.a(new JFXButton(String.valueOf(n2 + 1)), "reg-WaypointButton"));
        }
        if (!meshView.isEmpty()) {
            arrayList.add(this.deletePrevBtn);
        }
        arrayList.add(this.addWaypointBtn);
        n2 = arrayList.size();
        int n3 = this.registration.b.get();
        if (n3 == -1) {
            n3 = n2;
        }
        int n4 = (int)Math.ceil((double)n2 / (double)n3);
        this.waypointList.getChildren().clear();
        int n5 = 0;
        for (int i2 = 0; i2 < n4 && n5 < n2; ++i2) {
            HBox hBox = azx.a(new HBox(), "reg-hlist");
            if (i2 % 2 != 0) {
                hBox.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
            }
            for (int i3 = 0; i3 < n3 && n5 < n2; ++i3, ++n5) {
                hBox.getChildren().add((Object)((Node)arrayList.get(n5)));
            }
            this.waypointList.getChildren().add((Object)hBox);
        }
        this.hasScrollContentChanged.set(true);
    }

    @Generated
    public MapsAppState getState() {
        return this.state;
    }
}

