/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.state;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.spi.CategoryAxis;
import io.fair_acc.chartfx.plugins.AbstractSingleValueIndicator;
import io.fair_acc.chartfx.renderer.LineStyle;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.BasicDataSetRenderer;
import io.fair_acc.chartfx.renderer.spi.ErrorDataSetRenderer;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.spi.AbstractDataSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import lombok.Generated;
import org.HdrHistogram.PackedDoubleHistogram;
import us.hebi.gui.lib.aa;
import us.hebi.gui.lib.awc;
import us.hebi.gui.lib.awh;
import us.hebi.gui.lib.awj;
import us.hebi.gui.lib.awv;
import us.hebi.gui.lib.axa;
import us.hebi.gui.lib.axg;
import us.hebi.gui.lib.axp;
import us.hebi.gui.lib.bbd;
import us.hebi.gui.lib.bbe;
import us.hebi.gui.lib.bbf;
import us.hebi.gui.lib.bbg;
import us.hebi.gui.lib.can;
import us.hebi.gui.lib.jc;
import us.hebi.gui.lib.jh;
import us.hebi.gui.views.logviewer.state.ChartCategory;
import us.hebi.gui.views.logviewer.state.NamedChart;
import us.hebi.gui.views.logviewer.state.VisibilityState;

public class ChartList {
    final XYChart sharedTimeChart;
    DoubleProperty indicatorTime;
    jh time;
    axp traceType;
    PackedDoubleHistogram tmpHistogram;
    jh tmpSortValues;
    private static final boolean DISABLE_USER_RANGE = true;
    final List<NamedChart> charts;
    public final VisibilityState visibilityState;

    public ChartList() {
        XYChart xYChart = awh.a(0.0, 0.0, "");
        awj awj2 = new awj(xYChart.getXAxis(), "", xYChart);
        xYChart.getPlugins().add((Object)awj2);
        this.sharedTimeChart = xYChart;
        this.indicatorTime = awh.a((Chart)this.sharedTimeChart).map(AbstractSingleValueIndicator::valueProperty).orElseThrow();
        this.traceType = axp.a;
        this.tmpHistogram = new PackedDoubleHistogram(2);
        this.tmpSortValues = new jh(0);
        this.charts = new ArrayList<NamedChart>();
        this.visibilityState = new VisibilityState();
    }

    public ChartList clear() {
        this.charts.clear();
        return this;
    }

    public ChartList addXyzCommandChart(Supplier<String> supplier, String string, String string2, double d2, double d3, jh[] jhArray, jh[] jhArray2) {
        axp axp2 = this.traceType;
        try {
            this.setTraceType(axp.a);
            ChartList chartList = this;
            Renderer renderer = chartList.toXyzRenderer(n2 -> this.time, jhArray2);
            this.setTraceType(axp.b);
            ChartList chartList2 = this;
            Renderer renderer2 = chartList2.toXyzRenderer(n2 -> this.time, jhArray).setShowInLegend(false);
            for (int i2 = 0; i2 < jhArray.length; ++i2) {
                DataSetNode dataSetNode = (DataSetNode)renderer.getDatasetNodes().get(i2);
                ((DataSetNode)renderer2.getDatasetNodes().get(i2)).visibleProperty().bind((ObservableValue)dataSetNode.visibleProperty());
            }
            ChartList chartList3 = this;
            ChartList chartList4 = chartList3.addChart(chartList3.newTimeChart(supplier, this::applyXyzVisibility, string, string2, d2, d3, renderer, renderer2));
            return chartList4;
        }
        finally {
            this.setTraceType(axp2);
        }
    }

    public ChartList addXyzErrorChart(Supplier<String> supplier, String string, String string2, double d2, double d3, jh[] jhArray, jh[] jhArray2) {
        aa.a(this.time, (Object)"time must be set");
        Renderer renderer = awh.a();
        for (int i2 = 0; i2 < jhArray2.length; ++i2) {
            renderer.getDatasets().add((Object)new awv("", this.time, jhArray[i2], jhArray2[i2]).addStyleClasses(new String[]{this.traceType.F(), awc.a(i2)}));
        }
        ChartList chartList = this;
        return chartList.addChart(chartList.newTimeChart(supplier, this::applyXyzVisibility, string, string2, d2, d3, renderer));
    }

    public ChartList addXyzChart(Supplier<String> supplier, String string, String string2, double d2, double d3, jh[] jhArray) {
        ChartList chartList = this;
        Renderer[] rendererArray = new Renderer[1];
        ChartList chartList2 = this;
        rendererArray[0] = chartList2.toXyzRenderer(n2 -> this.time, jhArray);
        return chartList.addChart(chartList.newTimeChart(supplier, this::applyXyzVisibility, string, string2, d2, d3, rendererArray));
    }

    public ChartList addCommandChart(Supplier<String> supplier, String string, String string2, double d2, double d3, jh[] jhArray, jh[] jhArray2) {
        axp axp2 = this.traceType;
        try {
            this.setTraceType(axp.a);
            Renderer renderer = this.toDeviceRenderer(jhArray2);
            this.setTraceType(axp.b);
            Renderer renderer2 = this.toDeviceRenderer(jhArray).setShowInLegend(false);
            for (int i2 = 0; i2 < jhArray.length; ++i2) {
                DataSetNode dataSetNode = (DataSetNode)renderer.getDatasetNodes().get(i2);
                dataSetNode.getStyleClass().add((Object)"feedback");
                DataSetNode dataSetNode2 = (DataSetNode)renderer2.getDatasetNodes().get(i2);
                dataSetNode2.getStyleClass().add((Object)"command");
                dataSetNode2.visibleProperty().bind((ObservableValue)dataSetNode.visibleProperty());
            }
            ChartList chartList = this;
            ChartList chartList2 = chartList.addChart(chartList.newTimeChart(supplier, this::applyDeviceVisibility, string, string2, d2, d3, renderer, renderer2));
            return chartList2;
        }
        finally {
            this.setTraceType(axp2);
        }
    }

    public ChartList addPhaseChart(Supplier<String> supplier, String string, String string2, double d2, double d3, jh[] jhArray, jh[] jhArray2, jh[] jhArray3) {
        ChartList chartList = this;
        Renderer renderer = chartList.toDeviceRenderer((int n2) -> this.time, jhArray);
        ChartList chartList2 = this;
        Renderer renderer2 = chartList2.toDeviceRenderer((int n2) -> this.time, jhArray2).setShowInLegend(false);
        ChartList chartList3 = this;
        Renderer renderer3 = chartList3.toDeviceRenderer((int n2) -> this.time, jhArray3).setShowInLegend(false);
        for (int i2 = 0; i2 < jhArray.length; ++i2) {
            DataSetNode dataSetNode = (DataSetNode)renderer.getDatasetNodes().get(i2);
            DataSetNode dataSetNode2 = (DataSetNode)renderer2.getDatasetNodes().get(i2);
            DataSetNode dataSetNode3 = (DataSetNode)renderer3.getDatasetNodes().get(i2);
            dataSetNode2.visibleProperty().bind((ObservableValue)dataSetNode.visibleProperty());
            dataSetNode3.visibleProperty().bind((ObservableValue)dataSetNode.visibleProperty());
        }
        ChartList chartList4 = this;
        return chartList4.addChart(chartList4.newTimeChart(supplier, this::applyDeviceVisibility, string, string2, d2, d3, renderer, renderer2, renderer3));
    }

    public ChartList addQuaternionTraces(Supplier<String> supplier, String string, jh[] jhArray) {
        return this.addTimeTraces(supplier, string, "quaternion", -1.0, 1.0, jhArray, (Renderer renderer) -> {
            ChartList.updateDataSet(renderer, 0, "W", "color-primary");
            ChartList.updateDataSet(renderer, 1, "X", "color-red");
            ChartList.updateDataSet(renderer, 2, "Y", "color-green");
            ChartList.updateDataSet(renderer, 3, "Z", "color-blue");
        });
    }

    private static void updateDataSet(Renderer renderer, int n2, String string, String ... stringArray) {
        DataSetNode dataSetNode = (DataSetNode)renderer.getDatasetNodes().get(n2);
        ((AbstractDataSet)dataSetNode.getDataSet()).setName(string);
        dataSetNode.getStyleClass().addAll((Object[])stringArray);
    }

    public ChartList addErrorChart(Supplier<String> supplier, String string, String string2, double d2, double d3, jh[] jhArray, jh[] jhArray2) {
        aa.a(this.time, (Object)"time must be set");
        Renderer renderer = awh.a();
        for (int i2 = 0; i2 < jhArray2.length; ++i2) {
            renderer.addDataSet(new awv("", this.time, jhArray[i2], jhArray2[i2]).addStyleClasses(new String[]{"error", this.traceType.F()}));
        }
        ChartList chartList = this;
        return chartList.addChart(chartList.newTimeChart(supplier, this::applyDeviceVisibility, string, string2, d2, d3, renderer));
    }

    public ChartList addDeviceChart(Supplier<String> supplier, String string, String string2, double d2, double d3, jh[] jhArray) {
        ChartList chartList = this;
        return chartList.addChart(chartList.newTimeChart(supplier, this::applyDeviceVisibility, string, string2, d2, d3, this.toDeviceRenderer(jhArray)));
    }

    public ChartList addDeviceXY(Supplier<String> supplier, String string, Axis axis, jh[] jhArray, Axis axis2, jh[] jhArray2) {
        XYChart xYChart = awh.a(new XYChart(axis, axis2));
        Renderer renderer = this.toDeviceRenderer((int n2) -> jhArray[n2], jhArray2);
        return this.addChart(new bbd(this, supplier, string, xYChart, renderer));
    }

    public void applyDeviceVisibility(Renderer renderer) {
        int n2 = 0;
        for (DataSetNode dataSetNode : renderer.getDatasetNodes()) {
            ((AbstractDataSet)dataSetNode.getDataSet()).setName(this.visibilityState.getDeviceName(n2));
            BooleanProperty booleanProperty = this.visibilityState.deviceVisibilityProperty(n2);
            booleanProperty.unbind();
            dataSetNode.setVisible(booleanProperty.get());
            booleanProperty.bind((ObservableValue)dataSetNode.visibleProperty());
            ++n2;
        }
    }

    private void applyXyzVisibility(Renderer renderer) {
        int n2 = 0;
        for (DataSetNode dataSetNode : renderer.getDatasetNodes()) {
            ((AbstractDataSet)dataSetNode.getDataSet()).setName(this.visibilityState.getXyzName(n2));
            BooleanProperty booleanProperty = this.visibilityState.xyzVisibilityProperty(n2);
            booleanProperty.unbind();
            dataSetNode.setVisible(booleanProperty.get());
            booleanProperty.bind((ObservableValue)dataSetNode.visibleProperty());
            ++n2;
        }
    }

    public ChartList addSingleTrace(Supplier<String> supplier, String string, String string2, double d2, double d3, jh jh2) {
        return this.addTimeTraces(supplier, string, string2, d2, d3, jh2, (Renderer renderer) -> awh.a(renderer, 0, string, new String[0]));
    }

    public ChartList addStandaloneTimeTrace(Supplier<String> supplier, String string, jh jh2, jh jh3) {
        XYChart xYChart = awh.a(Double.NaN, Double.NaN, null);
        Consumer<Renderer> consumer = renderer -> {};
        DataSet[] dataSetArray = new DataSet[1];
        dataSetArray[0] = new axg(string, jh2::size, jh2::a, jh3::a);
        BasicDataSetRenderer basicDataSetRenderer = new BasicDataSetRenderer(dataSetArray);
        return this.addChart(ChartList.newChart(xYChart, supplier, consumer, string, null, Double.NaN, Double.NaN, basicDataSetRenderer));
    }

    public ChartList addCombinedUserStates(Supplier<String> supplier, String string, jh[] jhArray) {
        XYChart xYChart = awh.a(Double.NaN, Double.NaN, null);
        Consumer<Renderer> consumer = renderer -> {};
        BasicDataSetRenderer basicDataSetRenderer = new BasicDataSetRenderer(new DataSet[0]);
        for (int i2 = 1; i2 < jhArray.length; ++i2) {
            jh jh2 = jhArray[0];
            jh jh3 = jhArray[i2];
            basicDataSetRenderer.addDataSet(new axg("State " + i2, jh2::size, jh2::a, jh3::a));
        }
        return this.addChart(ChartList.newChart(xYChart, supplier, consumer, string, null, Double.NaN, Double.NaN, basicDataSetRenderer));
    }

    public ChartList addTimeTraces(Supplier<String> supplier, String string, String string2, double d2, double d3, jh jh2, Consumer<Renderer> consumer) {
        ChartList chartList = this;
        return chartList.addChart(chartList.newTimeChart(supplier, consumer, string, string2, d2, d3, this.toDeviceRenderer(jh2)));
    }

    public ChartList addTimeTraces(Supplier<String> supplier, String string, String string2, double d2, double d3, jh[] jhArray, Consumer<Renderer> consumer) {
        ChartList chartList = this;
        return chartList.addChart(chartList.newTimeChart(supplier, consumer, string, string2, d2, d3, this.toDeviceRenderer(jhArray)));
    }

    public ChartList addMedianBarChart(Supplier<String> supplier, String string, Axis axis, jh[] jhArray) {
        double[] dArray = Stream.of(jhArray).mapToDouble(this::getMedian).toArray();
        return this.addIndexBarChart(supplier, string, axis, n2 -> dArray[n2], jhArray.length);
    }

    private double getMedian(jh jh2) {
        if (jh2.size() == 0) {
            return Double.NaN;
        }
        jh jh3 = this.tmpSortValues;
        this.tmpSortValues.M = 0;
        jh jh4 = jh2;
        jh jh5 = this.tmpSortValues;
        boolean bl2 = false;
        jc jc2 = jh4.a();
        while (jc2.hasNext()) {
            double d2 = jc2.b();
            jh5.d(d2);
            bl2 = true;
        }
        jh5 = this.tmpSortValues;
        Arrays.sort(jh5.b, 0, jh5.M);
        return this.tmpSortValues.a(this.tmpSortValues.size() / 2);
    }

    public ChartList addIndexBarChart(Supplier<String> supplier, String string, Axis axis, IntToDoubleFunction intToDoubleFunction, int n3) {
        if (n3 <= 1) {
            return this;
        }
        ObservableList observableList = FXCollections.observableArrayList();
        for (int i2 = 0; i2 < n3; ++i2) {
            observableList.add((Object)String.valueOf(i2 + 1));
        }
        CategoryAxis categoryAxis = new CategoryAxis("Index", (ObservableList<String>)observableList);
        categoryAxis.setUnit(null);
        XYChart xYChart = awh.a(new XYChart(categoryAxis, axis));
        xYChart.setLegendVisible(false);
        ErrorDataSetRenderer errorDataSetRenderer = new ErrorDataSetRenderer();
        errorDataSetRenderer.setPolyLineStyle(LineStyle.HISTOGRAM_FILLED);
        xYChart.getRenderers().setAll((Object[])new Renderer[]{errorDataSetRenderer});
        errorDataSetRenderer.addDataSet(new axg(string, () -> n3, n2 -> n2, intToDoubleFunction));
        xYChart.getGridRenderer().getHorizontalMajorGrid().visibleProperty().set(false);
        xYChart.getGridRenderer().getVerticalMajorGrid().visibleProperty().set(true);
        return this.addCustomChart(supplier, string, visibilityState -> xYChart);
    }

    public ChartList addAsHistogram(Supplier<String> supplier, String string, String string2, jh[] jhArray) {
        return this.addAsHistogram(supplier, string, string2, jhArray, this::applyDeviceVisibility);
    }

    public ChartList addAsHistogram(Supplier<String> supplier, String string, String string2, jh[] jhArray, Consumer<Renderer> consumer) {
        Renderer renderer = awh.a();
        for (int i2 = 0; i2 < jhArray.length; ++i2) {
            renderer.getDatasets().add((Object)axa.a(jhArray[i2], this.tmpHistogram).addStyleClasses(new String[]{"trace-solid"}));
        }
        ChartList chartList = this;
        return chartList.addChart(chartList.newPercentileChart(supplier, consumer, string, string2, Double.NaN, Double.NaN, renderer));
    }

    private Renderer toDeviceRenderer(jh ... jhArray) {
        aa.a(this.time, (Object)"time must be set");
        ChartList chartList = this;
        return chartList.toDeviceRenderer((int n2) -> this.time, jhArray);
    }

    private Renderer toDeviceRenderer(IntFunction<jh> intFunction, jh[] jhArray) {
        Renderer renderer = awh.a();
        for (int i2 = 0; i2 < jhArray.length; ++i2) {
            renderer.getDatasets().add((Object)new axg("", intFunction.apply(i2), jhArray[i2]).addStyleClasses(new String[]{this.traceType.F()}));
        }
        return renderer;
    }

    private Renderer toXyzRenderer(IntFunction<jh> intFunction, jh[] jhArray) {
        aa.a(jhArray.length == 3, (Object)"Expected xyz data");
        Renderer renderer = awh.a();
        for (int i2 = 0; i2 < jhArray.length; ++i2) {
            renderer.getDatasets().add((Object)new axg("", intFunction.apply(i2), jhArray[i2]).addStyleClasses(new String[]{awc.a(i2), this.traceType.F()}));
        }
        return renderer;
    }

    public ChartList setTraceType(axp axp2) {
        this.traceType = aa.b(axp2);
        return this;
    }

    public ChartList setTime(jh jh2) {
        this.time = jh2;
        return this;
    }

    public List<TreeItem<NamedChart>> createHierarchy() {
        Stream<String> stream = Stream.of(ChartCategory.values()).map(ChartCategory::get);
        Stream<String> stream2 = this.charts.stream().map(NamedChart::getCategory);
        return Stream.concat(stream, stream2).distinct().map(this::newCategory).filter(treeItem -> treeItem.getChildren().size() > 0).toList();
    }

    private TreeItem<NamedChart> newCategory(String string) {
        TreeItem treeItem = new TreeItem((Object)new bbe(string));
        treeItem.setExpanded(true);
        this.charts.stream().filter(namedChart -> can.a(string, namedChart.getCategory())).forEach(namedChart -> treeItem.getChildren().add((Object)new TreeItem(namedChart)));
        return treeItem;
    }

    public List<NamedChart> getCharts() {
        return this.charts;
    }

    public ChartList addChart(NamedChart namedChart) {
        this.charts.add(namedChart);
        return this;
    }

    public ChartList addCustomChart(Supplier<String> supplier, String string, Function<VisibilityState, Chart> function) {
        return this.addChart(new bbf(this, supplier, string, function));
    }

    private NamedChart newTimeChart(Supplier<String> supplier, Consumer<Renderer> consumer, String string, String string2, double d2, double d3, Renderer ... rendererArray) {
        if (this.isUserRangeDisabled(supplier, string)) {
            d3 = Double.NaN;
            d2 = Double.NaN;
        }
        return ChartList.newChart(this.sharedTimeChart != null ? this.sharedTimeChart : awh.a(d2, d3, string2), supplier, consumer, string, string2, d2, d3, rendererArray);
    }

    private NamedChart newPercentileChart(Supplier<String> supplier, Consumer<Renderer> consumer, String string, String string2, double d2, double d3, Renderer ... rendererArray) {
        if (this.isUserRangeDisabled(supplier, string)) {
            d3 = Double.NaN;
            d2 = Double.NaN;
        }
        return ChartList.newChart(awh.c(), supplier, consumer, string, string2, d2, d3, rendererArray);
    }

    private static NamedChart newChart(XYChart xYChart, Supplier<String> supplier, Consumer<Renderer> consumer, String string, String string2, double d2, double d3, Renderer ... rendererArray) {
        Renderer[] rendererArray2 = rendererArray;
        int n2 = rendererArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            rendererArray2[i2].getAxes().setAll(xYChart.getAxes());
        }
        return new bbg(supplier, string, xYChart, consumer, rendererArray, string2, d2, d3);
    }

    private boolean isUserRangeDisabled(Supplier<String> supplier, String string) {
        return supplier != ChartCategory.Network;
    }

    @Generated
    public DoubleProperty getIndicatorTime() {
        return this.indicatorTime;
    }

    @Generated
    public VisibilityState getVisibilityState() {
        return this.visibilityState;
    }
}

