/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.hebilog;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import us.hebi.gui.lib.aa;
import us.hebi.gui.lib.ano;
import us.hebi.gui.lib.anw;
import us.hebi.gui.lib.awh;
import us.hebi.gui.lib.axp;
import us.hebi.gui.lib.bcq;
import us.hebi.gui.lib.bcu;
import us.hebi.gui.lib.bcw;
import us.hebi.gui.lib.bcx;
import us.hebi.gui.lib.bcz;
import us.hebi.gui.lib.bda;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.bdf;
import us.hebi.gui.lib.beg;
import us.hebi.gui.lib.beh;
import us.hebi.gui.lib.bei;
import us.hebi.gui.lib.h;
import us.hebi.gui.lib.jh;
import us.hebi.gui.lib.jk;
import us.hebi.gui.lib.lu;
import us.hebi.gui.lib.um;
import us.hebi.gui.views.logviewer.hebilog.HebiLogFeedback;
import us.hebi.gui.views.logviewer.state.ChartCategory;
import us.hebi.gui.views.logviewer.state.ChartList;
import us.hebi.gui.views.logviewer.state.TDoubleArrayListRegistry;

public class XyzLogData {
    private bei treeFK;
    private beg FK;
    private beh numericalJacobian;
    private bdf staticConnections;
    private int numEntries = 0;
    private int numDevices = 0;
    private jh time;
    private jh[] position;
    private jh[] positionCmd;
    private jh[] velocity;
    private jh[] velocityCmd;
    private jh[] gyroX;
    private jh[] gyroY;
    private jh[] gyroZ;
    public jh[] centerOfMass;
    public jh[] xyzPosition;
    public jh[] xyzPositionCmd;
    public jh xyzPositionErrorMagnitude;
    public jh[] xyzVelocity;
    public jh[] xyzVelocityCmd;
    public jh xyzVelocityMagnitude;
    public jh xyzVelocityMagnitudeCmd;
    public jh[] imuVelocity;
    private double[] tmpPos;
    private double[] tmpPosCmd;
    private double[] tmpVel;
    private double[] tmpVelCmd;
    public static final ano SAME_INDEX = n2 -> n2;
    private ano indexMap = SAME_INDEX;
    static final double XYZ_SCALE = anw.a.g(1.0);

    public void setLogData(HebiLogFeedback hebiLogFeedback) {
        this.time = hebiLogFeedback.time;
        this.position = hebiLogFeedback.position;
        this.positionCmd = hebiLogFeedback.positionCmd;
        this.velocity = hebiLogFeedback.velocity;
        this.velocityCmd = hebiLogFeedback.velocityCmd;
        this.gyroX = hebiLogFeedback.gyroX;
        this.gyroY = hebiLogFeedback.gyroY;
        this.gyroZ = hebiLogFeedback.gyroZ;
        this.numEntries = hebiLogFeedback.time.size();
        this.numDevices = hebiLogFeedback.numJoints;
        this.update();
    }

    public void setKinematics(bdc bdc2, ano ano2) {
        this.treeFK = new bei(bdc2);
        bda bda2 = bdc2.a(true);
        this.FK = new beg(bda2);
        this.numericalJacobian = new beh(this.FK);
        bdc bdc3 = bdc2;
        bdf bdf2 = new bdf(bdc3.W());
        bcu bcu2 = bcu.c();
        jk jk2 = new jk(bdc3.V());
        for (int i2 = 0; i2 < bdc3.W(); ++i2) {
            jk2.clear();
            boolean bl2 = false;
            int n2 = bdc3.ag.indexOf(bdc3.I.get(i2));
            block1: for (int i3 = n2 + 1; i3 < bdc3.a.size() && !bl2; ++i3) {
                Object object;
                if (bdc3.a.k(i3) == n2) {
                    object = bdc3.ag.get(i3);
                    if (object instanceof bcz) {
                        bl2 = true;
                        bdf2.bh[i2] = bdc3.I.indexOf((bcz)object);
                    } else {
                        jk2.b(i3);
                        n2 = i3;
                    }
                }
                int n3 = i2;
                object = bdf2.a[n3];
                bcu2.b();
                int n4 = 0;
                while (true) {
                    jk jk3 = jk2;
                    if (n4 >= jk3.M) continue block1;
                    int n5 = jk2.k(n4);
                    bcu bcu3 = bdc3.ag.get(n5).g();
                    bcw.a(bcu2, bcu3, (bcu)object);
                    bcu2.c((bcu)object);
                    ++n4;
                }
            }
        }
        this.staticConnections = bdf2;
        this.indexMap = ano2 == null ? SAME_INDEX : ano2;
        this.update();
    }

    public boolean hasValidCombination() {
        return this.FK != null && this.numEntries > 0 && this.FK.d.numJoints == this.numDevices;
    }

    public void update() {
        if (!this.hasValidCombination()) {
            return;
        }
        this.resize();
        bcx bcx2 = bcx.d();
        bcx bcx3 = bcx.d();
        lu lu2 = new lu(0, 0);
        lu lu3 = new lu(0, 0);
        bcu bcu2 = bcu.c();
        bcq bcq2 = new bcq();
        for (int i2 = 0; i2 < this.numEntries; ++i2) {
            this.fillTmpArrays(i2);
            bcx bcx4 = bcx3;
            double[] dArray = this.tmpPos;
            this.treeFK.a(this.tmpPos).a(bcx4);
            bcx3.a(XYZ_SCALE);
            this.centerOfMass[0].d(bcx3.a1);
            this.centerOfMass[1].d(bcx3.a2);
            this.centerOfMass[2].d(bcx3.a3);
            this.FK.a(this.tmpPos, bcu2);
            this.xyzPosition[0].d(XYZ_SCALE * bcu2.dY);
            this.xyzPosition[1].d(XYZ_SCALE * bcu2.ea);
            this.xyzPosition[2].d(XYZ_SCALE * bcu2.ee);
            this.FK.a(this.tmpPosCmd, bcu2);
            this.xyzPositionCmd[0].d(XYZ_SCALE * bcu2.dY);
            this.xyzPositionCmd[1].d(XYZ_SCALE * bcu2.ea);
            this.xyzPositionCmd[2].d(XYZ_SCALE * bcu2.ee);
            double d2 = this.xyzPositionCmd[0].a(i2) - this.xyzPosition[0].a(i2);
            double d3 = this.xyzPositionCmd[1].a(i2) - this.xyzPosition[1].a(i2);
            double d4 = this.xyzPositionCmd[2].a(i2) - this.xyzPosition[2].a(i2);
            double d5 = d2;
            double d6 = d3;
            double d7 = d4;
            this.xyzPositionErrorMagnitude.d(Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7));
            this.numericalJacobian.a(this.tmpPos, bcq2);
            lu2.a(this.tmpVelCmd.length, 1, true, this.tmpVel);
            h.a(bcq2, lu2, lu3);
            double d8 = XYZ_SCALE * lu3.h[0];
            double d9 = XYZ_SCALE * lu3.h[1];
            double d10 = XYZ_SCALE * lu3.h[2];
            this.xyzVelocity[0].d(d8);
            this.xyzVelocity[1].d(d9);
            this.xyzVelocity[2].d(d10);
            double d11 = d8;
            double d12 = d9;
            double d13 = d10;
            this.xyzVelocityMagnitude.d(Math.sqrt(d11 * d11 + d12 * d12 + d13 * d13));
            this.numericalJacobian.a(this.tmpPosCmd, bcq2);
            lu2.a(this.tmpVelCmd.length, 1, true, this.tmpVelCmd);
            h.a(bcq2, lu2, lu3);
            d8 = XYZ_SCALE * lu3.h[0];
            d9 = XYZ_SCALE * lu3.h[1];
            d10 = XYZ_SCALE * lu3.h[2];
            this.xyzVelocityCmd[0].d(d8);
            this.xyzVelocityCmd[1].d(d9);
            this.xyzVelocityCmd[2].d(d10);
            double d14 = d8;
            double d15 = d9;
            double d16 = d10;
            this.xyzVelocityMagnitudeCmd.d(Math.sqrt(d14 * d14 + d15 * d15 + d16 * d16));
            for (int i3 = 0; i3 < this.numDevices; ++i3) {
                double d17 = Double.NaN;
                int n2 = i3;
                Object object = this.staticConnections;
                if (n2 < ((bdf)object).bh.length && ((bdf)object).bh[n2] >= 0) {
                    n2 = i3;
                    int n3 = this.staticConnections.bh[n2];
                    bcx2.a1 = this.gyroX[n3].a(i2);
                    bcx2.a2 = this.gyroY[n3].a(i2);
                    bcx2.a3 = this.gyroZ[n3].a(i2);
                    int n4 = i3;
                    bcx4 = bcx3;
                    bcx bcx5 = bcx2;
                    object = this.staticConnections.a[n4];
                    bcx4.a1 = ((bcu)object).u * bcx5.a1 + ((bcu)object).w * bcx5.a2 + ((bcu)object).eb * bcx5.a3;
                    bcx4.a2 = ((bcu)object).v * bcx5.a1 + ((bcu)object).x * bcx5.a2 + ((bcu)object).ec * bcx5.a3;
                    bcx4.a3 = ((bcu)object).dX * bcx5.a1 + ((bcu)object).dZ * bcx5.a2 + ((bcu)object).ed * bcx5.a3;
                    d17 = bcx3.a3 - this.gyroZ[i3].a(i2);
                }
                this.imuVelocity[i3].d(d17);
            }
        }
    }

    public void getCharts(ChartList chartList) {
        if (!this.hasValidCombination()) {
            return;
        }
        chartList.setTime(this.time).setTraceType(axp.a).addXyzCommandChart(ChartCategory.Cartesian, "Position", "mm", -50.0, 50.0, this.xyzPositionCmd, this.xyzPosition).addXyzErrorChart(ChartCategory.Cartesian, "Position Error", "mm", 0.0, 50.0, this.xyzPositionCmd, this.xyzPosition).addSingleTrace(ChartCategory.Cartesian, "Position Error Magnitude", "mm", 0.0, 10.0, this.xyzPositionErrorMagnitude).addXyzCommandChart(ChartCategory.Cartesian, "Velocity", "mm/s", -50.0, 50.0, this.xyzVelocityCmd, this.xyzVelocity).addXyzErrorChart(ChartCategory.Cartesian, "Velocity Error", "mm/s", 0.0, 50.0, this.xyzVelocityCmd, this.xyzVelocity).addTimeTraces((Supplier<String>)ChartCategory.Cartesian, "Velocity Magnitude", "mm/s", 0.0, 500.0, new jh[]{this.xyzVelocityMagnitudeCmd, this.xyzVelocityMagnitude}, renderer -> {
            awh.a(renderer, 0, "xyz velocity command", "trace-dashed", "color-primary-muted");
            awh.a(renderer, 1, "xyz velocity feedback", "trace-solid", "color-primary");
        }).addXyzChart(ChartCategory.Cartesian, "Center of Mass", "mm", -50.0, 50.0, this.centerOfMass).addCommandChart(ChartCategory.Encoders, "Velocity IMU", "rad/s", -5.0, 5.0, this.imuVelocity, this.velocity).addErrorChart(ChartCategory.Encoders, "Velocity IMU Error", "rad/s", 0.0, 0.05, this.imuVelocity, this.velocity);
    }

    public static ano createIndexMap(List<String> list, List<String> list2) {
        aa.a(list.size() == list2.size(), (Object)"source names do not match hrdf names");
        if (Objects.equals(list, list2)) {
            return SAME_INDEX;
        }
        ToIntFunction<String> toIntFunction = string -> {
            String string2 = string;
            if (h.b(string2).contains("*") || string2.contains("?")) {
                Pattern pattern = um.a(string, true);
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    if (!pattern.matcher((CharSequence)list.get(i2)).matches()) continue;
                    return i2;
                }
            } else {
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    if (!string.equalsIgnoreCase((String)list.get(i3))) continue;
                    return i3;
                }
            }
            throw new IllegalArgumentException("Source does not contain device name: " + string);
        };
        int n3 = list2.size();
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = toIntFunction.applyAsInt(list2.get(i2));
        }
        return n2 -> nArray[n2];
    }

    private void fillTmpArrays(int n2) {
        for (int i2 = 0; i2 < this.numDevices; ++i2) {
            int n3 = this.indexMap.apply(i2);
            this.tmpPos[i2] = this.position[n3].a(n2);
            this.tmpPosCmd[i2] = this.positionCmd[n3].a(n2);
            this.tmpVel[i2] = this.velocity[n3].a(n2);
            this.tmpVelCmd[i2] = this.velocityCmd[n3].a(n2);
        }
    }

    private void resize() {
        this.centerOfMass = TDoubleArrayListRegistry.resizeMultiple(this.centerOfMass, 3, this.numEntries);
        this.xyzPosition = TDoubleArrayListRegistry.resizeMultiple(this.xyzPosition, 3, this.numEntries);
        this.xyzPositionCmd = TDoubleArrayListRegistry.resizeMultiple(this.xyzPositionCmd, 3, this.numEntries);
        this.xyzPositionErrorMagnitude = TDoubleArrayListRegistry.resizeSingle(this.xyzPositionErrorMagnitude, this.numEntries);
        this.xyzVelocity = TDoubleArrayListRegistry.resizeMultiple(this.xyzVelocity, 3, this.numEntries);
        this.xyzVelocityCmd = TDoubleArrayListRegistry.resizeMultiple(this.xyzVelocityCmd, 3, this.numEntries);
        this.xyzVelocityMagnitude = TDoubleArrayListRegistry.resizeSingle(this.xyzVelocityMagnitude, this.numEntries);
        this.xyzVelocityMagnitudeCmd = TDoubleArrayListRegistry.resizeSingle(this.xyzVelocityMagnitudeCmd, this.numEntries);
        this.imuVelocity = TDoubleArrayListRegistry.resizeMultiple(this.imuVelocity, this.numDevices, this.numEntries);
        this.tmpPos = new double[this.position.length];
        this.tmpPosCmd = new double[this.position.length];
        this.tmpVel = new double[this.position.length];
        this.tmpVelCmd = new double[this.position.length];
    }
}

