/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.hebilog;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.application.Platform;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import lombok.Generated;
import us.hebi.gui.lib.aa;
import us.hebi.gui.lib.aab;
import us.hebi.gui.lib.acq;
import us.hebi.gui.lib.afy;
import us.hebi.gui.lib.ano;
import us.hebi.gui.lib.arq;
import us.hebi.gui.lib.arr;
import us.hebi.gui.lib.wv;
import us.hebi.gui.lib.wx;
import us.hebi.gui.views.logviewer.hebilog.GroupFeedbackHandler;
import us.hebi.gui.views.logviewer.hebilog.HebiLogAnalysis$BasicLogInfo;
import us.hebi.gui.views.logviewer.hebilog.HebiLogAnalysis$FeedbackSynchronizer;
import us.hebi.gui.views.logviewer.hebilog.HebiLogFeedback;
import us.hebi.gui.views.logviewer.hebilog.MobileIoFeedback;
import us.hebi.gui.views.logviewer.hebilog.XyzLogData;
import us.hebi.gui.views.logviewer.state.ChartList;
import us.hebi.gui.views.logviewer.state.NamedChart;

public class HebiLogContent {
    List<Optional<afy>> deviceInfos = Collections.emptyList();
    BooleanProperty hasInfo = new SimpleBooleanProperty(false);
    BooleanProperty loading = new SimpleBooleanProperty(false);
    final ChartList chartList = new ChartList();
    final HebiLogFeedback logFeedback = new HebiLogFeedback();
    final XyzLogData xyzLogData = new XyzLogData();
    final ObservableList<MobileIoFeedback> mobileIoList = FXCollections.observableArrayList();
    final arr logFile = new arr();
    final arq hrdfFile = new arq();
    acq robotConfig = null;

    public String getDeviceName(int n2) {
        return this.chartList.getVisibilityState().getDeviceName(n2);
    }

    public BooleanProperty hasInfoProperty() {
        return this.hasInfo;
    }

    public afy[] getInfo() {
        aa.a(this.hasInfo(), (Object)"Info not available");
        return (afy[])this.deviceInfos.stream().map(Optional::get).toArray(afy[]::new);
    }

    public Optional<List<String>> getNames() {
        if (!this.hasInfo()) {
            return Optional.empty();
        }
        return Optional.of(this.deviceInfos.stream().map(Optional::get).map(afy::getName).toList());
    }

    public int getNumJoints() {
        return this.deviceInfos.size();
    }

    public ReadOnlyBooleanProperty loadingProperty() {
        return this.loading;
    }

    public String getFileName() {
        return this.logFile.getFile().getName();
    }

    public File getFile() {
        return this.logFile.getFile();
    }

    public boolean hasValidFeedback() {
        return this.logFeedback.time != null && this.logFeedback.time.size() > 0;
    }

    public HebiLogFeedback getFeedback() {
        return this.logFeedback;
    }

    public XyzLogData getXyzData() {
        return this.xyzLogData;
    }

    public BooleanBinding hasValidHrdf() {
        return this.hrdfFile.cT;
    }

    public ObservableList<MobileIoFeedback> getMobileIoList() {
        return this.mobileIoList;
    }

    public HebiLogContent setLogFile(File file) {
        this.logFile.b(file);
        aa.a(this.logFile.w.get(), (Object)"Input file is not a valid .hebilog file");
        return this;
    }

    public HebiLogContent setRobotConfig(acq acq2) throws IOException {
        this.robotConfig = acq2;
        return this;
    }

    public HebiLogContent setHrdfFile(File file, ano ano2) {
        this.hrdfFile.b(file);
        aa.a(this.hrdfFile.cT.get(), (Object)"Input file is not a valid hrdf file");
        this.xyzLogData.setKinematics(this.hrdfFile.a().a(), ano2);
        return this;
    }

    public List<TreeItem<NamedChart>> createChartHierarchy() {
        this.chartList.clear();
        this.logFeedback.getCharts(this.chartList);
        this.xyzLogData.getCharts(this.chartList);
        Iterator iterator = this.mobileIoList.iterator();
        while (iterator.hasNext()) {
            ((MobileIoFeedback)iterator.next()).getCharts(this.chartList);
        }
        return this.chartList.createHierarchy();
    }

    public CompletableFuture<HebiLogContent> loadAsync() {
        this.hasInfo.set(false);
        this.loading.set(true);
        return CompletableFuture.supplyAsync(this::loadContents).thenApplyAsync(hebiLogContent -> {
            this.loading.set(false);
            this.hasInfo.set(this.hasInfo());
            return hebiLogContent;
        }, Platform::runLater);
    }

    private HebiLogContent loadContents() {
        block9: {
            if (this.logFile.w.get()) {
                try {
                    arr arr2 = this.logFile;
                    aa.b(arr2.w.get(), (Object)"file is not a valid .hebilog");
                    try (wx wx2 = wv.a(arr2.getFile());){
                        HebiLogAnalysis$BasicLogInfo hebiLogAnalysis$BasicLogInfo = wx2.a(new HebiLogAnalysis$BasicLogInfo());
                        int n2 = hebiLogAnalysis$BasicLogInfo.getNumDevices();
                        this.deviceInfos = IntStream.range(0, n2).mapToObj(hebiLogAnalysis$BasicLogInfo::getInfo).collect(Collectors.toList());
                        this.mobileIoList.clear();
                        for (int i2 = 0; i2 < n2; ++i2) {
                            this.chartList.getVisibilityState().deviceNameProperty(i2).set((Object)hebiLogAnalysis$BasicLogInfo.getName(i2));
                            if (!hebiLogAnalysis$BasicLogInfo.isMobileIO(i2)) continue;
                            this.mobileIoList.add((Object)new MobileIoFeedback().init(i2, hebiLogAnalysis$BasicLogInfo.getMinFeedbackCount()));
                        }
                        this.logFeedback.init(hebiLogAnalysis$BasicLogInfo.getNumDevices(), hebiLogAnalysis$BasicLogInfo.getMinFeedbackCount(), hebiLogAnalysis$BasicLogInfo.numUserStateEntries);
                        wx2.a(new HebiLogAnalysis$FeedbackSynchronizer().addHandler(this.logFeedback).addHandlers((Collection<? extends GroupFeedbackHandler>)this.mobileIoList));
                        this.xyzLogData.setLogData(this.logFeedback);
                        break block9;
                    }
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Error reading input log.", iOException);
                }
            }
            throw new IllegalArgumentException("Input file does not have a supported log format");
        }
        return this;
    }

    private boolean hasInfo() {
        return this.deviceInfos.stream().allMatch(Optional::isPresent);
    }

    public Optional<acq> getRobotConfig() {
        return Optional.ofNullable(this.robotConfig);
    }

    public ano getIndexMap() {
        Optional<List<String>> optional = this.getNames();
        Optional<List> optional2 = this.getRobotConfig().map(acq::getNames);
        if (optional.isEmpty() || optional2.isEmpty()) {
            return XyzLogData.SAME_INDEX;
        }
        return XyzLogData.createIndexMap(optional.get(), optional2.get());
    }

    public aab getXmlContent() {
        return this.hrdfFile.getXmlContent();
    }

    @Generated
    public ChartList getChartList() {
        return this.chartList;
    }
}

