/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.custom;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.utils.DataSetStyleBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import us.hebi.core.messages.flat.FlatFeedback;
import us.hebi.gui.lib.aem;
import us.hebi.gui.lib.afy;
import us.hebi.gui.lib.aky;
import us.hebi.gui.lib.awh;
import us.hebi.gui.lib.axg;
import us.hebi.gui.lib.axv;
import us.hebi.gui.lib.axw;
import us.hebi.gui.lib.axx;
import us.hebi.gui.lib.bbb;
import us.hebi.gui.lib.jh;

public class DeviceData {
    final aem deviceAddress;
    String family;
    String name;
    final jh time = new jh();
    final List<axw> xmlCharts;
    final HashMap<String, bbb> expressionMap = new HashMap();
    final List<bbb> traceValues;
    private boolean hasInfo = false;
    private final aky info = new aky();
    private List<List<DataSet>> allChartTraces = Collections.emptyList();

    public DeviceData(aem aem2, List<axw> list, int n2) {
        this.xmlCharts = list;
        this.deviceAddress = aem2;
        for (axw axw2 : list) {
            for (axx axx2 : axw2.getTraces()) {
                if (this.expressionMap.containsKey(axx2.getValue())) continue;
                this.expressionMap.put(axx2.getValue(), new bbb(axx2.getFunc(), new jh(n2)));
            }
            axv axv2 = axw2.getAxisX();
            if (axv2 == null || this.expressionMap.containsKey(axv2.getExpression())) continue;
            this.expressionMap.put(axv2.getExpression(), new bbb(axv2.getFunc(), new jh(n2)));
        }
        this.traceValues = List.copyOf(this.expressionMap.values());
    }

    public boolean hasInfo() {
        return this.hasInfo;
    }

    public afy getInfo() {
        return this.info;
    }

    public void addInfo(afy afy2) {
        this.family = afy2.getFamily();
        this.name = afy2.getName();
        this.info.a(afy2);
        this.hasInfo = true;
    }

    public void addFeedback(double d2, FlatFeedback flatFeedback, FlatFeedback flatFeedback2) {
        this.time.d(d2);
        Iterator<bbb> iterator = this.traceValues.iterator();
        while (iterator.hasNext()) {
            FlatFeedback flatFeedback3 = flatFeedback2;
            FlatFeedback flatFeedback4 = flatFeedback;
            bbb bbb2 = iterator.next();
            bbb2.d.d(bbb2.a.computeValue(flatFeedback4, flatFeedback3));
        }
    }

    public void convertToDataSets() {
        double[] dArray = DeviceData.toArrayAndReset(this.time);
        this.allChartTraces = new ArrayList<List<DataSet>>(this.xmlCharts.size());
        for (int i2 = 0; i2 < this.xmlCharts.size(); ++i2) {
            axw axw2 = this.xmlCharts.get(i2);
            int n2 = axw2.getTraces().size();
            ArrayList<axg> arrayList = new ArrayList<axg>(n2);
            for (int i3 = 0; i3 < n2; ++i3) {
                axx axx2 = axw2.getTraces().get(i3);
                double[] dArray2 = axw2.getAxisX() == null ? dArray : this.getValues(axw2.getAxisX().getExpression());
                double[] dArray3 = this.getValues(axx2.getValue());
                String string = axx2.getLabel() + "[" + axx2.getUnits() + "]";
                axg axg2 = new axg(string, dArray2, dArray3);
                axg2.addStyleClasses(new String[]{axx2.getStyle().F()});
                axg2.setStyle(DataSetStyleBuilder.instance().setDatasetColor(awh.a(axx2.getColor())).build());
                arrayList.add(axg2);
            }
            this.allChartTraces.add(arrayList);
        }
    }

    public List<DataSet> getDataSets(int n2) {
        return this.allChartTraces.get(n2);
    }

    static double[] toArrayAndReset(jh jh2) {
        try {
            double[] dArray = jh2.a();
            return dArray;
        }
        finally {
            jh2.F();
        }
    }

    private double[] getValues(String string) {
        bbb bbb2 = this.expressionMap.get(string);
        if (bbb2.F == null) {
            bbb2.F = DeviceData.toArrayAndReset(bbb2.d);
        }
        return bbb2.F;
    }

    public String toString() {
        if (this.family != null || this.name != null) {
            return this.family + " | " + this.name;
        }
        return String.valueOf(this.deviceAddress).substring(1);
    }
}

