/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.lib;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.xml.bind.JAXBException;
import picocli.CommandLine;
import us.hebi.gui.lib.adj;
import us.hebi.gui.lib.aej;
import us.hebi.gui.lib.aem;
import us.hebi.gui.lib.amn;
import us.hebi.gui.lib.amx;
import us.hebi.gui.lib.ayj;
import us.hebi.gui.lib.ayv;
import us.hebi.gui.lib.ayw;
import us.hebi.gui.lib.bsj;
import us.hebi.gui.lib.bzd;
import us.hebi.gui.lib.cav;
import us.hebi.gui.lib.cbb;
import us.hebi.gui.lib.h;
import us.hebi.gui.lib.vg;

@CommandLine.Command(name="hebi-config", mixinStandardHelpOptions=true, versionProvider=ayj.class, description={"Sends configuration options to HEBI devices."})
public abstract class ayi
implements Callable<Integer> {
    @CommandLine.Option(names={"-ip", "--ip-address"}, description={"IP address of the target device, e.g., 10.11.12.13. May occur more than once."}, split=",")
    private String[] ipAddresses;
    @CommandLine.Option(names={"-mac", "--mac-address"}, description={"MAC address of the target device(s). May occur more than once"}, split=",")
    private String[] macAddresses;
    @CommandLine.Option(names={"-serial", "--serial-number"}, description={"Serial number of the target device(s). May occur more than once"}, split=",")
    private String[] serialNumbers;
    @CommandLine.Option(names={"-f", "--family"}, description={"Family of the target device(s). Defaults to '*'."})
    private String family = "*";
    @CommandLine.Option(names={"-n", "--name", "--names"}, description={"Names of the target device(s). May occur more than once"}, split=",")
    private String[] names;
    @CommandLine.Option(names={"--verbose"}, description={"Prints verbose information."})
    protected boolean verbose;
    @CommandLine.Option(names={"--debug"}, description={"Prints debug information."})
    protected boolean debug;
    @CommandLine.Option(names={"--dry-run"}, description={"Prints the outgoing message without sending it."})
    protected boolean dryRun;
    @CommandLine.Option(names={"--reset"}, description={"Commands the devices to reset. Can not be combined with other commands"})
    private boolean reset;
    private List<aem> h;

    protected final List<aem> c() throws ayv {
        String[] stringArray;
        String[] stringArray2;
        if (this.h != null) {
            return this.h;
        }
        if (this.debug) {
            System.out.println("====== devices ======");
            System.out.println("macAddresses = " + Arrays.toString(this.macAddresses));
            System.out.println("serialNumbers = " + Arrays.toString(this.serialNumbers));
            System.out.println("family = " + this.family);
            System.out.println("names = " + Arrays.toString(this.names));
            System.out.println("ipAddresses = " + Arrays.toString(this.ipAddresses));
            System.out.println("=====================");
        }
        ArrayList<aem> arrayList = new ArrayList<aem>();
        if (this.macAddresses != null || this.serialNumbers != null || this.names != null) {
            String string;
            int n2;
            int n3;
            stringArray2 = bzd.e();
            if (this.verbose) {
                System.out.println("Found broadcast interfaces: " + String.valueOf(stringArray2.stream().map(InetAddress::getHostAddress).toList()));
            }
            System.out.println("Running lookup...");
            vg vg2 = vg.a();
            vg2.setAddresses((List<InetAddress>)stringArray2);
            vg2.start();
            for (int i2 = 0; i2 < 10; ++i2) {
                vg2.requestInfo();
                amx.b(100L, TimeUnit.MILLISECONDS);
            }
            vg2.requestInfo();
            adj adj2 = vg2.a;
            if (this.macAddresses != null) {
                if (this.verbose) {
                    System.out.println("Looking for mac addresses: " + Arrays.toString(this.macAddresses));
                }
                stringArray = this.macAddresses;
                n3 = this.macAddresses.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    string = stringArray[n2];
                    arrayList.add(adj2.a((amn)amn.a((String)string)).c);
                }
            }
            if (this.serialNumbers != null) {
                if (this.verbose) {
                    System.out.println("Looking for serial numbers: " + Arrays.toString(this.serialNumbers));
                }
                stringArray = this.serialNumbers;
                n3 = this.serialNumbers.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    string = stringArray[n2];
                    arrayList.add(adj2.a((String)string).c);
                }
            }
            if (this.names != null) {
                if (this.verbose) {
                    System.out.println("Looking for names: " + Arrays.toString(this.names));
                }
                stringArray = this.names;
                n3 = this.names.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    string = stringArray[n2];
                    arrayList.add(adj2.a((String)this.family, (String)string).c);
                }
            }
            vg2.shutdown();
        }
        if (this.ipAddresses != null) {
            stringArray2 = this.ipAddresses;
            int n4 = this.ipAddresses.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                stringArray = stringArray2[i3];
                arrayList.add(aem.a((String)stringArray));
            }
        }
        if (arrayList.isEmpty()) {
            throw ayv.a();
        }
        this.h = arrayList;
        return this.h;
    }

    private Integer a() throws Exception {
        try {
            this.run();
            return ayw.b.cr;
        }
        catch (ayv ayv2) {
            System.err.println(ayv2.getMessage());
            return ayv2.a.cr;
        }
        catch (JAXBException jAXBException) {
            System.err.println(us.hebi.gui.lib.h.a(jAXBException));
            return ayw.c.cr;
        }
        catch (Throwable throwable) {
            System.err.println(throwable.getMessage());
            return ayw.c.cr;
        }
    }

    protected abstract void g(List<BiConsumer<bsj, Integer>> var1) throws Exception;

    protected abstract void y(int var1) throws Exception;

    protected void run() throws Exception {
        ArrayList<BiConsumer<bsj, Integer>> arrayList = new ArrayList<BiConsumer<bsj, Integer>>();
        this.g(arrayList);
        List<aem> list = this.c();
        if (this.verbose) {
            System.out.println("Target device addresses: ");
            list.forEach(aem2 -> System.out.println("* " + String.valueOf(aem2)));
        }
        this.y(list.size());
        bsj bsj2 = bsj.b();
        int n2 = 0;
        for (aem aem3 : list) {
            bsj2.c();
            Object object = arrayList.iterator();
            while (object.hasNext()) {
                ((BiConsumer)object.next()).accept(bsj2, n2);
            }
            ++n2;
            if (!bsj2.isEmpty()) {
                System.out.println("Sending message to " + String.valueOf(aem3) + "...");
                if (this.dryRun) {
                    System.out.println(bsj2);
                } else {
                    cbb cbb2;
                    object = aej.a(aem3, bsj2);
                    if (object == null) {
                        System.err.println("Failed to receive response from " + String.valueOf(aem3) + ".");
                        continue;
                    }
                    if (this.verbose) {
                        System.out.println("Received response from " + String.valueOf(aem3) + ".");
                    }
                    if ((cbb2 = ((bsj)object).a.b.d).ax() > 0) {
                        System.err.println("Received errors from " + String.valueOf(aem3) + ":");
                        cav cav2 = cbb2.a();
                        while (cav2.hasNext()) {
                            String string = (String)cav2.next();
                            System.err.println("    " + string);
                        }
                    }
                }
            }
            if (!this.reset) continue;
            System.out.println("Sending reset command to " + String.valueOf(aem3) + ". Not waiting for ack.");
            bsj2.c().i(true);
            if (this.dryRun) {
                System.out.println(bsj2);
                continue;
            }
            aej.a(aem3, bsj2);
        }
    }

    protected final boolean c(File file) {
        if (file == null) {
            return false;
        }
        if (!file.isFile()) {
            throw ayv.a(file);
        }
        if (this.verbose) {
            System.out.println("Loading file " + String.valueOf(file));
        }
        return true;
    }

    protected static void a(boolean bl2, String string, Object ... objectArray) {
        if (!bl2) {
            throw ayv.a(string, objectArray);
        }
    }

    @Override
    public /* synthetic */ Object call() throws Exception {
        return this.a();
    }
}

