/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli.javafx;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javafx.scene.text.Font;
import org.kordamp.ikonli.AbstractIkonResolver;
import org.kordamp.ikonli.IkonHandler;

public class IkonResolver
extends AbstractIkonResolver {
    private static final IkonResolver INSTANCE;
    private static final Set<IkonHandler> HANDLERS;
    private static final Set<IkonHandler> CUSTOM_HANDLERS;
    private static final Map<String, Font> FONTS;

    private IkonResolver() {
    }

    public boolean registerHandler(IkonHandler ikonHandler) {
        return this.registerHandler(ikonHandler, HANDLERS, CUSTOM_HANDLERS);
    }

    public boolean unregisterHandler(IkonHandler ikonHandler) {
        return this.unregisterHandler(ikonHandler, HANDLERS, CUSTOM_HANDLERS);
    }

    public IkonHandler resolve(String string) {
        return this.resolve(string, HANDLERS, CUSTOM_HANDLERS);
    }

    public static IkonResolver getInstance() {
        return INSTANCE;
    }

    static {
        HANDLERS = new LinkedHashSet<IkonHandler>();
        CUSTOM_HANDLERS = new LinkedHashSet<IkonHandler>();
        FONTS = new LinkedHashMap<String, Font>();
        INSTANCE = new IkonResolver();
        ServiceLoader<IkonHandler> serviceLoader = IkonResolver.resolveServiceLoader();
        for (IkonHandler ikonHandler : serviceLoader) {
            HANDLERS.add(ikonHandler);
            String string2 = ikonHandler.getFontResource().toExternalForm();
            ikonHandler.setFont(FONTS.computeIfAbsent(string2, string -> Font.loadFont((String)string, (double)16.0)));
        }
    }
}

