/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli.javafx;

import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.scene.text.Font;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.IkonResolver;

public class FontIconConverter
extends StyleConverter<String, Ikon> {
    public static StyleConverter<String, Ikon> getInstance() {
        return Holder.INSTANCE;
    }

    private FontIconConverter() {
    }

    public String toString() {
        return "FontIconConverter";
    }

    public Ikon convert(ParsedValue<String, Ikon> parsedValue, Font font) {
        String string = ((String)parsedValue.getValue()).trim();
        return IkonResolver.getInstance().resolve(string).resolve(string);
    }

    public static final class SequenceConverter
    extends StyleConverter<String, Ikon[]> {
        public static SequenceConverter getInstance() {
            return Holder.SEQUENCE_INSTANCE;
        }

        private SequenceConverter() {
        }

        public Ikon[] convert(ParsedValue<String, Ikon[]> parsedValue, Font font) {
            String[] stringArray = ((String)parsedValue.getValue()).split(",");
            Ikon[] ikonArray = new Ikon[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = stringArray[i2].trim();
                ikonArray[i2] = IkonResolver.getInstance().resolve(string).resolve(string);
            }
            return ikonArray;
        }

        public String toString() {
            return "FontIcon.SequenceConverter";
        }
    }

    private static class Holder {
        static final FontIconConverter INSTANCE = new FontIconConverter();
        static final SequenceConverter SEQUENCE_INSTANCE = new SequenceConverter();

        private Holder() {
        }
    }
}

