/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli.javafx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.PaintConverter;
import javafx.css.converter.SizeConverter;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.IkonHandler;
import org.kordamp.ikonli.javafx.FontIconConverter;
import org.kordamp.ikonli.javafx.Icon;
import org.kordamp.ikonli.javafx.IkonResolver;

public class FontIcon
extends Text
implements Icon {
    private static final double EPSILON = 1.0E-6;
    protected StyleableIntegerProperty iconSize;
    protected StyleableObjectProperty<Paint> iconColor;
    private StyleableObjectProperty<Ikon> iconCode;

    public FontIcon() {
        this.getStyleClass().setAll((Object[])new String[]{"ikonli-font-icon"});
        this.setIconSize(8);
        this.setIconColor((Paint)Color.BLACK);
        this.fontProperty().addListener((observableValue, font, font2) -> {
            int n2 = (int)font2.getSize();
            if (n2 != this.getIconSize()) {
                this.setIconSize(n2);
            }
        });
        this.fillProperty().addListener((observableValue, paint, paint2) -> {
            Paint paint3 = this.getIconColor();
            if (!Objects.equals(paint3, paint2)) {
                this.setIconColor((Paint)paint2);
            }
        });
        this.iconCodeProperty().addListener((observableValue, ikon, ikon2) -> {
            if (ikon2 != null) {
                IkonHandler ikonHandler = IkonResolver.getInstance().resolve(ikon2.getDescription());
                this.setStyle(this.normalizeStyle(this.getStyle(), "-fx-font-family", "'" + ikonHandler.getFontFamily() + "'"));
                int n2 = ikon2.getCode();
                if (n2 <= 65535) {
                    this.setText(String.valueOf((char)n2));
                } else {
                    char[] cArray = Character.toChars(n2);
                    String string = new String(cArray);
                    this.setText(string);
                }
            }
        });
    }

    public FontIcon(String string) {
        this();
        this.setIconLiteral(string);
    }

    public FontIcon(Ikon ikon) {
        this();
        this.setIconCode(ikon);
    }

    public String toString() {
        Ikon ikon = this.getIconCode();
        return (ikon != null ? ikon.getDescription() : "<undef>") + ":" + this.getIconSize() + ":" + this.getIconColor();
    }

    @Override
    public IntegerProperty iconSizeProperty() {
        if (this.iconSize == null) {
            this.iconSize = new StyleableIntegerProperty(8){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.ICON_SIZE;
                }

                public Object getBean() {
                    return FontIcon.this;
                }

                public String getName() {
                    return "iconSize";
                }

                public StyleOrigin getStyleOrigin() {
                    return StyleOrigin.USER_AGENT;
                }
            };
            this.iconSize.addListener((observableValue, number, number2) -> {
                Font font = this.getFont();
                if (Math.abs(font.getSize() - number2.doubleValue()) >= 1.0E-6) {
                    this.setFont(Font.font((String)font.getFamily(), (double)number2.doubleValue()));
                    this.setStyle(this.normalizeStyle(this.getStyle(), "-fx-font-size", number2.intValue() + "px"));
                }
            });
        }
        return this.iconSize;
    }

    @Override
    public ObjectProperty<Paint> iconColorProperty() {
        if (this.iconColor == null) {
            this.iconColor = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.ICON_COLOR;
                }

                public Object getBean() {
                    return FontIcon.this;
                }

                public String getName() {
                    return "iconColor";
                }

                public StyleOrigin getStyleOrigin() {
                    return StyleOrigin.USER_AGENT;
                }
            };
            this.iconColor.addListener((observableValue, paint, paint2) -> this.setFill((Paint)paint2));
        }
        return this.iconColor;
    }

    public ObjectProperty<Ikon> iconCodeProperty() {
        if (this.iconCode == null) {
            this.iconCode = new StyleableObjectProperty<Ikon>(){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.ICON_CODE;
                }

                public Object getBean() {
                    return FontIcon.this;
                }

                public String getName() {
                    return "iconCode";
                }

                public StyleOrigin getStyleOrigin() {
                    return StyleOrigin.USER_AGENT;
                }
            };
            this.iconCode.addListener((observableValue, ikon, ikon2) -> {
                if (!this.iconCode.isBound()) {
                    this.setIconCode((Ikon)ikon2);
                }
            });
        }
        return this.iconCode;
    }

    @Override
    public int getIconSize() {
        return this.iconSizeProperty().get();
    }

    @Override
    public void setIconSize(int n2) {
        if (n2 <= 0) {
            throw new IllegalStateException("Argument 'size' must be greater than zero.");
        }
        this.iconSizeProperty().set(n2);
    }

    @Override
    public Paint getIconColor() {
        return (Paint)this.iconColorProperty().get();
    }

    @Override
    public void setIconColor(Paint paint) {
        this.iconColorProperty().set((Object)Objects.requireNonNull(paint, "Argument 'paint' must not be null"));
    }

    public Ikon getIconCode() {
        return (Ikon)this.iconCodeProperty().get();
    }

    public void setIconCode(Ikon ikon) {
        this.iconCodeProperty().set((Object)Objects.requireNonNull(ikon, "Argument 'code' must not be null"));
    }

    private String normalizeStyle(String object, String string, String string2) {
        int n2 = ((String)object).indexOf(string);
        if (n2 != -1) {
            int n3 = ((String)object).indexOf(";", n2);
            n3 = n3 >= n2 ? n3 : ((String)object).length() - 1;
            object = ((String)object).substring(0, n2) + ((String)object).substring(n3 + 1);
        }
        return (String)object + string + ": " + string2 + ";";
    }

    public String getIconLiteral() {
        Ikon ikon = (Ikon)this.iconCodeProperty().get();
        return ikon != null ? ikon.getDescription() : null;
    }

    public void setIconLiteral(String string) {
        String[] stringArray = string.split(":");
        this.setIconCode(IkonResolver.getInstance().resolve(stringArray[0]).resolve(stringArray[0]));
        this.resolveSize(string, stringArray);
        this.resolvePaint(string, stringArray);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FontIcon.getClassCssMetaData();
    }

    private void resolveSize(String string, String[] stringArray) {
        if (stringArray.length > 1) {
            try {
                this.setIconSize(Integer.parseInt(stringArray[1]));
            }
            catch (NumberFormatException numberFormatException) {
                throw FontIcon.invalidDescription(string, numberFormatException);
            }
        }
    }

    private void resolvePaint(String string, String[] stringArray) {
        Paint paint;
        if (stringArray.length > 2 && (paint = FontIcon.resolvePaintValue(string, stringArray[2])) != null) {
            this.setIconColor(paint);
        }
    }

    public static FontIcon of(Ikon ikon) {
        return FontIcon.of(ikon, 8, Color.BLACK);
    }

    public static FontIcon of(Ikon ikon, int n2) {
        return FontIcon.of(ikon, n2, Color.BLACK);
    }

    public static FontIcon of(Ikon ikon, Color color) {
        return FontIcon.of(ikon, 8, color);
    }

    public static FontIcon of(Ikon ikon, int n2, Color color) {
        FontIcon fontIcon = new FontIcon();
        fontIcon.setIconCode(ikon);
        fontIcon.setIconSize(n2);
        fontIcon.setIconColor((Paint)color);
        return fontIcon;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static Paint resolvePaintValue(String string, String string2) {
        try {
            return Color.valueOf((String)string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return LinearGradient.valueOf((String)string2);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    return RadialGradient.valueOf((String)string2);
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    throw FontIcon.invalidDescription(string, illegalArgumentException3);
                }
            }
        }
    }

    public static IllegalArgumentException invalidDescription(String string, Exception exception) {
        throw new IllegalArgumentException("Description " + string + " is not a valid icon description", exception);
    }

    private static class StyleableProperties {
        private static final CssMetaData<FontIcon, Number> ICON_SIZE = new CssMetaData<FontIcon, Number>("-fx-icon-size", SizeConverter.getInstance(), (Number)8){

            public boolean isSettable(FontIcon fontIcon) {
                return true;
            }

            public StyleableProperty<Number> getStyleableProperty(FontIcon fontIcon) {
                return (StyleableProperty)fontIcon.iconSizeProperty();
            }
        };
        private static final CssMetaData<FontIcon, Paint> ICON_COLOR = new CssMetaData<FontIcon, Paint>("-fx-icon-color", PaintConverter.getInstance(), (Paint)Color.BLACK){

            public boolean isSettable(FontIcon fontIcon) {
                return true;
            }

            public StyleableProperty<Paint> getStyleableProperty(FontIcon fontIcon) {
                return (StyleableProperty)fontIcon.iconColorProperty();
            }
        };
        private static final CssMetaData<FontIcon, Ikon> ICON_CODE = new CssMetaData<FontIcon, Ikon>("-fx-icon-code", FontIconConverter.getInstance(), null){

            public boolean isSettable(FontIcon fontIcon) {
                return true;
            }

            public StyleableProperty<Ikon> getStyleableProperty(FontIcon fontIcon) {
                return (StyleableProperty)fontIcon.iconCodeProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<Object> arrayList = new ArrayList<Object>(Text.getClassCssMetaData());
            arrayList.add(ICON_SIZE);
            arrayList.add(ICON_COLOR);
            arrayList.add(ICON_CODE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

