/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public final class Borders {
    private static final Color DEFAULT_BORDER_COLOR = Color.DARKGRAY;
    private final Node node;
    private final List<Border> borders;

    public static Borders wrap(Node node) {
        return new Borders(node);
    }

    private Borders(Node node) {
        this.node = node;
        this.borders = new ArrayList<Border>();
    }

    public EmptyBorders emptyBorder() {
        return new EmptyBorders(this);
    }

    public EtchedBorders etchedBorder() {
        return new EtchedBorders(this);
    }

    public LineBorders lineBorder() {
        return new LineBorders(this);
    }

    public Borders addBorder(Border border) {
        this.borders.add(border);
        return this;
    }

    public Node build() {
        Node node = this.node;
        for (int i2 = this.borders.size() - 1; i2 >= 0; --i2) {
            Border border = this.borders.get(i2);
            node = border.wrap(node);
        }
        return node;
    }

    private static class StrokeBorder
    implements Border {
        private static final int TITLE_PADDING = 3;
        private static final double GAP_PADDING = 5.0;
        private final String title;
        private final BorderStroke[] borderStrokes;

        public StrokeBorder(String string, BorderStroke ... borderStrokeArray) {
            this.title = string;
            this.borderStrokes = borderStrokeArray;
        }

        @Override
        public Node wrap(final Node node) {
            StackPane stackPane = new StackPane(){
                Label titleLabel;
                {
                    this.getChildren().add((Object)node);
                    if (title != null) {
                        this.titleLabel = new Label(title);
                        this.titleLabel.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
                        this.getChildren().add((Object)this.titleLabel);
                    }
                }

                protected void layoutChildren() {
                    super.layoutChildren();
                    if (this.titleLabel != null) {
                        double d3 = this.titleLabel.prefHeight(-1.0);
                        double d4 = this.titleLabel.prefWidth(d3) + 3.0;
                        this.titleLabel.resize(d4, d3);
                        this.titleLabel.relocate(6.0, -d3 / 2.0 - 1.0);
                        ArrayList<BorderStroke> arrayList = new ArrayList<BorderStroke>(2);
                        for (BorderStroke borderStroke : borderStrokes) {
                            ArrayList<Double> arrayList2 = new ArrayList<Double>();
                            if (borderStroke.getTopStyle().getDashArray().isEmpty()) {
                                arrayList2.addAll(Arrays.asList(5.0, d4, Double.MAX_VALUE));
                            } else {
                                int n2;
                                double d5 = borderStroke.getTopStyle().getDashArray().stream().mapToDouble(d2 -> d2).sum();
                                if (d5 > 5.0) {
                                    arrayList2.add(5.0);
                                    arrayList2.add(d4);
                                } else {
                                    n2 = (int)(5.0 / d5);
                                    for (int i2 = 0; i2 < n2; ++i2) {
                                        arrayList2.addAll(borderStroke.getTopStyle().getDashArray());
                                    }
                                    if ((arrayList2.size() & 1) == 0) {
                                        arrayList2.add(0.0);
                                    }
                                    arrayList2.add(d4 + 5.0 - (double)n2 * d5);
                                }
                                n2 = 0;
                                while ((double)n2 < (this.getWidth() - d4 - d5) / d5) {
                                    arrayList2.addAll(borderStroke.getTopStyle().getDashArray());
                                    ++n2;
                                }
                            }
                            BorderStrokeStyle borderStrokeStyle = new BorderStrokeStyle(borderStroke.getTopStyle().getType(), borderStroke.getTopStyle().getLineJoin(), borderStroke.getTopStyle().getLineCap(), borderStroke.getTopStyle().getMiterLimit(), borderStroke.getTopStyle().getDashOffset(), arrayList2);
                            arrayList.add(new BorderStroke(borderStroke.getTopStroke(), borderStroke.getRightStroke(), borderStroke.getBottomStroke(), borderStroke.getLeftStroke(), borderStrokeStyle, borderStroke.getRightStyle(), borderStroke.getBottomStyle(), borderStroke.getLeftStyle(), borderStroke.getRadii(), borderStroke.getWidths(), null));
                        }
                        this.setBorder(new javafx.scene.layout.Border(arrayList.toArray(new BorderStroke[arrayList.size()])));
                    }
                }
            };
            stackPane.setBorder(new javafx.scene.layout.Border(this.borderStrokes));
            return stackPane;
        }
    }

    @FunctionalInterface
    public static interface Border {
        public Node wrap(Node var1);
    }

    public class LineBorders {
        private final Borders parent;
        private String title;
        private BorderStrokeStyle strokeStyle = BorderStrokeStyle.SOLID;
        private Color topColor = DEFAULT_BORDER_COLOR;
        private Color rightColor = DEFAULT_BORDER_COLOR;
        private Color bottomColor = DEFAULT_BORDER_COLOR;
        private Color leftColor = DEFAULT_BORDER_COLOR;
        private double outerTopPadding = 10.0;
        private double outerRightPadding = 10.0;
        private double outerBottomPadding = 10.0;
        private double outerLeftPadding = 10.0;
        private double innerTopPadding = 15.0;
        private double innerRightPadding = 15.0;
        private double innerBottomPadding = 15.0;
        private double innerLeftPadding = 15.0;
        private double topThickness = 1.0;
        private double rightThickness = 1.0;
        private double bottomThickness = 1.0;
        private double leftThickness = 1.0;
        private double topLeftRadius = 0.0;
        private double topRightRadius = 0.0;
        private double bottomRightRadius = 0.0;
        private double bottomLeftRadius = 0.0;

        private LineBorders(Borders borders2) {
            this.parent = borders2;
        }

        public LineBorders color(Color color) {
            return this.color(color, color, color, color);
        }

        public LineBorders color(Color color, Color color2, Color color3, Color color4) {
            this.topColor = color;
            this.rightColor = color2;
            this.bottomColor = color3;
            this.leftColor = color4;
            return this;
        }

        public LineBorders strokeStyle(BorderStrokeStyle borderStrokeStyle) {
            this.strokeStyle = borderStrokeStyle;
            return this;
        }

        public LineBorders outerPadding(double d2) {
            return this.outerPadding(d2, d2, d2, d2);
        }

        public LineBorders outerPadding(double d2, double d3, double d4, double d5) {
            this.outerTopPadding = d2;
            this.outerRightPadding = d3;
            this.outerBottomPadding = d4;
            this.outerLeftPadding = d5;
            return this;
        }

        public LineBorders innerPadding(double d2) {
            return this.innerPadding(d2, d2, d2, d2);
        }

        public LineBorders innerPadding(double d2, double d3, double d4, double d5) {
            this.innerTopPadding = d2;
            this.innerRightPadding = d3;
            this.innerBottomPadding = d4;
            this.innerLeftPadding = d5;
            return this;
        }

        public LineBorders thickness(double d2) {
            return this.thickness(d2, d2, d2, d2);
        }

        public LineBorders thickness(double d2, double d3, double d4, double d5) {
            this.topThickness = d2;
            this.rightThickness = d3;
            this.bottomThickness = d4;
            this.leftThickness = d5;
            return this;
        }

        public LineBorders radius(double d2) {
            return this.radius(d2, d2, d2, d2);
        }

        public LineBorders radius(double d2, double d3, double d4, double d5) {
            this.topLeftRadius = d2;
            this.topRightRadius = d3;
            this.bottomRightRadius = d4;
            this.bottomLeftRadius = d5;
            return this;
        }

        public LineBorders title(String string) {
            this.title = string;
            return this;
        }

        public Borders build() {
            BorderStroke borderStroke = new BorderStroke((Paint)this.topColor, (Paint)this.rightColor, (Paint)this.bottomColor, (Paint)this.leftColor, this.strokeStyle, this.strokeStyle, this.strokeStyle, this.strokeStyle, new CornerRadii(this.topLeftRadius, this.topRightRadius, this.bottomRightRadius, this.bottomLeftRadius, false), new BorderWidths(this.topThickness, this.rightThickness, this.bottomThickness, this.leftThickness), null);
            BorderStroke borderStroke2 = new EmptyBorders(this.parent).padding(this.outerTopPadding, this.outerRightPadding, this.outerBottomPadding, this.outerLeftPadding).buildStroke();
            BorderStroke borderStroke3 = new EmptyBorders(this.parent).padding(this.innerTopPadding, this.innerRightPadding, this.innerBottomPadding, this.innerLeftPadding).buildStroke();
            this.parent.addBorder(new StrokeBorder(null, borderStroke2));
            this.parent.addBorder(new StrokeBorder(this.title, borderStroke));
            this.parent.addBorder(new StrokeBorder(null, borderStroke3));
            return this.parent;
        }

        public Node buildAll() {
            this.build();
            return this.parent.build();
        }
    }

    public class EtchedBorders {
        private final Borders parent;
        private String title;
        private boolean raised = false;
        private double outerTopPadding = 10.0;
        private double outerRightPadding = 10.0;
        private double outerBottomPadding = 10.0;
        private double outerLeftPadding = 10.0;
        private double innerTopPadding = 15.0;
        private double innerRightPadding = 15.0;
        private double innerBottomPadding = 15.0;
        private double innerLeftPadding = 15.0;
        private double topLeftRadius = 0.0;
        private double topRightRadius = 0.0;
        private double bottomRightRadius = 0.0;
        private double bottomLeftRadius = 0.0;
        private Color highlightColor = DEFAULT_BORDER_COLOR;
        private Color shadowColor = Color.WHITE;

        private EtchedBorders(Borders borders2) {
            this.parent = borders2;
        }

        public EtchedBorders highlight(Color color) {
            this.highlightColor = color;
            return this;
        }

        public EtchedBorders shadow(Color color) {
            this.shadowColor = color;
            return this;
        }

        public EtchedBorders raised() {
            this.raised = true;
            return this;
        }

        public EtchedBorders title(String string) {
            this.title = string;
            return this;
        }

        public EtchedBorders outerPadding(double d2) {
            return this.outerPadding(d2, d2, d2, d2);
        }

        public EtchedBorders outerPadding(double d2, double d3, double d4, double d5) {
            this.outerTopPadding = d2;
            this.outerRightPadding = d3;
            this.outerBottomPadding = d4;
            this.outerLeftPadding = d5;
            return this;
        }

        public EtchedBorders innerPadding(double d2) {
            return this.innerPadding(d2, d2, d2, d2);
        }

        public EtchedBorders innerPadding(double d2, double d3, double d4, double d5) {
            this.innerTopPadding = d2;
            this.innerRightPadding = d3;
            this.innerBottomPadding = d4;
            this.innerLeftPadding = d5;
            return this;
        }

        public EtchedBorders radius(double d2) {
            return this.radius(d2, d2, d2, d2);
        }

        public EtchedBorders radius(double d2, double d3, double d4, double d5) {
            this.topLeftRadius = d2;
            this.topRightRadius = d3;
            this.bottomRightRadius = d4;
            this.bottomLeftRadius = d5;
            return this;
        }

        public Borders build() {
            Color color = this.raised ? this.shadowColor : this.highlightColor;
            Color color2 = this.raised ? this.highlightColor : this.shadowColor;
            BorderStroke borderStroke = new BorderStroke((Paint)color, BorderStrokeStyle.SOLID, new CornerRadii(this.topLeftRadius, this.topRightRadius, this.bottomRightRadius, this.bottomLeftRadius, false), new BorderWidths(1.0));
            BorderStroke borderStroke2 = new BorderStroke((Paint)color2, BorderStrokeStyle.SOLID, new CornerRadii(this.topLeftRadius, this.topRightRadius, this.bottomRightRadius, this.bottomLeftRadius, false), new BorderWidths(1.0), new Insets(1.0));
            BorderStroke borderStroke3 = new EmptyBorders(this.parent).padding(this.outerTopPadding, this.outerRightPadding, this.outerBottomPadding, this.outerLeftPadding).buildStroke();
            BorderStroke borderStroke4 = new EmptyBorders(this.parent).padding(this.innerTopPadding, this.innerRightPadding, this.innerBottomPadding, this.innerLeftPadding).buildStroke();
            this.parent.addBorder(new StrokeBorder(null, borderStroke3));
            this.parent.addBorder(new StrokeBorder(this.title, borderStroke, borderStroke2));
            this.parent.addBorder(new StrokeBorder(null, borderStroke4));
            return this.parent;
        }

        public Node buildAll() {
            this.build();
            return this.parent.build();
        }
    }

    public class EmptyBorders {
        private final Borders parent;
        private double top;
        private double right;
        private double bottom;
        private double left;

        private EmptyBorders(Borders borders2) {
            this.parent = borders2;
        }

        public EmptyBorders padding(double d2) {
            return this.padding(d2, d2, d2, d2);
        }

        public EmptyBorders padding(double d2, double d3, double d4, double d5) {
            this.top = d2;
            this.right = d3;
            this.bottom = d4;
            this.left = d5;
            return this;
        }

        public Borders build() {
            this.parent.addBorder(new StrokeBorder(null, this.buildStroke()));
            return this.parent;
        }

        public Node buildAll() {
            this.build();
            return this.parent.build();
        }

        private BorderStroke buildStroke() {
            return new BorderStroke(null, BorderStrokeStyle.NONE, null, new BorderWidths(this.top, this.right, this.bottom, this.left), Insets.EMPTY);
        }
    }
}

