/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.tableview2.actions;

import impl.org.controlsfx.i18n.Localization;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionCheck;
import org.controlsfx.control.tableview2.TableView2;

@ActionCheck
public class ColumnFixAction
extends Action {
    private InvalidationListener fixedColumnsListener;

    public ColumnFixAction(TableColumn tableColumn) {
        this(tableColumn, Localization.localize(Localization.asKey("tableview2.column.menu.fixed")));
    }

    public ColumnFixAction(TableColumn tableColumn, String string) {
        this(tableColumn, string, null);
    }

    public ColumnFixAction(TableColumn tableColumn, String string, Node node) {
        super(string);
        this.setGraphic(node);
        if (tableColumn != null) {
            this.fixedColumnsListener = observable -> this.setSelected(this.isFixedColumn(tableColumn));
            TableView tableView = tableColumn.getTableView();
            if (tableView != null && tableView instanceof TableView2) {
                this.initialize(tableColumn, (TableView2)tableView);
            }
            tableColumn.tableViewProperty().addListener((observableValue, object, object2) -> {
                if (object != null && object instanceof TableView2) {
                    this.reset((TableView2)((Object)((Object)object)));
                }
                if (object2 != null && object2 instanceof TableView2) {
                    this.initialize(tableColumn, (TableView2)((Object)((Object)object2)));
                }
            });
        }
    }

    public String toString() {
        return this.getText();
    }

    private void initialize(TableColumn tableColumn, TableView2 tableView2) {
        tableView2.getFixedColumns().addListener(this.fixedColumnsListener);
        this.disabledProperty().bind((ObservableValue)tableView2.columnFixingEnabledProperty().not().or((ObservableBooleanValue)tableColumn.parentColumnProperty().isNotNull()));
        this.setSelected(this.isFixedColumn(tableColumn));
        this.setEventHandler(actionEvent -> {
            if (!tableView2.getFixedColumns().contains((Object)tableColumn)) {
                tableView2.getFixedColumns().add((Object)tableColumn);
            } else {
                tableView2.getFixedColumns().remove((Object)tableColumn);
            }
        });
    }

    private void reset(TableView2 tableView2) {
        tableView2.getFixedColumns().removeListener(this.fixedColumnsListener);
        this.disabledProperty().unbind();
        this.setSelected(false);
        this.setEventHandler(null);
    }

    private boolean isFixedColumn(TableColumn tableColumn) {
        while (tableColumn.getParentColumn() != null) {
            tableColumn = (TableColumn)tableColumn.getParentColumn();
        }
        TableView tableView = tableColumn.getTableView();
        return tableView != null && tableView instanceof TableView2 && ((TableView2)tableView).getFixedColumns().contains((Object)tableColumn);
    }
}

