/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.util.Callback;
import org.controlsfx.control.spreadsheet.Filter;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetCellType;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class FilterBase
implements Filter {
    private final SpreadsheetView spv;
    private final int column;
    private MenuButton menuButton;
    private BitSet hiddenRows;
    private Set<String> stringSet = new HashSet<String>();
    private Set<String> copySet = new HashSet<String>();
    private final Comparator ascendingComp = new Comparator<ObservableList<SpreadsheetCell>>(){

        @Override
        public int compare(ObservableList<SpreadsheetCell> observableList, ObservableList<SpreadsheetCell> observableList2) {
            SpreadsheetCell spreadsheetCell = (SpreadsheetCell)observableList.get(FilterBase.this.column);
            SpreadsheetCell spreadsheetCell2 = (SpreadsheetCell)observableList2.get(FilterBase.this.column);
            if (spreadsheetCell.getRow() <= FilterBase.this.spv.getFilteredRow()) {
                return Integer.compare(spreadsheetCell.getRow(), spreadsheetCell2.getRow());
            }
            if (spreadsheetCell2.getRow() <= FilterBase.this.spv.getFilteredRow()) {
                return Integer.compare(spreadsheetCell.getRow(), spreadsheetCell2.getRow());
            }
            if (spreadsheetCell.getCellType() == SpreadsheetCellType.INTEGER && spreadsheetCell2.getCellType() == SpreadsheetCellType.INTEGER) {
                return Integer.compare((Integer)spreadsheetCell.getItem(), (Integer)spreadsheetCell2.getItem());
            }
            if (spreadsheetCell.getCellType() == SpreadsheetCellType.DOUBLE && spreadsheetCell2.getCellType() == SpreadsheetCellType.DOUBLE) {
                return Double.compare((Double)spreadsheetCell.getItem(), (Double)spreadsheetCell2.getItem());
            }
            return spreadsheetCell.getText().compareToIgnoreCase(spreadsheetCell2.getText());
        }
    };
    private final Comparator descendingComp = new Comparator<ObservableList<SpreadsheetCell>>(){

        @Override
        public int compare(ObservableList<SpreadsheetCell> observableList, ObservableList<SpreadsheetCell> observableList2) {
            SpreadsheetCell spreadsheetCell = (SpreadsheetCell)observableList.get(FilterBase.this.column);
            SpreadsheetCell spreadsheetCell2 = (SpreadsheetCell)observableList2.get(FilterBase.this.column);
            if (spreadsheetCell.getRow() <= FilterBase.this.spv.getFilteredRow()) {
                return Integer.compare(spreadsheetCell.getRow(), spreadsheetCell2.getRow());
            }
            if (spreadsheetCell2.getRow() <= FilterBase.this.spv.getFilteredRow()) {
                return Integer.compare(spreadsheetCell.getRow(), spreadsheetCell2.getRow());
            }
            if (spreadsheetCell.getCellType() == SpreadsheetCellType.INTEGER && spreadsheetCell2.getCellType() == SpreadsheetCellType.INTEGER) {
                return Integer.compare((Integer)spreadsheetCell2.getItem(), (Integer)spreadsheetCell.getItem());
            }
            if (spreadsheetCell.getCellType() == SpreadsheetCellType.DOUBLE && spreadsheetCell2.getCellType() == SpreadsheetCellType.DOUBLE) {
                return Double.compare((Double)spreadsheetCell2.getItem(), (Double)spreadsheetCell.getItem());
            }
            return spreadsheetCell2.getText().compareToIgnoreCase(spreadsheetCell.getText());
        }
    };

    public FilterBase(SpreadsheetView spreadsheetView, int n2) {
        this.spv = spreadsheetView;
        this.column = n2;
    }

    @Override
    public MenuButton getMenuButton() {
        if (this.menuButton == null) {
            this.menuButton = new MenuButton();
            this.menuButton.getStyleClass().add((Object)"filter-menu-button");
            this.menuButton.showingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl2, Boolean bl3) {
                    if (bl3.booleanValue()) {
                        FilterBase.this.addMenuItems();
                        FilterBase.this.hiddenRows = new BitSet(FilterBase.this.spv.getHiddenRows().size());
                        FilterBase.this.hiddenRows.or(FilterBase.this.spv.getHiddenRows());
                    } else {
                        for (int i2 = FilterBase.this.spv.getFilteredRow() + 1; i2 < FilterBase.this.spv.getGrid().getRowCount(); ++i2) {
                            FilterBase.this.hiddenRows.set(i2, !FilterBase.this.copySet.contains(((SpreadsheetCell)((ObservableList)FilterBase.this.spv.getGrid().getRows().get(i2)).get(FilterBase.this.column)).getText()));
                        }
                        FilterBase.this.spv.setHiddenRows(FilterBase.this.hiddenRows);
                    }
                }
            });
        }
        return this.menuButton;
    }

    private void addMenuItems() {
        if (this.menuButton.getItems().isEmpty()) {
            final MenuItem menuItem = new MenuItem("Sort ascending");
            menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    if (FilterBase.this.spv.getComparator() == FilterBase.this.ascendingComp) {
                        FilterBase.this.spv.setComparator(FilterBase.this.descendingComp);
                        menuItem.setText("Remove sort");
                    } else if (FilterBase.this.spv.getComparator() == FilterBase.this.descendingComp) {
                        FilterBase.this.spv.setComparator(null);
                        menuItem.setText("Sort ascending");
                    } else {
                        FilterBase.this.spv.setComparator(FilterBase.this.ascendingComp);
                        menuItem.setText("Sort descending");
                    }
                }
            });
            ListView listView = new ListView();
            listView.setCellFactory((Callback)new Callback<ListView<String>, ListCell<String>>(){

                public ListCell<String> call(ListView<String> listView) {
                    return new ListCell<String>(){

                        public void updateItem(final String string, boolean bl2) {
                            super.updateItem((Object)string, bl2);
                            this.setText(string);
                            if (string != null) {
                                CheckBox checkBox = new CheckBox();
                                checkBox.setSelected(FilterBase.this.copySet.contains(string));
                                checkBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                                    public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl2, Boolean bl3) {
                                        if (bl3.booleanValue()) {
                                            FilterBase.this.copySet.add(string);
                                        } else {
                                            FilterBase.this.copySet.remove(string);
                                        }
                                    }
                                });
                                this.setGraphic((Node)checkBox);
                            }
                        }
                    };
                }
            });
            for (int i2 = this.spv.getFilteredRow() + 1; i2 < this.spv.getGrid().getRowCount(); ++i2) {
                this.stringSet.add(((SpreadsheetCell)((ObservableList)this.spv.getGrid().getRows().get(i2)).get(this.column)).getText());
            }
            listView.setItems(FXCollections.observableArrayList(this.stringSet));
            CustomMenuItem customMenuItem = new CustomMenuItem((Node)listView);
            customMenuItem.setHideOnClick(false);
            this.menuButton.getItems().addAll((Object[])new MenuItem[]{menuItem, customMenuItem});
        }
        this.copySet.clear();
        for (int i3 = this.spv.getFilteredRow() + 1; i3 < this.spv.getGrid().getRowCount(); ++i3) {
            if (this.spv.getHiddenRows().get(i3)) continue;
            this.copySet.add(((SpreadsheetCell)((ObservableList)this.spv.getGrid().getRows().get(i3)).get(this.column)).getText());
        }
    }
}

