/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.cell;

import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.controlsfx.control.GridCell;

public class ImageGridCell
extends GridCell<Image> {
    private final ImageView imageView;
    private final boolean preserveImageProperties;

    public ImageGridCell() {
        this(true);
    }

    public ImageGridCell(boolean bl2) {
        this.getStyleClass().add((Object)"image-grid-cell");
        this.preserveImageProperties = bl2;
        this.imageView = new ImageView();
        this.imageView.fitHeightProperty().bind((ObservableValue)this.heightProperty());
        this.imageView.fitWidthProperty().bind((ObservableValue)this.widthProperty());
    }

    protected void updateItem(Image image, boolean bl2) {
        super.updateItem((Object)image, bl2);
        if (bl2) {
            this.setGraphic(null);
        } else {
            if (this.preserveImageProperties) {
                this.imageView.setPreserveRatio(image.isPreserveRatio());
                this.imageView.setSmooth(image.isSmooth());
            }
            this.imageView.setImage(image);
            this.setGraphic((Node)this.imageView);
        }
    }
}

