/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.action;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Objects;
import javafx.event.ActionEvent;
import org.controlsfx.control.action.Action;

public class AnnotatedAction
extends Action {
    private final Method method;
    private final WeakReference<Object> target;

    public AnnotatedAction(String string, Method method, Object object) {
        super(string);
        Objects.requireNonNull(method);
        Objects.requireNonNull(object);
        this.setEventHandler(this::handleAction);
        this.method = method;
        this.method.setAccessible(true);
        this.target = new WeakReference<Object>(object);
    }

    public Object getTarget() {
        return this.target.get();
    }

    protected void handleAction(ActionEvent actionEvent) {
        try {
            Object object = this.getTarget();
            if (object == null) {
                throw new IllegalStateException("Action target object is no longer reachable");
            }
            int n2 = this.method.getParameterCount();
            if (n2 == 0) {
                this.method.invoke(object, new Object[0]);
            } else if (n2 == 1) {
                this.method.invoke(object, actionEvent);
            } else if (n2 == 2) {
                this.method.invoke(object, actionEvent, this);
            }
        }
        catch (Throwable throwable) {
            this.handleActionException(actionEvent, throwable);
        }
    }

    protected void handleActionException(ActionEvent actionEvent, Throwable throwable) {
        throwable.printStackTrace();
    }

    public String toString() {
        return this.getText();
    }
}

