/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.action;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.binding.When;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.controlsfx.control.SegmentedButton;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionCheck;
import org.controlsfx.control.action.ActionGroup;
import org.controlsfx.tools.Duplicatable;

public class ActionUtils {
    public static Action ACTION_SEPARATOR = new Action(null, null){

        public String toString() {
            return "Separator";
        }
    };
    public static Action ACTION_SPAN = new Action(null, null){

        public String toString() {
            return "Span";
        }
    };

    private ActionUtils() {
    }

    public static Button createButton(Action action, ActionTextBehavior actionTextBehavior) {
        return ActionUtils.configure(new Button(), action, actionTextBehavior);
    }

    public static Button createButton(Action action) {
        return ActionUtils.configure(new Button(), action, ActionTextBehavior.SHOW);
    }

    public static ButtonBase configureButton(Action action, ButtonBase buttonBase, ActionTextBehavior actionTextBehavior) {
        return ActionUtils.configure(buttonBase, action, actionTextBehavior);
    }

    public static ButtonBase configureButton(Action action, ButtonBase buttonBase) {
        return ActionUtils.configureButton(action, buttonBase, ActionTextBehavior.SHOW);
    }

    public static void unconfigureButton(ButtonBase buttonBase) {
        ActionUtils.unconfigure(buttonBase);
    }

    public static MenuButton createMenuButton(Action action, ActionTextBehavior actionTextBehavior) {
        return ActionUtils.configure(new MenuButton(), action, actionTextBehavior);
    }

    public static MenuButton createMenuButton(Action action) {
        return ActionUtils.configure(new MenuButton(), action, ActionTextBehavior.SHOW);
    }

    public static Hyperlink createHyperlink(Action action) {
        return ActionUtils.configure(new Hyperlink(), action, ActionTextBehavior.SHOW);
    }

    public static ToggleButton createToggleButton(Action action, ActionTextBehavior actionTextBehavior) {
        return ActionUtils.configure(new ToggleButton(), action, actionTextBehavior);
    }

    public static ToggleButton createToggleButton(Action action) {
        return ActionUtils.createToggleButton(action, ActionTextBehavior.SHOW);
    }

    public static SegmentedButton createSegmentedButton(ActionTextBehavior actionTextBehavior, Collection<? extends Action> collection) {
        ObservableList observableList = FXCollections.observableArrayList();
        for (Action action : collection) {
            observableList.add((Object)ActionUtils.createToggleButton(action, actionTextBehavior));
        }
        return new SegmentedButton((ObservableList<ToggleButton>)observableList);
    }

    public static SegmentedButton createSegmentedButton(Collection<? extends Action> collection) {
        return ActionUtils.createSegmentedButton(ActionTextBehavior.SHOW, collection);
    }

    public static SegmentedButton createSegmentedButton(ActionTextBehavior actionTextBehavior, Action ... actionArray) {
        return ActionUtils.createSegmentedButton(actionTextBehavior, Arrays.asList(actionArray));
    }

    public static SegmentedButton createSegmentedButton(Action ... actionArray) {
        return ActionUtils.createSegmentedButton(ActionTextBehavior.SHOW, Arrays.asList(actionArray));
    }

    public static CheckBox createCheckBox(Action action) {
        return ActionUtils.configure(new CheckBox(), action, ActionTextBehavior.SHOW);
    }

    public static RadioButton createRadioButton(Action action) {
        return ActionUtils.configure(new RadioButton(), action, ActionTextBehavior.SHOW);
    }

    public static MenuItem createMenuItem(Action action) {
        CheckMenuItem checkMenuItem = action.getClass().isAnnotationPresent(ActionCheck.class) ? new CheckMenuItem() : new MenuItem();
        return ActionUtils.configure(checkMenuItem, action);
    }

    public static MenuItem configureMenuItem(Action action, MenuItem menuItem) {
        return ActionUtils.configure(menuItem, action);
    }

    public static void unconfigureMenuItem(MenuItem menuItem) {
        ActionUtils.unconfigure(menuItem);
    }

    public static Menu createMenu(Action action) {
        return ActionUtils.configure(new Menu(), action);
    }

    public static CheckMenuItem createCheckMenuItem(Action action) {
        return ActionUtils.configure(new CheckMenuItem(), action);
    }

    public static RadioMenuItem createRadioMenuItem(Action action) {
        return ActionUtils.configure(new RadioMenuItem((String)action.textProperty().get()), action);
    }

    public static ToolBar createToolBar(Collection<? extends Action> collection, ActionTextBehavior actionTextBehavior) {
        return ActionUtils.updateToolBar(new ToolBar(), collection, actionTextBehavior);
    }

    public static ToolBar updateToolBar(ToolBar toolBar, Collection<? extends Action> collection, ActionTextBehavior actionTextBehavior) {
        toolBar.getItems().clear();
        for (Action action : collection) {
            Object object;
            if (action instanceof ActionGroup) {
                object = ActionUtils.createMenuButton(action, actionTextBehavior);
                object.setFocusTraversable(false);
                object.getItems().addAll(ActionUtils.toMenuItems(((ActionGroup)action).getActions()));
                toolBar.getItems().add(object);
                continue;
            }
            if (action == ACTION_SEPARATOR) {
                toolBar.getItems().add((Object)new Separator());
                continue;
            }
            if (action == ACTION_SPAN) {
                object = new Pane();
                HBox.setHgrow((Node)object, (Priority)Priority.ALWAYS);
                VBox.setVgrow((Node)object, (Priority)Priority.ALWAYS);
                toolBar.getItems().add(object);
                continue;
            }
            if (action == null) continue;
            object = action.getClass().getAnnotation(ActionCheck.class) != null ? ActionUtils.createToggleButton(action, actionTextBehavior) : ActionUtils.createButton(action, actionTextBehavior);
            object.setFocusTraversable(false);
            toolBar.getItems().add(object);
        }
        return toolBar;
    }

    public static MenuBar createMenuBar(Collection<? extends Action> collection) {
        return ActionUtils.updateMenuBar(new MenuBar(), collection);
    }

    public static MenuBar updateMenuBar(MenuBar menuBar, Collection<? extends Action> collection) {
        menuBar.getMenus().clear();
        for (Action action : collection) {
            if (action == ACTION_SEPARATOR || action == ACTION_SPAN) continue;
            Menu menu = ActionUtils.createMenu(action);
            if (action instanceof ActionGroup) {
                menu.getItems().addAll(ActionUtils.toMenuItems(((ActionGroup)action).getActions()));
            } else if (action == null) {
                // empty if block
            }
            menuBar.getMenus().add((Object)menu);
        }
        return menuBar;
    }

    public static ButtonBar createButtonBar(Collection<? extends Action> collection) {
        return ActionUtils.updateButtonBar(new ButtonBar(), collection);
    }

    public static ButtonBar updateButtonBar(ButtonBar buttonBar, Collection<? extends Action> collection) {
        buttonBar.getButtons().clear();
        for (Action action : collection) {
            if (action instanceof ActionGroup || action == ACTION_SPAN || action == ACTION_SEPARATOR || action == null) continue;
            buttonBar.getButtons().add((Object)ActionUtils.createButton(action, ActionTextBehavior.SHOW));
        }
        return buttonBar;
    }

    public static ContextMenu createContextMenu(Collection<? extends Action> collection) {
        return ActionUtils.updateContextMenu(new ContextMenu(), collection);
    }

    public static ContextMenu updateContextMenu(ContextMenu contextMenu, Collection<? extends Action> collection) {
        contextMenu.getItems().clear();
        contextMenu.getItems().addAll(ActionUtils.toMenuItems(collection));
        return contextMenu;
    }

    private static Collection<MenuItem> toMenuItems(Collection<? extends Action> collection) {
        ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
        for (Action action : collection) {
            if (action instanceof ActionGroup) {
                Menu menu = ActionUtils.createMenu(action);
                menu.getItems().addAll(ActionUtils.toMenuItems(((ActionGroup)action).getActions()));
                arrayList.add((MenuItem)menu);
                continue;
            }
            if (action == ACTION_SEPARATOR) {
                arrayList.add((MenuItem)new SeparatorMenuItem());
                continue;
            }
            if (action == null || action == ACTION_SPAN) continue;
            arrayList.add(ActionUtils.createMenuItem(action));
        }
        return arrayList;
    }

    private static Node copyNode(Node node) {
        if (node instanceof ImageView) {
            return new ImageView(((ImageView)node).getImage());
        }
        if (node instanceof Duplicatable) {
            return (Node)((Duplicatable)node).duplicate();
        }
        return null;
    }

    private static void bindStyle(final Styleable styleable, Action action) {
        styleable.getStyleClass().addAll(action.getStyleClass());
        ListChangeListener<String> listChangeListener = new ListChangeListener<String>(){

            public void onChanged(ListChangeListener.Change<? extends String> change) {
                while (change.next()) {
                    if (change.wasRemoved()) {
                        styleable.getStyleClass().removeAll((Collection)change.getRemoved());
                    }
                    if (!change.wasAdded()) continue;
                    styleable.getStyleClass().addAll((Collection)change.getAddedSubList());
                }
            }
        };
        if (styleable instanceof Node) {
            if (((Node)styleable).getProperties().containsKey((Object)ListChangeListener.class.getCanonicalName())) {
                throw new RuntimeException("222 Can't bind node to two actions!");
            }
            ((Node)styleable).getProperties().put((Object)ListChangeListener.class.getCanonicalName(), (Object)listChangeListener);
        }
        action.getStyleClass().addListener((ListChangeListener)listChangeListener);
    }

    private static <T extends ButtonBase> T configure(T t2, final Action action, ActionTextBehavior actionTextBehavior) {
        if (action == null) {
            throw new NullPointerException("Action can not be null");
        }
        ActionUtils.bindStyle(t2, action);
        if (actionTextBehavior == ActionTextBehavior.SHOW) {
            t2.textProperty().bind((ObservableValue)action.textProperty());
        }
        t2.disableProperty().bind((ObservableValue)action.disabledProperty());
        t2.graphicProperty().bind((ObservableValue)new ObjectBinding<Node>(){
            {
                this.bind(new Observable[]{action.graphicProperty()});
            }

            protected Node computeValue() {
                return ActionUtils.copyNode((Node)action.graphicProperty().get());
            }

            public void removeListener(InvalidationListener invalidationListener) {
                super.removeListener(invalidationListener);
                this.unbind(new Observable[]{action.graphicProperty()});
            }
        });
        t2.getProperties().putAll(action.getProperties());
        action.getProperties().addListener(new ButtonPropertiesMapChangeListener<T>(t2, action));
        t2.tooltipProperty().bind((ObservableValue)new ObjectBinding<Tooltip>(){
            private Tooltip tooltip = new Tooltip();
            private StringBinding textBinding = new When((ObservableBooleanValue)action.longTextProperty().isEmpty()).then((ObservableStringValue)action.textProperty()).otherwise((ObservableStringValue)action.longTextProperty());
            {
                this.bind(new Observable[]{this.textBinding});
                this.tooltip.textProperty().bind((ObservableValue)this.textBinding);
            }

            protected Tooltip computeValue() {
                String string = this.textBinding.get();
                return string == null || this.textBinding.get().isEmpty() ? null : this.tooltip;
            }

            public void removeListener(InvalidationListener invalidationListener) {
                super.removeListener(invalidationListener);
                this.unbind(new Observable[]{action.longTextProperty()});
                this.tooltip.textProperty().unbind();
            }
        });
        if (t2 instanceof ToggleButton) {
            ((ToggleButton)t2).selectedProperty().bindBidirectional((Property)action.selectedProperty());
        }
        t2.setOnAction((EventHandler)action);
        return t2;
    }

    private static void unconfigure(ButtonBase buttonBase) {
        if (buttonBase == null || !(buttonBase.getOnAction() instanceof Action)) {
            return;
        }
        Action action = (Action)buttonBase.getOnAction();
        Object object = buttonBase.getProperties().get((Object)ListChangeListener.class.getCanonicalName());
        if (object instanceof ListChangeListener) {
            buttonBase.getProperties().remove((Object)ListChangeListener.class.getCanonicalName());
            action.getStyleClass().removeListener((ListChangeListener)object);
        }
        buttonBase.styleProperty().unbind();
        buttonBase.textProperty().unbind();
        buttonBase.disableProperty().unbind();
        buttonBase.graphicProperty().unbind();
        action.getProperties().removeListener(new ButtonPropertiesMapChangeListener<ButtonBase>(buttonBase, action));
        buttonBase.tooltipProperty().unbind();
        if (buttonBase instanceof ToggleButton) {
            ((ToggleButton)buttonBase).selectedProperty().unbindBidirectional((Property)action.selectedProperty());
        }
        buttonBase.setOnAction(null);
    }

    private static <T extends MenuItem> T configure(T t2, final Action action) {
        if (action == null) {
            throw new NullPointerException("Action can not be null");
        }
        ActionUtils.bindStyle(t2, action);
        t2.textProperty().bind((ObservableValue)action.textProperty());
        t2.disableProperty().bind((ObservableValue)action.disabledProperty());
        t2.acceleratorProperty().bind(action.acceleratorProperty());
        t2.graphicProperty().bind((ObservableValue)new ObjectBinding<Node>(){
            {
                this.bind(new Observable[]{action.graphicProperty()});
            }

            protected Node computeValue() {
                return ActionUtils.copyNode((Node)action.graphicProperty().get());
            }

            public void removeListener(InvalidationListener invalidationListener) {
                super.removeListener(invalidationListener);
                this.unbind(new Observable[]{action.graphicProperty()});
            }
        });
        t2.getProperties().putAll(action.getProperties());
        action.getProperties().addListener(new MenuItemPropertiesMapChangeListener<T>(t2, action));
        if (t2 instanceof RadioMenuItem) {
            ((RadioMenuItem)t2).selectedProperty().bindBidirectional((Property)action.selectedProperty());
        } else if (t2 instanceof CheckMenuItem) {
            ((CheckMenuItem)t2).selectedProperty().bindBidirectional((Property)action.selectedProperty());
        }
        t2.setOnAction((EventHandler)action);
        return t2;
    }

    private static void unconfigure(MenuItem menuItem) {
        if (menuItem == null || !(menuItem.getOnAction() instanceof Action)) {
            return;
        }
        Action action = (Action)menuItem.getOnAction();
        menuItem.styleProperty().unbind();
        menuItem.textProperty().unbind();
        menuItem.disableProperty().unbind();
        menuItem.acceleratorProperty().unbind();
        menuItem.graphicProperty().unbind();
        action.getProperties().removeListener(new MenuItemPropertiesMapChangeListener<MenuItem>(menuItem, action));
        if (menuItem instanceof RadioMenuItem) {
            ((RadioMenuItem)menuItem).selectedProperty().unbindBidirectional((Property)action.selectedProperty());
        } else if (menuItem instanceof CheckMenuItem) {
            ((CheckMenuItem)menuItem).selectedProperty().unbindBidirectional((Property)action.selectedProperty());
        }
        menuItem.setOnAction(null);
    }

    private static class MenuItemPropertiesMapChangeListener<T extends MenuItem>
    implements MapChangeListener<Object, Object> {
        private final WeakReference<T> menuItemWeakReference;
        private final Action action;

        private MenuItemPropertiesMapChangeListener(T t2, Action action) {
            this.menuItemWeakReference = new WeakReference<T>(t2);
            this.action = action;
        }

        public void onChanged(MapChangeListener.Change<?, ?> change) {
            MenuItem menuItem = (MenuItem)this.menuItemWeakReference.get();
            if (menuItem == null) {
                this.action.getProperties().removeListener((MapChangeListener)this);
            } else {
                menuItem.getProperties().clear();
                menuItem.getProperties().putAll(this.action.getProperties());
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            MenuItemPropertiesMapChangeListener menuItemPropertiesMapChangeListener = (MenuItemPropertiesMapChangeListener)object;
            MenuItem menuItem = (MenuItem)this.menuItemWeakReference.get();
            MenuItem menuItem2 = (MenuItem)menuItemPropertiesMapChangeListener.menuItemWeakReference.get();
            return menuItem != null ? menuItem.equals(menuItem2) : menuItem2 == null && this.action.equals(menuItemPropertiesMapChangeListener.action);
        }

        public int hashCode() {
            MenuItem menuItem = (MenuItem)this.menuItemWeakReference.get();
            int n2 = menuItem != null ? menuItem.hashCode() : 0;
            n2 = 31 * n2 + this.action.hashCode();
            return n2;
        }
    }

    private static class ButtonPropertiesMapChangeListener<T extends ButtonBase>
    implements MapChangeListener<Object, Object> {
        private final WeakReference<T> btnWeakReference;
        private final Action action;

        private ButtonPropertiesMapChangeListener(T t2, Action action) {
            this.btnWeakReference = new WeakReference<T>(t2);
            this.action = action;
        }

        public void onChanged(MapChangeListener.Change<?, ?> change) {
            ButtonBase buttonBase = (ButtonBase)this.btnWeakReference.get();
            if (buttonBase == null) {
                this.action.getProperties().removeListener((MapChangeListener)this);
            } else {
                buttonBase.getProperties().clear();
                buttonBase.getProperties().putAll(this.action.getProperties());
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ButtonPropertiesMapChangeListener buttonPropertiesMapChangeListener = (ButtonPropertiesMapChangeListener)object;
            ButtonBase buttonBase = (ButtonBase)this.btnWeakReference.get();
            ButtonBase buttonBase2 = (ButtonBase)buttonPropertiesMapChangeListener.btnWeakReference.get();
            if (buttonBase != null ? !buttonBase.equals(buttonBase2) : buttonBase2 != null) {
                return false;
            }
            return this.action.equals(buttonPropertiesMapChangeListener.action);
        }

        public int hashCode() {
            ButtonBase buttonBase = (ButtonBase)this.btnWeakReference.get();
            int n2 = buttonBase != null ? buttonBase.hashCode() : 0;
            n2 = 31 * n2 + this.action.hashCode();
            return n2;
        }
    }

    public static enum ActionTextBehavior {
        SHOW,
        HIDE;

    }
}

